/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.CRLReason;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.TBSCertList;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;

public class V2TBSCertListGenerator {
    private ASN1Integer version = new ASN1Integer(1);
    private AlgorithmIdentifier signature;
    private X500Name issuer;
    private Time thisUpdate;
    private Time nextUpdate = null;
    private Extensions extensions = null;
    private ASN1EncodableVector crlentries = new ASN1EncodableVector();
    private static final ASN1Sequence[] reasons = new ASN1Sequence[11];

    public void setSignature(AlgorithmIdentifier signature) {
        this.signature = signature;
    }

    public void setIssuer(X509Name issuer) {
        this.issuer = X500Name.getInstance(issuer.toASN1Primitive());
    }

    public void setIssuer(X500Name issuer) {
        this.issuer = issuer;
    }

    public void setThisUpdate(DERUTCTime thisUpdate) {
        this.thisUpdate = new Time(thisUpdate);
    }

    public void setNextUpdate(DERUTCTime nextUpdate) {
        this.nextUpdate = new Time(nextUpdate);
    }

    public void setThisUpdate(Time thisUpdate) {
        this.thisUpdate = thisUpdate;
    }

    public void setNextUpdate(Time nextUpdate) {
        this.nextUpdate = nextUpdate;
    }

    public void addCRLEntry(ASN1Sequence crlEntry) {
        this.crlentries.add(crlEntry);
    }

    public void addCRLEntry(ASN1Integer userCertificate, DERUTCTime revocationDate, int reason) {
        this.addCRLEntry(userCertificate, new Time(revocationDate), reason);
    }

    public void addCRLEntry(ASN1Integer userCertificate, Time revocationDate, int reason) {
        this.addCRLEntry(userCertificate, revocationDate, reason, null);
    }

    public void addCRLEntry(ASN1Integer userCertificate, Time revocationDate, int reason, DERGeneralizedTime invalidityDate) {
        if (reason != 0) {
            ASN1EncodableVector v2 = new ASN1EncodableVector();
            if (reason < reasons.length) {
                if (reason < 0) {
                    throw new IllegalArgumentException("invalid reason value: " + reason);
                }
                v2.add(reasons[reason]);
            } else {
                v2.add(V2TBSCertListGenerator.createReasonExtension(reason));
            }
            if (invalidityDate != null) {
                v2.add(V2TBSCertListGenerator.createInvalidityDateExtension(revocationDate));
            }
            this.internalAddCRLEntry(userCertificate, revocationDate, new DERSequence(v2));
        } else if (invalidityDate != null) {
            ASN1EncodableVector v3 = new ASN1EncodableVector();
            v3.add(V2TBSCertListGenerator.createInvalidityDateExtension(revocationDate));
            this.internalAddCRLEntry(userCertificate, revocationDate, new DERSequence(v3));
        } else {
            this.addCRLEntry(userCertificate, revocationDate, null);
        }
    }

    private void internalAddCRLEntry(ASN1Integer userCertificate, Time revocationDate, ASN1Sequence extensions) {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(userCertificate);
        v2.add(revocationDate);
        if (extensions != null) {
            v2.add(extensions);
        }
        this.addCRLEntry(new DERSequence(v2));
    }

    public void addCRLEntry(ASN1Integer userCertificate, Time revocationDate, Extensions extensions) {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(userCertificate);
        v2.add(revocationDate);
        if (extensions != null) {
            v2.add(extensions);
        }
        this.addCRLEntry(new DERSequence(v2));
    }

    public void setExtensions(X509Extensions extensions) {
        this.setExtensions(Extensions.getInstance(extensions));
    }

    public void setExtensions(Extensions extensions) {
        this.extensions = extensions;
    }

    public TBSCertList generateTBSCertList() {
        if (this.signature == null || this.issuer == null || this.thisUpdate == null) {
            throw new IllegalStateException("Not all mandatory fields set in V2 TBSCertList generator.");
        }
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(this.version);
        v2.add(this.signature);
        v2.add(this.issuer);
        v2.add(this.thisUpdate);
        if (this.nextUpdate != null) {
            v2.add(this.nextUpdate);
        }
        if (this.crlentries.size() != 0) {
            v2.add(new DERSequence(this.crlentries));
        }
        if (this.extensions != null) {
            v2.add(new DERTaggedObject(0, this.extensions));
        }
        return new TBSCertList(new DERSequence(v2));
    }

    private static ASN1Sequence createReasonExtension(int reasonCode) {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        CRLReason crlReason = CRLReason.lookup(reasonCode);
        try {
            v2.add(X509Extension.reasonCode);
            v2.add(new DEROctetString(crlReason.getEncoded()));
        }
        catch (IOException e2) {
            throw new IllegalArgumentException("error encoding reason: " + e2);
        }
        return new DERSequence(v2);
    }

    private static ASN1Sequence createInvalidityDateExtension(Time invalidityDate) {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        try {
            v2.add(X509Extension.invalidityDate);
            v2.add(new DEROctetString(invalidityDate.getEncoded()));
        }
        catch (IOException e2) {
            throw new IllegalArgumentException("error encoding reason: " + e2);
        }
        return new DERSequence(v2);
    }

    static {
        V2TBSCertListGenerator.reasons[0] = V2TBSCertListGenerator.createReasonExtension(0);
        V2TBSCertListGenerator.reasons[1] = V2TBSCertListGenerator.createReasonExtension(1);
        V2TBSCertListGenerator.reasons[2] = V2TBSCertListGenerator.createReasonExtension(2);
        V2TBSCertListGenerator.reasons[3] = V2TBSCertListGenerator.createReasonExtension(3);
        V2TBSCertListGenerator.reasons[4] = V2TBSCertListGenerator.createReasonExtension(4);
        V2TBSCertListGenerator.reasons[5] = V2TBSCertListGenerator.createReasonExtension(5);
        V2TBSCertListGenerator.reasons[6] = V2TBSCertListGenerator.createReasonExtension(6);
        V2TBSCertListGenerator.reasons[7] = V2TBSCertListGenerator.createReasonExtension(7);
        V2TBSCertListGenerator.reasons[8] = V2TBSCertListGenerator.createReasonExtension(8);
        V2TBSCertListGenerator.reasons[9] = V2TBSCertListGenerator.createReasonExtension(9);
        V2TBSCertListGenerator.reasons[10] = V2TBSCertListGenerator.createReasonExtension(10);
    }
}

