/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.util.Enumeration;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.Attribute;

public class SubjectDirectoryAttributes
extends ASN1Object {
    private Vector attributes = new Vector();

    public static SubjectDirectoryAttributes getInstance(Object obj) {
        if (obj instanceof SubjectDirectoryAttributes) {
            return (SubjectDirectoryAttributes)obj;
        }
        if (obj != null) {
            return new SubjectDirectoryAttributes(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private SubjectDirectoryAttributes(ASN1Sequence seq) {
        Enumeration e2 = seq.getObjects();
        while (e2.hasMoreElements()) {
            ASN1Sequence s2 = ASN1Sequence.getInstance(e2.nextElement());
            this.attributes.addElement(Attribute.getInstance(s2));
        }
    }

    public SubjectDirectoryAttributes(Vector attributes) {
        Enumeration e2 = attributes.elements();
        while (e2.hasMoreElements()) {
            this.attributes.addElement(e2.nextElement());
        }
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vec = new ASN1EncodableVector();
        Enumeration e2 = this.attributes.elements();
        while (e2.hasMoreElements()) {
            vec.add((Attribute)e2.nextElement());
        }
        return new DERSequence(vec);
    }

    public Vector getAttributes() {
        return this.attributes;
    }
}

