/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.Extension;

public class Extensions
extends ASN1Object {
    private Hashtable extensions = new Hashtable();
    private Vector ordering = new Vector();

    public static Extensions getInstance(ASN1TaggedObject obj, boolean explicit) {
        return Extensions.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static Extensions getInstance(Object obj) {
        if (obj instanceof Extensions) {
            return (Extensions)obj;
        }
        if (obj != null) {
            return new Extensions(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private Extensions(ASN1Sequence seq) {
        Enumeration e2 = seq.getObjects();
        while (e2.hasMoreElements()) {
            ASN1Sequence s2 = ASN1Sequence.getInstance(e2.nextElement());
            if (s2.size() == 3) {
                this.extensions.put(s2.getObjectAt(0), new Extension(ASN1ObjectIdentifier.getInstance(s2.getObjectAt(0)), ASN1Boolean.getInstance(s2.getObjectAt(1)), ASN1OctetString.getInstance(s2.getObjectAt(2))));
            } else if (s2.size() == 2) {
                this.extensions.put(s2.getObjectAt(0), new Extension(ASN1ObjectIdentifier.getInstance(s2.getObjectAt(0)), false, ASN1OctetString.getInstance(s2.getObjectAt(1))));
            } else {
                throw new IllegalArgumentException("Bad sequence size: " + s2.size());
            }
            this.ordering.addElement(s2.getObjectAt(0));
        }
    }

    public Extensions(Extension[] extensions) {
        for (int i2 = 0; i2 != extensions.length; ++i2) {
            Extension ext = extensions[i2];
            this.ordering.addElement(ext.getExtnId());
            this.extensions.put(ext.getExtnId(), ext);
        }
    }

    public Enumeration oids() {
        return this.ordering.elements();
    }

    public Extension getExtension(ASN1ObjectIdentifier oid) {
        return (Extension)this.extensions.get(oid);
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vec = new ASN1EncodableVector();
        Enumeration e2 = this.ordering.elements();
        while (e2.hasMoreElements()) {
            ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)e2.nextElement();
            Extension ext = (Extension)this.extensions.get(oid);
            ASN1EncodableVector v2 = new ASN1EncodableVector();
            v2.add(oid);
            if (ext.isCritical()) {
                v2.add(ASN1Boolean.getInstance(true));
            }
            v2.add(ext.getExtnValue());
            vec.add(new DERSequence(v2));
        }
        return new DERSequence(vec);
    }

    public boolean equivalent(Extensions other) {
        if (this.extensions.size() != other.extensions.size()) {
            return false;
        }
        Enumeration e1 = this.extensions.keys();
        while (e1.hasMoreElements()) {
            Object key = e1.nextElement();
            if (this.extensions.get(key).equals(other.extensions.get(key))) continue;
            return false;
        }
        return true;
    }

    public ASN1ObjectIdentifier[] getExtensionOIDs() {
        return this.toOidArray(this.ordering);
    }

    public ASN1ObjectIdentifier[] getNonCriticalExtensionOIDs() {
        return this.getExtensionOIDs(false);
    }

    public ASN1ObjectIdentifier[] getCriticalExtensionOIDs() {
        return this.getExtensionOIDs(true);
    }

    private ASN1ObjectIdentifier[] getExtensionOIDs(boolean isCritical) {
        Vector oidVec = new Vector();
        for (int i2 = 0; i2 != this.ordering.size(); ++i2) {
            Object oid = this.ordering.elementAt(i2);
            if (((Extension)this.extensions.get(oid)).isCritical() != isCritical) continue;
            oidVec.addElement(oid);
        }
        return this.toOidArray(oidVec);
    }

    private ASN1ObjectIdentifier[] toOidArray(Vector oidVec) {
        ASN1ObjectIdentifier[] oids = new ASN1ObjectIdentifier[oidVec.size()];
        for (int i2 = 0; i2 != oids.length; ++i2) {
            oids[i2] = (ASN1ObjectIdentifier)oidVec.elementAt(i2);
        }
        return oids;
    }
}

