/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.sec;

import java.math.BigInteger;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.util.BigIntegers;

public class ECPrivateKey
extends ASN1Object {
    private ASN1Sequence seq;

    private ECPrivateKey(ASN1Sequence seq) {
        this.seq = seq;
    }

    public static ECPrivateKey getInstance(Object obj) {
        if (obj instanceof ECPrivateKey) {
            return (ECPrivateKey)obj;
        }
        if (obj != null) {
            return new ECPrivateKey(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public ECPrivateKey(BigInteger key) {
        byte[] bytes = BigIntegers.asUnsignedByteArray(key);
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(new ASN1Integer(1));
        v2.add(new DEROctetString(bytes));
        this.seq = new DERSequence(v2);
    }

    public ECPrivateKey(BigInteger key, ASN1Object parameters) {
        this(key, null, parameters);
    }

    public ECPrivateKey(BigInteger key, DERBitString publicKey, ASN1Object parameters) {
        byte[] bytes = BigIntegers.asUnsignedByteArray(key);
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(new ASN1Integer(1));
        v2.add(new DEROctetString(bytes));
        if (parameters != null) {
            v2.add(new DERTaggedObject(true, 0, parameters));
        }
        if (publicKey != null) {
            v2.add(new DERTaggedObject(true, 1, publicKey));
        }
        this.seq = new DERSequence(v2);
    }

    public BigInteger getKey() {
        ASN1OctetString octs = (ASN1OctetString)this.seq.getObjectAt(1);
        return new BigInteger(1, octs.getOctets());
    }

    public DERBitString getPublicKey() {
        return (DERBitString)this.getObjectInTag(1);
    }

    public ASN1Primitive getParameters() {
        return this.getObjectInTag(0);
    }

    private ASN1Primitive getObjectInTag(int tagNo) {
        Enumeration e2 = this.seq.getObjects();
        while (e2.hasMoreElements()) {
            ASN1TaggedObject tag;
            ASN1Encodable obj = (ASN1Encodable)e2.nextElement();
            if (!(obj instanceof ASN1TaggedObject) || (tag = (ASN1TaggedObject)obj).getTagNo() != tagNo) continue;
            return tag.getObject().toASN1Primitive();
        }
        return null;
    }

    public ASN1Primitive toASN1Primitive() {
        return this.seq;
    }
}

