/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cmp;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cmp.CMPCertificate;
import org.bouncycastle.asn1.cmp.CertifiedKeyPair;
import org.bouncycastle.asn1.cmp.PKIStatusInfo;

public class KeyRecRepContent
extends ASN1Object {
    private PKIStatusInfo status;
    private CMPCertificate newSigCert;
    private ASN1Sequence caCerts;
    private ASN1Sequence keyPairHist;

    private KeyRecRepContent(ASN1Sequence seq) {
        Enumeration en = seq.getObjects();
        this.status = PKIStatusInfo.getInstance(en.nextElement());
        block5: while (en.hasMoreElements()) {
            ASN1TaggedObject tObj = ASN1TaggedObject.getInstance(en.nextElement());
            switch (tObj.getTagNo()) {
                case 0: {
                    this.newSigCert = CMPCertificate.getInstance(tObj.getObject());
                    continue block5;
                }
                case 1: {
                    this.caCerts = ASN1Sequence.getInstance(tObj.getObject());
                    continue block5;
                }
                case 2: {
                    this.keyPairHist = ASN1Sequence.getInstance(tObj.getObject());
                    continue block5;
                }
            }
            throw new IllegalArgumentException("unknown tag number: " + tObj.getTagNo());
        }
    }

    public static KeyRecRepContent getInstance(Object o2) {
        if (o2 instanceof KeyRecRepContent) {
            return (KeyRecRepContent)o2;
        }
        if (o2 != null) {
            return new KeyRecRepContent(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public PKIStatusInfo getStatus() {
        return this.status;
    }

    public CMPCertificate getNewSigCert() {
        return this.newSigCert;
    }

    public CMPCertificate[] getCaCerts() {
        if (this.caCerts == null) {
            return null;
        }
        CMPCertificate[] results = new CMPCertificate[this.caCerts.size()];
        for (int i2 = 0; i2 != results.length; ++i2) {
            results[i2] = CMPCertificate.getInstance(this.caCerts.getObjectAt(i2));
        }
        return results;
    }

    public CertifiedKeyPair[] getKeyPairHist() {
        if (this.keyPairHist == null) {
            return null;
        }
        CertifiedKeyPair[] results = new CertifiedKeyPair[this.keyPairHist.size()];
        for (int i2 = 0; i2 != results.length; ++i2) {
            results[i2] = CertifiedKeyPair.getInstance(this.keyPairHist.getObjectAt(i2));
        }
        return results;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(this.status);
        this.addOptional(v2, 0, this.newSigCert);
        this.addOptional(v2, 1, this.caCerts);
        this.addOptional(v2, 2, this.keyPairHist);
        return new DERSequence(v2);
    }

    private void addOptional(ASN1EncodableVector v2, int tagNo, ASN1Encodable obj) {
        if (obj != null) {
            v2.add(new DERTaggedObject(true, tagNo, obj));
        }
    }
}

