/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.StreamUtil;

public class DERSet
extends ASN1Set {
    private int bodyLength = -1;

    public DERSet() {
    }

    public DERSet(ASN1Encodable obj) {
        super(obj);
    }

    public DERSet(ASN1EncodableVector v2) {
        super(v2, true);
    }

    public DERSet(ASN1Encodable[] a2) {
        super(a2, true);
    }

    DERSet(ASN1EncodableVector v2, boolean doSort) {
        super(v2, doSort);
    }

    private int getBodyLength() throws IOException {
        if (this.bodyLength < 0) {
            int length = 0;
            Enumeration e2 = this.getObjects();
            while (e2.hasMoreElements()) {
                Object obj = e2.nextElement();
                length += ((ASN1Encodable)obj).toASN1Primitive().toDERObject().encodedLength();
            }
            this.bodyLength = length;
        }
        return this.bodyLength;
    }

    int encodedLength() throws IOException {
        int length = this.getBodyLength();
        return 1 + StreamUtil.calculateBodyLength(length) + length;
    }

    void encode(ASN1OutputStream out) throws IOException {
        ASN1OutputStream dOut = out.getDERSubStream();
        int length = this.getBodyLength();
        out.write(49);
        out.writeLength(length);
        Enumeration e2 = this.getObjects();
        while (e2.hasMoreElements()) {
            Object obj = e2.nextElement();
            dOut.writeObject((ASN1Encodable)obj);
        }
    }
}

