/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class ReaderInputStream
extends InputStream {
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private final Reader reader;
    private final CharsetEncoder encoder;
    private final CharBuffer encoderIn;
    private final ByteBuffer encoderOut = ByteBuffer.allocate(128);
    private CoderResult lastCoderResult;
    private boolean endOfInput;

    public ReaderInputStream(Reader reader, CharsetEncoder encoder) {
        this(reader, encoder, 1024);
    }

    public ReaderInputStream(Reader reader, CharsetEncoder encoder, int bufferSize) {
        this.reader = reader;
        this.encoder = encoder;
        this.encoderIn = CharBuffer.allocate(bufferSize);
        this.encoderIn.flip();
    }

    public ReaderInputStream(Reader reader, Charset charset, int bufferSize) {
        this(reader, charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE), bufferSize);
    }

    public ReaderInputStream(Reader reader, Charset charset) {
        this(reader, charset, 1024);
    }

    public ReaderInputStream(Reader reader, String charsetName, int bufferSize) {
        this(reader, Charset.forName(charsetName), bufferSize);
    }

    public ReaderInputStream(Reader reader, String charsetName) {
        this(reader, charsetName, 1024);
    }

    public ReaderInputStream(Reader reader) {
        this(reader, Charset.defaultCharset());
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        int read = 0;
        while (len > 0) {
            if (this.encoderOut.position() > 0) {
                this.encoderOut.flip();
                int c2 = Math.min(this.encoderOut.remaining(), len);
                this.encoderOut.get(b2, off, c2);
                off += c2;
                len -= c2;
                read += c2;
                this.encoderOut.compact();
                continue;
            }
            if (!this.endOfInput && (this.lastCoderResult == null || this.lastCoderResult.isUnderflow())) {
                this.encoderIn.compact();
                int position = this.encoderIn.position();
                int c3 = this.reader.read(this.encoderIn.array(), position, this.encoderIn.remaining());
                if (c3 == -1) {
                    this.endOfInput = true;
                } else {
                    this.encoderIn.position(position + c3);
                }
                this.encoderIn.flip();
            }
            this.lastCoderResult = this.encoder.encode(this.encoderIn, this.encoderOut, this.endOfInput);
            if (!this.endOfInput || this.encoderOut.position() != 0) continue;
        }
        return read == 0 && this.endOfInput ? -1 : read;
    }

    public int read(byte[] b2) throws IOException {
        return this.read(b2, 0, b2.length);
    }

    public int read() throws IOException {
        byte[] b2 = new byte[1];
        return this.read(b2) == -1 ? -1 : b2[0] & 0xFF;
    }

    public void close() throws IOException {
        this.reader.close();
    }
}

