/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.util.Iterator;
import java.util.LinkedList;
import org.apache.batik.anim.values.AnimatableNumberOptionalNumberValue;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSNavigableNode;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.value.ShorthandManager;
import org.apache.batik.css.engine.value.ValueManager;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.AbstractStylableDocument;
import org.apache.batik.dom.anim.AnimationTarget;
import org.apache.batik.dom.anim.AnimationTargetListener;
import org.apache.batik.dom.svg.AbstractElement;
import org.apache.batik.dom.svg.AbstractSVGAnimatedValue;
import org.apache.batik.dom.svg.AnimatedLiveAttributeValue;
import org.apache.batik.dom.svg.ExtendedTraitAccess;
import org.apache.batik.dom.svg.LiveAttributeValue;
import org.apache.batik.dom.svg.SVGContext;
import org.apache.batik.dom.svg.SVGOMAnimatedBoolean;
import org.apache.batik.dom.svg.SVGOMAnimatedEnumeration;
import org.apache.batik.dom.svg.SVGOMAnimatedInteger;
import org.apache.batik.dom.svg.SVGOMAnimatedLength;
import org.apache.batik.dom.svg.SVGOMAnimatedLengthList;
import org.apache.batik.dom.svg.SVGOMAnimatedMarkerOrientValue;
import org.apache.batik.dom.svg.SVGOMAnimatedNumber;
import org.apache.batik.dom.svg.SVGOMAnimatedNumberList;
import org.apache.batik.dom.svg.SVGOMAnimatedPathData;
import org.apache.batik.dom.svg.SVGOMAnimatedPoints;
import org.apache.batik.dom.svg.SVGOMAnimatedPreserveAspectRatio;
import org.apache.batik.dom.svg.SVGOMAnimatedRect;
import org.apache.batik.dom.svg.SVGOMAnimatedString;
import org.apache.batik.dom.svg.SVGOMAnimatedTransformList;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.svg.SVGOMException;
import org.apache.batik.dom.svg.TraitInformation;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.parser.UnitProcessor;
import org.apache.batik.util.DoublyIndexedTable;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGAnimatedInteger;
import org.w3c.dom.svg.SVGAnimatedNumber;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGFitToViewBox;
import org.w3c.dom.svg.SVGSVGElement;

public abstract class SVGOMElement
extends AbstractElement
implements SVGElement,
ExtendedTraitAccess,
AnimationTarget {
    protected static DoublyIndexedTable xmlTraitInformation;
    protected transient boolean readonly;
    protected String prefix;
    protected transient SVGContext svgContext;
    protected DoublyIndexedTable targetListeners;
    protected UnitProcessor.Context unitContext;

    protected SVGOMElement() {
    }

    protected SVGOMElement(String prefix, AbstractDocument owner) {
        super(prefix, owner);
    }

    protected void initializeAllLiveAttributes() {
    }

    public String getId() {
        Attr a2;
        if (((SVGOMDocument)this.ownerDocument).isSVG12 && (a2 = this.getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "id")) != null) {
            return a2.getNodeValue();
        }
        return this.getAttributeNS(null, "id");
    }

    public void setId(String id) {
        if (((SVGOMDocument)this.ownerDocument).isSVG12) {
            this.setAttributeNS("http://www.w3.org/XML/1998/namespace", "id", id);
            Attr a2 = this.getAttributeNodeNS(null, "id");
            if (a2 != null) {
                a2.setNodeValue(id);
            }
        } else {
            this.setAttributeNS(null, "id", id);
        }
    }

    public String getXMLbase() {
        return this.getAttributeNS("http://www.w3.org/XML/1998/namespace", "base");
    }

    public void setXMLbase(String xmlbase) throws DOMException {
        this.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:base", xmlbase);
    }

    public SVGSVGElement getOwnerSVGElement() {
        CSSStylableElement e2 = CSSEngine.getParentCSSStylableElement(this);
        while (e2 != null) {
            if (e2 instanceof SVGSVGElement) {
                return (SVGSVGElement)((Object)e2);
            }
            e2 = CSSEngine.getParentCSSStylableElement(e2);
        }
        return null;
    }

    public SVGElement getViewportElement() {
        CSSStylableElement e2 = CSSEngine.getParentCSSStylableElement(this);
        while (e2 != null) {
            if (e2 instanceof SVGFitToViewBox) {
                return (SVGElement)((Object)e2);
            }
            e2 = CSSEngine.getParentCSSStylableElement(e2);
        }
        return null;
    }

    public String getNodeName() {
        if (this.prefix == null || this.prefix.equals("")) {
            return this.getLocalName();
        }
        return this.prefix + ':' + this.getLocalName();
    }

    public String getNamespaceURI() {
        return "http://www.w3.org/2000/svg";
    }

    public void setPrefix(String prefix) throws DOMException {
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
        }
        if (prefix != null && !prefix.equals("") && !DOMUtilities.isValidName(prefix)) {
            throw this.createDOMException((short)5, "prefix", new Object[]{new Integer(this.getNodeType()), this.getNodeName(), prefix});
        }
        this.prefix = prefix;
    }

    protected String getCascadedXMLBase(Node node) {
        String base = null;
        Node n2 = node.getParentNode();
        while (n2 != null) {
            if (n2.getNodeType() == 1) {
                base = this.getCascadedXMLBase(n2);
                break;
            }
            n2 = n2 instanceof CSSNavigableNode ? ((CSSNavigableNode)((Object)n2)).getCSSParentNode() : n2.getParentNode();
        }
        if (base == null) {
            AbstractDocument doc = node.getNodeType() == 9 ? (AbstractDocument)node : (AbstractDocument)node.getOwnerDocument();
            base = doc.getDocumentURI();
        }
        while (node != null && node.getNodeType() != 1) {
            node = node.getParentNode();
        }
        if (node == null) {
            return base;
        }
        Element e2 = (Element)node;
        Attr attr = e2.getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "base");
        if (attr != null) {
            base = base == null ? attr.getNodeValue() : new ParsedURL(base, attr.getNodeValue()).toString();
        }
        return base;
    }

    public void setSVGContext(SVGContext ctx) {
        this.svgContext = ctx;
    }

    public SVGContext getSVGContext() {
        return this.svgContext;
    }

    public SVGException createSVGException(short type, String key, Object[] args) {
        try {
            return new SVGOMException(type, this.getCurrentDocument().formatMessage(key, args));
        }
        catch (Exception e2) {
            return new SVGOMException(type, key);
        }
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean v2) {
        this.readonly = v2;
    }

    protected DoublyIndexedTable getTraitInformationTable() {
        return xmlTraitInformation;
    }

    protected SVGOMAnimatedTransformList createLiveAnimatedTransformList(String ns, String ln, String def) {
        SVGOMAnimatedTransformList v2 = new SVGOMAnimatedTransformList(this, ns, ln, def);
        this.liveAttributeValues.put(ns, ln, v2);
        v2.addAnimatedAttributeListener(((SVGOMDocument)this.ownerDocument).getAnimatedAttributeListener());
        return v2;
    }

    protected SVGOMAnimatedBoolean createLiveAnimatedBoolean(String ns, String ln, boolean def) {
        SVGOMAnimatedBoolean v2 = new SVGOMAnimatedBoolean(this, ns, ln, def);
        this.liveAttributeValues.put(ns, ln, v2);
        v2.addAnimatedAttributeListener(((SVGOMDocument)this.ownerDocument).getAnimatedAttributeListener());
        return v2;
    }

    protected SVGOMAnimatedString createLiveAnimatedString(String ns, String ln) {
        SVGOMAnimatedString v2 = new SVGOMAnimatedString(this, ns, ln);
        this.liveAttributeValues.put(ns, ln, v2);
        v2.addAnimatedAttributeListener(((SVGOMDocument)this.ownerDocument).getAnimatedAttributeListener());
        return v2;
    }

    protected SVGOMAnimatedPreserveAspectRatio createLiveAnimatedPreserveAspectRatio() {
        SVGOMAnimatedPreserveAspectRatio v2 = new SVGOMAnimatedPreserveAspectRatio(this);
        this.liveAttributeValues.put(null, "preserveAspectRatio", v2);
        v2.addAnimatedAttributeListener(((SVGOMDocument)this.ownerDocument).getAnimatedAttributeListener());
        return v2;
    }

    protected SVGOMAnimatedMarkerOrientValue createLiveAnimatedMarkerOrientValue(String ns, String ln) {
        SVGOMAnimatedMarkerOrientValue v2 = new SVGOMAnimatedMarkerOrientValue(this, ns, ln);
        this.liveAttributeValues.put(ns, ln, v2);
        v2.addAnimatedAttributeListener(((SVGOMDocument)this.ownerDocument).getAnimatedAttributeListener());
        return v2;
    }

    protected SVGOMAnimatedPathData createLiveAnimatedPathData(String ns, String ln, String def) {
        SVGOMAnimatedPathData v2 = new SVGOMAnimatedPathData(this, ns, ln, def);
        this.liveAttributeValues.put(ns, ln, v2);
        v2.addAnimatedAttributeListener(((SVGOMDocument)this.ownerDocument).getAnimatedAttributeListener());
        return v2;
    }

    protected SVGOMAnimatedNumber createLiveAnimatedNumber(String ns, String ln, float def) {
        return this.createLiveAnimatedNumber(ns, ln, def, false);
    }

    protected SVGOMAnimatedNumber createLiveAnimatedNumber(String ns, String ln, float def, boolean allowPercentage) {
        SVGOMAnimatedNumber v2 = new SVGOMAnimatedNumber(this, ns, ln, def, allowPercentage);
        this.liveAttributeValues.put(ns, ln, v2);
        v2.addAnimatedAttributeListener(((SVGOMDocument)this.ownerDocument).getAnimatedAttributeListener());
        return v2;
    }

    protected SVGOMAnimatedNumberList createLiveAnimatedNumberList(String ns, String ln, String def, boolean canEmpty) {
        SVGOMAnimatedNumberList v2 = new SVGOMAnimatedNumberList(this, ns, ln, def, canEmpty);
        this.liveAttributeValues.put(ns, ln, v2);
        v2.addAnimatedAttributeListener(((SVGOMDocument)this.ownerDocument).getAnimatedAttributeListener());
        return v2;
    }

    protected SVGOMAnimatedPoints createLiveAnimatedPoints(String ns, String ln, String def) {
        SVGOMAnimatedPoints v2 = new SVGOMAnimatedPoints(this, ns, ln, def);
        this.liveAttributeValues.put(ns, ln, v2);
        v2.addAnimatedAttributeListener(((SVGOMDocument)this.ownerDocument).getAnimatedAttributeListener());
        return v2;
    }

    protected SVGOMAnimatedLengthList createLiveAnimatedLengthList(String ns, String ln, String def, boolean emptyAllowed, short dir) {
        SVGOMAnimatedLengthList v2 = new SVGOMAnimatedLengthList(this, ns, ln, def, emptyAllowed, dir);
        this.liveAttributeValues.put(ns, ln, v2);
        v2.addAnimatedAttributeListener(((SVGOMDocument)this.ownerDocument).getAnimatedAttributeListener());
        return v2;
    }

    protected SVGOMAnimatedInteger createLiveAnimatedInteger(String ns, String ln, int def) {
        SVGOMAnimatedInteger v2 = new SVGOMAnimatedInteger(this, ns, ln, def);
        this.liveAttributeValues.put(ns, ln, v2);
        v2.addAnimatedAttributeListener(((SVGOMDocument)this.ownerDocument).getAnimatedAttributeListener());
        return v2;
    }

    protected SVGOMAnimatedEnumeration createLiveAnimatedEnumeration(String ns, String ln, String[] val, short def) {
        SVGOMAnimatedEnumeration v2 = new SVGOMAnimatedEnumeration(this, ns, ln, val, def);
        this.liveAttributeValues.put(ns, ln, v2);
        v2.addAnimatedAttributeListener(((SVGOMDocument)this.ownerDocument).getAnimatedAttributeListener());
        return v2;
    }

    protected SVGOMAnimatedLength createLiveAnimatedLength(String ns, String ln, String val, short dir, boolean nonneg) {
        SVGOMAnimatedLength v2 = new SVGOMAnimatedLength(this, ns, ln, val, dir, nonneg);
        this.liveAttributeValues.put(ns, ln, v2);
        v2.addAnimatedAttributeListener(((SVGOMDocument)this.ownerDocument).getAnimatedAttributeListener());
        return v2;
    }

    protected SVGOMAnimatedRect createLiveAnimatedRect(String ns, String ln, String value) {
        SVGOMAnimatedRect v2 = new SVGOMAnimatedRect(this, ns, ln, value);
        this.liveAttributeValues.put(ns, ln, v2);
        v2.addAnimatedAttributeListener(((SVGOMDocument)this.ownerDocument).getAnimatedAttributeListener());
        return v2;
    }

    public boolean hasProperty(String pn) {
        AbstractStylableDocument doc = (AbstractStylableDocument)this.ownerDocument;
        CSSEngine eng = doc.getCSSEngine();
        return eng.getPropertyIndex(pn) != -1 || eng.getShorthandIndex(pn) != -1;
    }

    public boolean hasTrait(String ns, String ln) {
        return false;
    }

    public boolean isPropertyAnimatable(String pn) {
        AbstractStylableDocument doc = (AbstractStylableDocument)this.ownerDocument;
        CSSEngine eng = doc.getCSSEngine();
        int idx = eng.getPropertyIndex(pn);
        if (idx != -1) {
            ValueManager[] vms = eng.getValueManagers();
            return vms[idx].isAnimatableProperty();
        }
        idx = eng.getShorthandIndex(pn);
        if (idx != -1) {
            ShorthandManager[] sms = eng.getShorthandManagers();
            return sms[idx].isAnimatableProperty();
        }
        return false;
    }

    public final boolean isAttributeAnimatable(String ns, String ln) {
        DoublyIndexedTable t2 = this.getTraitInformationTable();
        TraitInformation ti = (TraitInformation)t2.get(ns, ln);
        if (ti != null) {
            return ti.isAnimatable();
        }
        return false;
    }

    public boolean isPropertyAdditive(String pn) {
        AbstractStylableDocument doc = (AbstractStylableDocument)this.ownerDocument;
        CSSEngine eng = doc.getCSSEngine();
        int idx = eng.getPropertyIndex(pn);
        if (idx != -1) {
            ValueManager[] vms = eng.getValueManagers();
            return vms[idx].isAdditiveProperty();
        }
        idx = eng.getShorthandIndex(pn);
        if (idx != -1) {
            ShorthandManager[] sms = eng.getShorthandManagers();
            return sms[idx].isAdditiveProperty();
        }
        return false;
    }

    public boolean isAttributeAdditive(String ns, String ln) {
        return true;
    }

    public boolean isTraitAnimatable(String ns, String tn) {
        return false;
    }

    public boolean isTraitAdditive(String ns, String tn) {
        return false;
    }

    public int getPropertyType(String pn) {
        AbstractStylableDocument doc = (AbstractStylableDocument)this.ownerDocument;
        CSSEngine eng = doc.getCSSEngine();
        int idx = eng.getPropertyIndex(pn);
        if (idx != -1) {
            ValueManager[] vms = eng.getValueManagers();
            return vms[idx].getPropertyType();
        }
        return 0;
    }

    public final int getAttributeType(String ns, String ln) {
        DoublyIndexedTable t2 = this.getTraitInformationTable();
        TraitInformation ti = (TraitInformation)t2.get(ns, ln);
        if (ti != null) {
            return ti.getType();
        }
        return 0;
    }

    public Element getElement() {
        return this;
    }

    public void updatePropertyValue(String pn, AnimatableValue val) {
    }

    public void updateAttributeValue(String ns, String ln, AnimatableValue val) {
        LiveAttributeValue a2 = this.getLiveAttributeValue(ns, ln);
        ((AbstractSVGAnimatedValue)a2).updateAnimatedValue(val);
    }

    public void updateOtherValue(String type, AnimatableValue val) {
    }

    public AnimatableValue getUnderlyingValue(String ns, String ln) {
        LiveAttributeValue a2 = this.getLiveAttributeValue(ns, ln);
        if (!(a2 instanceof AnimatedLiveAttributeValue)) {
            return null;
        }
        return ((AnimatedLiveAttributeValue)a2).getUnderlyingValue(this);
    }

    protected AnimatableValue getBaseValue(SVGAnimatedInteger n2, SVGAnimatedInteger on) {
        return new AnimatableNumberOptionalNumberValue((AnimationTarget)this, (float)n2.getBaseVal(), (float)on.getBaseVal());
    }

    protected AnimatableValue getBaseValue(SVGAnimatedNumber n2, SVGAnimatedNumber on) {
        return new AnimatableNumberOptionalNumberValue((AnimationTarget)this, n2.getBaseVal(), on.getBaseVal());
    }

    public short getPercentageInterpretation(String ns, String an, boolean isCSS) {
        if ((isCSS || ns == null) && (an.equals("baseline-shift") || an.equals("font-size"))) {
            return 0;
        }
        if (!isCSS) {
            DoublyIndexedTable t2 = this.getTraitInformationTable();
            TraitInformation ti = (TraitInformation)t2.get(ns, an);
            if (ti != null) {
                return ti.getPercentageInterpretation();
            }
            return 3;
        }
        return 3;
    }

    protected final short getAttributePercentageInterpretation(String ns, String ln) {
        return 3;
    }

    public boolean useLinearRGBColorInterpolation() {
        return false;
    }

    public float svgToUserSpace(float v2, short type, short pcInterp) {
        if (this.unitContext == null) {
            this.unitContext = new UnitContext();
        }
        if (pcInterp == 0 && type == 2) {
            return 0.0f;
        }
        return UnitProcessor.svgToUserSpace(v2, type, (short)(3 - pcInterp), this.unitContext);
    }

    public void addTargetListener(String ns, String an, boolean isCSS, AnimationTargetListener l2) {
        if (!isCSS) {
            LinkedList<AnimationTargetListener> ll;
            if (this.targetListeners == null) {
                this.targetListeners = new DoublyIndexedTable();
            }
            if ((ll = (LinkedList<AnimationTargetListener>)this.targetListeners.get(ns, an)) == null) {
                ll = new LinkedList<AnimationTargetListener>();
                this.targetListeners.put(ns, an, ll);
            }
            ll.add(l2);
        }
    }

    public void removeTargetListener(String ns, String an, boolean isCSS, AnimationTargetListener l2) {
        if (!isCSS) {
            LinkedList ll = (LinkedList)this.targetListeners.get(ns, an);
            ll.remove(l2);
        }
    }

    void fireBaseAttributeListeners(String ns, String ln) {
        if (this.targetListeners != null) {
            LinkedList ll = (LinkedList)this.targetListeners.get(ns, ln);
            Iterator it = ll.iterator();
            while (it.hasNext()) {
                AnimationTargetListener l2 = (AnimationTargetListener)it.next();
                l2.baseValueChanged(this, ns, ln, false);
            }
        }
    }

    protected Node export(Node n2, AbstractDocument d2) {
        super.export(n2, d2);
        SVGOMElement e2 = (SVGOMElement)n2;
        e2.prefix = this.prefix;
        e2.initializeAllLiveAttributes();
        return n2;
    }

    protected Node deepExport(Node n2, AbstractDocument d2) {
        super.deepExport(n2, d2);
        SVGOMElement e2 = (SVGOMElement)n2;
        e2.prefix = this.prefix;
        e2.initializeAllLiveAttributes();
        return n2;
    }

    protected Node copyInto(Node n2) {
        super.copyInto(n2);
        SVGOMElement e2 = (SVGOMElement)n2;
        e2.prefix = this.prefix;
        e2.initializeAllLiveAttributes();
        return n2;
    }

    protected Node deepCopyInto(Node n2) {
        super.deepCopyInto(n2);
        SVGOMElement e2 = (SVGOMElement)n2;
        e2.prefix = this.prefix;
        e2.initializeAllLiveAttributes();
        return n2;
    }

    static {
        DoublyIndexedTable t2 = new DoublyIndexedTable();
        t2.put(null, "id", new TraitInformation(false, 16));
        t2.put("http://www.w3.org/XML/1998/namespace", "base", new TraitInformation(false, 10));
        t2.put("http://www.w3.org/XML/1998/namespace", "space", new TraitInformation(false, 15));
        t2.put("http://www.w3.org/XML/1998/namespace", "id", new TraitInformation(false, 16));
        t2.put("http://www.w3.org/XML/1998/namespace", "lang", new TraitInformation(false, 45));
        xmlTraitInformation = t2;
    }

    protected class UnitContext
    implements UnitProcessor.Context {
        protected UnitContext() {
        }

        public Element getElement() {
            return SVGOMElement.this;
        }

        public float getPixelUnitToMillimeter() {
            return SVGOMElement.this.getSVGContext().getPixelUnitToMillimeter();
        }

        public float getPixelToMM() {
            return this.getPixelUnitToMillimeter();
        }

        public float getFontSize() {
            return SVGOMElement.this.getSVGContext().getFontSize();
        }

        public float getXHeight() {
            return 0.5f;
        }

        public float getViewportWidth() {
            return SVGOMElement.this.getSVGContext().getViewportWidth();
        }

        public float getViewportHeight() {
            return SVGOMElement.this.getSVGContext().getViewportHeight();
        }
    }
}

