/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.seekablestream.SeekableBufferedStream;
import htsjdk.samtools.seekablestream.SeekableFileStream;
import htsjdk.samtools.seekablestream.SeekableHTTPStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.CustomGzipOutputStream;
import htsjdk.samtools.util.IterableOnceIterator;
import htsjdk.samtools.util.Md5CalculatingOutputStream;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.Stack;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;

public class IOUtil {
    @Deprecated
    public static final int STANDARD_BUFFER_SIZE = Defaults.NON_ZERO_BUFFER_SIZE;
    public static final long ONE_GB = 0x40000000L;
    public static final long TWO_GBS = 0x80000000L;
    public static final long FIVE_GBS = 0x140000000L;
    public static final String[] VCF_EXTENSIONS = new String[]{".vcf", ".vcf.gz", ".bcf"};

    public static BufferedInputStream toBufferedStream(InputStream stream) {
        if (stream instanceof BufferedInputStream) {
            return (BufferedInputStream)stream;
        }
        return new BufferedInputStream(stream, Defaults.NON_ZERO_BUFFER_SIZE);
    }

    public static void transferByStream(InputStream in, OutputStream out, long bytes) {
        byte[] buffer = new byte[Defaults.NON_ZERO_BUFFER_SIZE];
        try {
            int read;
            for (long remaining = bytes; remaining > 0L; remaining -= (long)read) {
                read = in.read(buffer, 0, (int)Math.min((long)buffer.length, remaining));
                out.write(buffer, 0, read);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeIOException(ioe);
        }
    }

    public static OutputStream maybeBufferOutputStream(OutputStream os) {
        return IOUtil.maybeBufferOutputStream(os, Defaults.BUFFER_SIZE);
    }

    public static OutputStream maybeBufferOutputStream(OutputStream os, int bufferSize) {
        if (bufferSize > 0) {
            return new BufferedOutputStream(os, bufferSize);
        }
        return os;
    }

    public static SeekableStream maybeBufferedSeekableStream(SeekableStream stream, int bufferSize) {
        return bufferSize > 0 ? new SeekableBufferedStream(stream, bufferSize) : stream;
    }

    public static SeekableStream maybeBufferedSeekableStream(SeekableStream stream) {
        return IOUtil.maybeBufferedSeekableStream(stream, Defaults.BUFFER_SIZE);
    }

    public static SeekableStream maybeBufferedSeekableStream(File file) {
        try {
            return IOUtil.maybeBufferedSeekableStream(new SeekableFileStream(file));
        }
        catch (FileNotFoundException e2) {
            throw new RuntimeIOException(e2);
        }
    }

    public static SeekableStream maybeBufferedSeekableStream(URL url) {
        return IOUtil.maybeBufferedSeekableStream(new SeekableHTTPStream(url));
    }

    public static InputStream maybeBufferInputStream(InputStream is) {
        return IOUtil.maybeBufferInputStream(is, Defaults.BUFFER_SIZE);
    }

    public static InputStream maybeBufferInputStream(InputStream is, int bufferSize) {
        if (bufferSize > 0) {
            return new BufferedInputStream(is, bufferSize);
        }
        return is;
    }

    public static Reader maybeBufferReader(Reader reader, int bufferSize) {
        if (bufferSize > 0) {
            reader = new BufferedReader(reader, bufferSize);
        }
        return reader;
    }

    public static Reader maybeBufferReader(Reader reader) {
        return IOUtil.maybeBufferReader(reader, Defaults.BUFFER_SIZE);
    }

    public static Writer maybeBufferWriter(Writer writer, int bufferSize) {
        if (bufferSize > 0) {
            writer = new BufferedWriter(writer, bufferSize);
        }
        return writer;
    }

    public static Writer maybeBufferWriter(Writer writer) {
        return IOUtil.maybeBufferWriter(writer, Defaults.BUFFER_SIZE);
    }

    public static void deleteFiles(File ... files) {
        for (File f2 : files) {
            if (f2.delete()) continue;
            System.err.println("Could not delete file " + f2);
        }
    }

    public static void deleteFiles(Iterable<File> files) {
        for (File f2 : files) {
            if (f2.delete()) continue;
            System.err.println("Could not delete file " + f2);
        }
    }

    public static boolean isRegularPath(File file) {
        return !file.exists() || file.isFile();
    }

    public static File newTempFile(String prefix, String suffix, File[] tmpDirs, long minBytesFree) throws IOException {
        File f2 = null;
        for (int i2 = 0; i2 < tmpDirs.length; ++i2) {
            if (i2 != tmpDirs.length - 1 && tmpDirs[i2].getUsableSpace() <= minBytesFree) continue;
            f2 = File.createTempFile(prefix, suffix, tmpDirs[i2]);
            f2.deleteOnExit();
            break;
        }
        return f2;
    }

    public static File newTempFile(String prefix, String suffix, File[] tmpDirs) throws IOException {
        return IOUtil.newTempFile(prefix, suffix, tmpDirs, 0x140000000L);
    }

    public static File getDefaultTmpDir() {
        String user = System.getProperty("user.name");
        String tmp = System.getProperty("java.io.tmpdir");
        if (tmp.endsWith(File.separatorChar + user)) {
            return new File(tmp);
        }
        return new File(tmp, user);
    }

    public static String basename(File f2) {
        String full = f2.getName();
        int index = full.lastIndexOf(".");
        if (index > 0 && index > full.lastIndexOf(File.separator)) {
            return full.substring(0, index);
        }
        return full;
    }

    public static void assertFileIsReadable(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Cannot check readability of null file.");
        }
        if (!file.exists()) {
            throw new SAMException("Cannot read non-existent file: " + file.getAbsolutePath());
        }
        if (file.isDirectory()) {
            throw new SAMException("Cannot read file because it is a directory: " + file.getAbsolutePath());
        }
        if (!file.canRead()) {
            throw new SAMException("File exists but is not readable: " + file.getAbsolutePath());
        }
    }

    public static void assertFilesAreReadable(List<File> files) {
        for (File file : files) {
            IOUtil.assertFileIsReadable(file);
        }
    }

    public static void assertFileIsWritable(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Cannot check readability of null file.");
        }
        if (!file.exists()) {
            File parent = file.getAbsoluteFile().getParentFile();
            if (!parent.exists()) {
                throw new SAMException("Cannot write file: " + file.getAbsolutePath() + ". " + "Neither file nor parent directory exist.");
            }
            if (!parent.isDirectory()) {
                throw new SAMException("Cannot write file: " + file.getAbsolutePath() + ". " + "File does not exist and parent is not a directory.");
            }
            if (!parent.canWrite()) {
                throw new SAMException("Cannot write file: " + file.getAbsolutePath() + ". " + "File does not exist and parent directory is not writable..");
            }
        } else {
            if (file.isDirectory()) {
                throw new SAMException("Cannot write file because it is a directory: " + file.getAbsolutePath());
            }
            if (!file.canWrite()) {
                throw new SAMException("File exists but is not writable: " + file.getAbsolutePath());
            }
        }
    }

    public static void assertFilesAreWritable(List<File> files) {
        for (File file : files) {
            IOUtil.assertFileIsWritable(file);
        }
    }

    public static void assertDirectoryIsWritable(File dir) {
        if (dir == null) {
            throw new IllegalArgumentException("Cannot check readability of null file.");
        }
        if (!dir.exists()) {
            throw new SAMException("Directory does not exist: " + dir.getAbsolutePath());
        }
        if (!dir.isDirectory()) {
            throw new SAMException("Cannot write to directory because it is not a directory: " + dir.getAbsolutePath());
        }
        if (!dir.canWrite()) {
            throw new SAMException("Directory exists but is not writable: " + dir.getAbsolutePath());
        }
    }

    public static void assertDirectoryIsReadable(File dir) {
        if (dir == null) {
            throw new IllegalArgumentException("Cannot check readability of null file.");
        }
        if (!dir.exists()) {
            throw new SAMException("Directory does not exist: " + dir.getAbsolutePath());
        }
        if (!dir.isDirectory()) {
            throw new SAMException("Cannot read from directory because it is not a directory: " + dir.getAbsolutePath());
        }
        if (!dir.canRead()) {
            throw new SAMException("Directory exists but is not readable: " + dir.getAbsolutePath());
        }
    }

    public static void assertFilesEqual(File f1, File f2) {
        try {
            int len1;
            if (f1.length() != f2.length()) {
                throw new SAMException("Files " + f1 + " and " + f2 + " are different lengths.");
            }
            FileInputStream s1 = new FileInputStream(f1);
            FileInputStream s2 = new FileInputStream(f2);
            byte[] buf1 = new byte[0x100000];
            byte[] buf2 = new byte[0x100000];
            while ((len1 = s1.read(buf1)) != -1) {
                int len2 = s2.read(buf2);
                if (len1 != len2) {
                    throw new SAMException("Unexpected EOF comparing files that are supposed to be the same length.");
                }
                if (Arrays.equals(buf1, buf2)) continue;
                throw new SAMException("Files " + f1 + " and " + f2 + " differ.");
            }
            s1.close();
            s2.close();
        }
        catch (IOException e2) {
            throw new SAMException("Exception comparing files " + f1 + " and " + f2, e2);
        }
    }

    public static void assertFileSizeNonZero(File file) {
        if (file.length() == 0L) {
            throw new SAMException(file.getAbsolutePath() + " has length 0");
        }
    }

    public static InputStream openFileForReading(File file) {
        try {
            if (file.getName().endsWith(".gz") || file.getName().endsWith(".bfq")) {
                return IOUtil.openGzipFileForReading(file);
            }
            return new FileInputStream(file);
        }
        catch (IOException ioe) {
            throw new SAMException("Error opening file: " + file.getName(), ioe);
        }
    }

    public static InputStream openGzipFileForReading(File file) {
        try {
            return new GZIPInputStream(new FileInputStream(file));
        }
        catch (IOException ioe) {
            throw new SAMException("Error opening file: " + file.getName(), ioe);
        }
    }

    public static OutputStream openFileForWriting(File file) {
        return IOUtil.openFileForWriting(file, false);
    }

    public static OutputStream openFileForWriting(File file, boolean append) {
        try {
            if (file.getName().endsWith(".gz") || file.getName().endsWith(".bfq")) {
                return IOUtil.openGzipFileForWriting(file, append);
            }
            return new FileOutputStream(file, append);
        }
        catch (IOException ioe) {
            throw new SAMException("Error opening file for writing: " + file.getName(), ioe);
        }
    }

    public static BufferedWriter openFileForBufferedWriting(File file, boolean append) {
        return new BufferedWriter(new OutputStreamWriter(IOUtil.openFileForWriting(file, append)), Defaults.NON_ZERO_BUFFER_SIZE);
    }

    public static BufferedWriter openFileForBufferedWriting(File file) {
        return IOUtil.openFileForBufferedWriting(file, false);
    }

    public static BufferedWriter openFileForBufferedUtf8Writing(File file) {
        return new BufferedWriter(new OutputStreamWriter(IOUtil.openFileForWriting(file), Charset.forName("UTF-8")), Defaults.NON_ZERO_BUFFER_SIZE);
    }

    public static BufferedReader openFileForBufferedUtf8Reading(File file) {
        return new BufferedReader(new InputStreamReader(IOUtil.openFileForReading(file), Charset.forName("UTF-8")));
    }

    public static OutputStream openGzipFileForWriting(File file, boolean append) {
        try {
            if (Defaults.BUFFER_SIZE > 0) {
                return new CustomGzipOutputStream((OutputStream)new FileOutputStream(file, append), Defaults.BUFFER_SIZE, Defaults.COMPRESSION_LEVEL);
            }
            return new CustomGzipOutputStream((OutputStream)new FileOutputStream(file, append), Defaults.COMPRESSION_LEVEL);
        }
        catch (IOException ioe) {
            throw new SAMException("Error opening file for writing: " + file.getName(), ioe);
        }
    }

    public static OutputStream openFileForMd5CalculatingWriting(File file) {
        return new Md5CalculatingOutputStream(IOUtil.openFileForWriting(file), new File(file.getAbsolutePath() + ".md5"));
    }

    public static void copyStream(InputStream input, OutputStream output) {
        try {
            byte[] buffer = new byte[Defaults.NON_ZERO_BUFFER_SIZE];
            int bytesRead = 0;
            while ((bytesRead = input.read(buffer)) > 0) {
                output.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e2) {
            throw new SAMException("Exception copying stream", e2);
        }
    }

    public static void copyFile(File input, File output) {
        try {
            FileInputStream is = new FileInputStream(input);
            FileOutputStream os = new FileOutputStream(output);
            IOUtil.copyStream(is, os);
            ((OutputStream)os).close();
            ((InputStream)is).close();
        }
        catch (IOException e2) {
            throw new SAMException("Error copying " + input + " to " + output, e2);
        }
    }

    public static File[] getFilesMatchingRegexp(File directory, String regexp) {
        Pattern pattern = Pattern.compile(regexp);
        return IOUtil.getFilesMatchingRegexp(directory, pattern);
    }

    public static File[] getFilesMatchingRegexp(File directory, final Pattern regexp) {
        return directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return regexp.matcher(name).matches();
            }
        });
    }

    public static boolean deleteDirectoryTree(File fileOrDirectory) {
        boolean success = true;
        if (fileOrDirectory.isDirectory()) {
            for (File child : fileOrDirectory.listFiles()) {
                success = success && IOUtil.deleteDirectoryTree(child);
            }
        }
        success = success && fileOrDirectory.delete();
        return success;
    }

    public static long sizeOfTree(File fileOrDirectory) {
        long total = fileOrDirectory.length();
        if (fileOrDirectory.isDirectory()) {
            for (File f2 : fileOrDirectory.listFiles()) {
                total += IOUtil.sizeOfTree(f2);
            }
        }
        return total;
    }

    public static void copyDirectoryTree(File fileOrDirectory, File destination) {
        if (fileOrDirectory.isDirectory()) {
            destination.mkdir();
            for (File f2 : fileOrDirectory.listFiles()) {
                File destinationFileOrDirectory = new File(destination.getPath(), f2.getName());
                if (f2.isDirectory()) {
                    IOUtil.copyDirectoryTree(f2, destinationFileOrDirectory);
                    continue;
                }
                IOUtil.copyFile(f2, destinationFileOrDirectory);
            }
        }
    }

    public static File createTempDir(String prefix, String suffix) {
        try {
            File tmp = File.createTempFile(prefix, suffix);
            if (!tmp.delete()) {
                throw new SAMException("Could not delete temporary file " + tmp);
            }
            if (!tmp.mkdir()) {
                throw new SAMException("Could not create temporary directory " + tmp);
            }
            return tmp;
        }
        catch (IOException e2) {
            throw new SAMException("Exception creating temporary directory.", e2);
        }
    }

    public static BufferedReader openFileForBufferedReading(File file) {
        return new BufferedReader(new InputStreamReader(IOUtil.openFileForReading(file)), Defaults.NON_ZERO_BUFFER_SIZE);
    }

    public static String makeFileNameSafe(String str) {
        return str.trim().replaceAll("[\\s!\"#$%&'()*/:;<=>?@\\[\\]\\\\^`{|}~]", "_");
    }

    public static String fileSuffix(File f2) {
        String full = f2.getName();
        int index = full.lastIndexOf(".");
        if (index > 0 && index > full.lastIndexOf(File.separator)) {
            return full.substring(index);
        }
        return null;
    }

    public static String getFullCanonicalPath(File file) {
        try {
            File f2 = file.getCanonicalFile();
            String canonicalPath = "";
            while (f2 != null && !f2.getName().equals("")) {
                canonicalPath = "/" + f2.getName() + canonicalPath;
                if ((f2 = f2.getParentFile()) == null) continue;
                f2 = f2.getCanonicalFile();
            }
            return canonicalPath;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error getting full canonical path for " + file + ": " + ioe.getMessage(), ioe);
        }
    }

    public static String readFully(InputStream in) {
        try {
            BufferedReader r2 = new BufferedReader(new InputStreamReader(in), Defaults.NON_ZERO_BUFFER_SIZE);
            StringBuilder builder = new StringBuilder(512);
            String line = null;
            while ((line = r2.readLine()) != null) {
                if (builder.length() > 0) {
                    builder.append('\n');
                }
                builder.append(line);
            }
            return builder.toString();
        }
        catch (IOException ioe) {
            throw new RuntimeIOException("Error reading stream", ioe);
        }
    }

    public static IterableOnceIterator<String> readLines(File f2) {
        try {
            final BufferedReader in = IOUtil.openFileForBufferedReading(f2);
            return new IterableOnceIterator<String>(){
                private String next;
                {
                    this.next = in.readLine();
                }

                @Override
                public boolean hasNext() {
                    return this.next != null;
                }

                @Override
                public String next() {
                    try {
                        String tmp = this.next;
                        this.next = in.readLine();
                        if (this.next == null) {
                            in.close();
                        }
                        return tmp;
                    }
                    catch (IOException ioe) {
                        throw new RuntimeIOException(ioe);
                    }
                }

                @Override
                public void close() throws IOException {
                    CloserUtil.close(in);
                }
            };
        }
        catch (IOException e2) {
            throw new RuntimeIOException(e2);
        }
    }

    public static List<String> slurpLines(File file) throws FileNotFoundException {
        return IOUtil.slurpLines(new FileInputStream(file));
    }

    public static List<String> slurpLines(InputStream is) throws FileNotFoundException {
        return IOUtil.tokenSlurp(is, Charset.defaultCharset(), "\r\n|[\n\r\u2028\u2029\u0085]");
    }

    public static String slurp(File file) throws FileNotFoundException {
        return IOUtil.slurp(new FileInputStream(file));
    }

    public static String slurp(InputStream is) {
        return IOUtil.slurp(is, Charset.defaultCharset());
    }

    public static String slurp(InputStream is, Charset charSet) {
        List<String> tokenOrEmpty = IOUtil.tokenSlurp(is, charSet, "\\A");
        return tokenOrEmpty.isEmpty() ? "" : CollectionUtil.getSoleElement(tokenOrEmpty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> tokenSlurp(InputStream is, Charset charSet, String delimiterPattern) {
        try {
            Scanner s2 = new Scanner(is, charSet.toString()).useDelimiter(delimiterPattern);
            LinkedList<String> tokens = new LinkedList<String>();
            while (s2.hasNext()) {
                tokens.add(s2.next());
            }
            LinkedList<String> linkedList = tokens;
            return linkedList;
        }
        finally {
            CloserUtil.close(is);
        }
    }

    public static List<File> unrollFiles(Collection<File> inputs, String ... extensions) {
        if (extensions.length < 1) {
            throw new IllegalArgumentException("Must provide at least one extension.");
        }
        Stack<File> stack = new Stack<File>();
        ArrayList<File> output = new ArrayList<File>();
        stack.addAll(inputs);
        while (!stack.empty()) {
            File f2 = (File)stack.pop();
            String name = f2.getName();
            boolean matched = false;
            for (String ext : extensions) {
                if (matched || !name.endsWith(ext)) continue;
                output.add(f2);
                matched = true;
            }
            if (matched) continue;
            IOUtil.assertFileIsReadable(f2);
            for (String s2 : IOUtil.readLines(f2)) {
                if (s2.trim().isEmpty()) continue;
                stack.push(new File(s2.trim()));
            }
        }
        Collections.reverse(output);
        return output;
    }
}

