/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.util;

import com.google.java.contract.util.Predicate;

public final class Iterables {
    private Iterables() {
    }

    public static <T> boolean all(Iterable<T> iterable, Predicate<? super T> predicate) {
        if (iterable == null) {
            return false;
        }
        for (T t2 : iterable) {
            if (predicate.apply(t2)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean any(Iterable<T> iterable, Predicate<? super T> predicate) {
        if (iterable == null) {
            return false;
        }
        for (T t2 : iterable) {
            if (!predicate.apply(t2)) continue;
            return true;
        }
        return false;
    }
}

