/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.util;

import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import com.google.java.contract.core.util.Elements;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

@Invariant(value={"content != null", "lineNumberMap == null || Iterables.all(lineNumberMap.keySet(), Predicates.between(1L, null))"})
public class SyntheticJavaFile
extends SimpleJavaFileObject {
    protected byte[] content;
    protected Map<Long, ?> lineNumberMap;

    @Requires(value={"name != null", "content != null"})
    public SyntheticJavaFile(String string, byte[] byArray, Map<Long, ?> map) {
        super(Elements.getUriForClass(string, JavaFileObject.Kind.SOURCE), JavaFileObject.Kind.SOURCE);
        this.content = byArray;
        this.lineNumberMap = map;
    }

    @Override
    public InputStream openInputStream() {
        return new ByteArrayInputStream(this.content);
    }

    @Override
    public CharSequence getCharContent(boolean bl) {
        return new String(this.content);
    }

    @Override
    public boolean delete() {
        this.content = null;
        return true;
    }

    public Object getSourceInfo(long l2) {
        return this.lineNumberMap == null ? null : this.lineNumberMap.get(l2);
    }
}

