/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.util;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import com.google.java.contract.core.model.ClassName;
import java.util.TreeMap;

@Invariant(value={"root != null"})
public class PatternMap<R> {
    protected TernaryNode root = new TernaryNode(null, false);

    @Requires(value={"isValidPattern(pattern)"})
    public R get(String string) {
        TernaryNode ternaryNode;
        boolean bl;
        String string2 = string.replace('/', '.');
        boolean bl2 = bl = !string2.endsWith(".*");
        if (!bl) {
            string2 = string2.substring(0, string2.length() - 2);
        }
        String[] stringArray = string2.split("\\.");
        TernaryNode ternaryNode2 = this.root;
        R r2 = null;
        for (int i2 = 0; i2 < stringArray.length && (ternaryNode = ternaryNode2.children.get(stringArray[i2])) != null; ++i2) {
            if (ternaryNode.rule != null) {
                if (ternaryNode.exact) {
                    if (bl && i2 == stringArray.length - 1) {
                        r2 = ternaryNode.rule;
                    }
                } else {
                    r2 = ternaryNode.rule;
                }
            }
            ternaryNode2 = ternaryNode;
        }
        return r2;
    }

    @Requires(value={"isValidPattern(pattern)"})
    public boolean isOverriden(String string) {
        boolean bl;
        String string2 = string.replace('/', '.');
        boolean bl2 = bl = !string2.endsWith(".*");
        if (bl) {
            return false;
        }
        string2 = string2.substring(0, string2.length() - 2);
        String[] stringArray = string2.split("\\.");
        TernaryNode ternaryNode = this.root;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            TernaryNode ternaryNode2 = ternaryNode.children.get(stringArray[i2]);
            if (ternaryNode2 == null) {
                return false;
            }
            ternaryNode = ternaryNode2;
        }
        return !ternaryNode.children.isEmpty();
    }

    @Requires(value={"isValidPattern(pattern)", "rule != null"})
    @Ensures(value={"rule.equals(get(pattern))", "!isOverriden(pattern)"})
    public void put(String string, R r2) {
        TernaryNode ternaryNode;
        int n2;
        boolean bl;
        String string2 = string.replace('/', '.');
        boolean bl2 = bl = !string2.endsWith(".*");
        if (!bl) {
            string2 = string2.substring(0, string2.length() - 2);
        }
        String[] stringArray = string2.split("\\.");
        TernaryNode ternaryNode2 = this.root;
        TernaryNode ternaryNode3 = this.root;
        int n3 = -1;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            ternaryNode = ternaryNode2.children.get(stringArray[n2]);
            if (ternaryNode == null) {
                ternaryNode = new TernaryNode(null, false);
                ternaryNode2.children.put(stringArray[n2], ternaryNode);
            }
            if (ternaryNode.rule != null && !ternaryNode.exact) {
                ternaryNode3 = ternaryNode;
                n3 = n2;
            }
            ternaryNode2 = ternaryNode;
        }
        if (!bl) {
            ternaryNode2.children.clear();
        }
        if (!r2.equals(ternaryNode3.rule)) {
            ternaryNode2.rule = r2;
            ternaryNode2.exact = bl;
        } else {
            ternaryNode2 = ternaryNode3;
            for (n2 = n3 + 1; n2 < stringArray.length; ++n2) {
                ternaryNode = ternaryNode2.children.get(stringArray[n2]);
                if (ternaryNode.rule != null) continue;
                ternaryNode2.children.remove(stringArray[n2]);
                break;
            }
        }
    }

    public static boolean isValidPattern(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.replace('/', '.');
        return ClassName.isQualifiedName(string2) || ClassName.isStarQualifiedName(string2);
    }

    @Invariant(value={"children != null", "Iterables.all(children.keySet(), ClassName.isSimpleName())", "!children.values().contains(null)"})
    protected class TernaryNode {
        protected TreeMap<String, TernaryNode> children = new TreeMap();
        protected R rule;
        protected boolean exact;

        protected TernaryNode(R r2, boolean bl) {
            this.rule = r2;
            this.exact = bl;
        }
    }
}

