/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.model;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import com.google.java.contract.core.model.ClassName;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.model.ElementKind;
import com.google.java.contract.core.model.ElementModifier;
import com.google.java.contract.core.model.ElementVisitor;
import com.google.java.contract.core.model.MethodModel;
import com.google.java.contract.core.model.TypeName;
import com.google.java.contract.core.util.Elements;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;

@Invariant(value={"getContractKind() != null", "getId() >= -1", "getStatements() != null", "!getStatements().contains(null)", "!getContractKind().isClassContract() || getContractedMethod() == null", "!getContractKind().isMethodContract() || getContractedMethod() != null"})
public class ContractMethodModel
extends MethodModel {
    private static final ClassName CONTRACT_SIGNATURE_CLASS = new ClassName("com/google/java/contract/core/ContractMethodSignature");
    protected ContractKind contractKind;
    protected int id;
    protected List<String> statements;
    protected String prologue;
    protected String epilogue;
    protected MethodModel contractedMethod;
    protected List<Long> lineNumbers;

    @Requires(value={"kind != null", "name != null", "returnType != null", "!kind.isClassContract() || contracted == null"})
    public ContractMethodModel(ContractKind contractKind, String string, TypeName typeName, MethodModel methodModel) {
        super(ElementKind.CONTRACT_METHOD, string, typeName);
        if (methodModel != null) {
            this.typeParameters = new ArrayList<TypeName>(methodModel.getTypeParameters());
            Elements.copyParameters(this, methodModel.getParameters());
            this.modifiers = EnumSet.copyOf(methodModel.getModifiers());
        }
        this.fixCommonModifiers();
        this.contractKind = contractKind;
        this.id = -1;
        this.statements = new ArrayList<String>();
        this.prologue = null;
        this.epilogue = null;
        this.contractedMethod = methodModel;
        this.lineNumbers = null;
    }

    @Requires(value={"that != null"})
    @Ensures(value={"getEnclosingElement() == null"})
    public ContractMethodModel(ContractMethodModel contractMethodModel) {
        super(contractMethodModel);
        this.contractKind = contractMethodModel.contractKind;
        this.id = contractMethodModel.id;
        this.statements = new ArrayList<String>(contractMethodModel.statements);
        this.prologue = contractMethodModel.prologue;
        this.epilogue = contractMethodModel.epilogue;
        this.contractedMethod = contractMethodModel.contractedMethod;
        this.lineNumbers = contractMethodModel.lineNumbers;
    }

    @Override
    public ContractMethodModel clone() {
        return new ContractMethodModel(this);
    }

    private void fixCommonModifiers() {
        this.removeModifier(ElementModifier.ABSTRACT);
        this.removeModifier(ElementModifier.TRANSIENT);
    }

    public ContractKind getContractKind() {
        return this.contractKind;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n2) {
        this.id = n2;
    }

    public MethodModel getContractedMethod() {
        return this.contractedMethod;
    }

    public List<Long> getLineNumbers() {
        return this.lineNumbers;
    }

    @Ensures(value={"lineNumbers == getLineNumbers()"})
    public void setLineNumbers(List<Long> list) {
        this.lineNumbers = list;
    }

    @Ensures(value={"result != null"})
    public String getCode() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.prologue != null) {
            stringBuilder.append(this.prologue);
        }
        for (String string : this.statements) {
            stringBuilder.append(string);
        }
        if (this.epilogue != null) {
            stringBuilder.append(this.epilogue);
        }
        return stringBuilder.toString();
    }

    public List<String> getStatements() {
        return Collections.unmodifiableList(this.statements);
    }

    public String getPrologue() {
        return this.prologue;
    }

    @Ensures(value={"getPrologue().equals(prologue)"})
    public void setPrologue(String string) {
        this.prologue = string;
    }

    public String getEpilogue() {
        return this.epilogue;
    }

    @Ensures(value={"getEpilogue().equals(epilogue)"})
    public void setEpilogue(String string) {
        this.epilogue = string;
    }

    @Ensures(value={"getStatements().isEmpty()"})
    public void clearStatements() {
        this.statements.clear();
    }

    @Requires(value={"stmt != null"})
    @Ensures(value={"getStatements().size() == old(getStatements().size()) + 1", "getStatements().contains(stmt)"})
    public void addStatement(String string) {
        this.statements.add(string);
    }

    @Override
    public void accept(ElementVisitor elementVisitor) {
        elementVisitor.visitContractMethod(this);
    }

    @Override
    public EnumSet<ElementKind> getAllowedEnclosedKinds() {
        EnumSet<ElementKind> enumSet = EnumSet.of(ElementKind.CONTRACT_SIGNATURE);
        enumSet.addAll(super.getAllowedEnclosedKinds());
        return enumSet;
    }
}

