/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.apt;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import com.google.java.contract.core.model.ClassName;
import com.google.java.contract.core.util.BalancedTokenizer;
import com.google.java.contract.core.util.JavaTokenizer;
import com.google.java.contract.core.util.JavaUtils;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

@Invariant(value={"!canQueryResults() || getImportNames() != null", "!canQueryResults() || !getImportNames().contains(null)", "!canQueryResults() || getContractLineNumbers() != null", "!canQueryResults() || !getContractLineNumbers().entrySet().contains(null)", "!canQueryResults() || Iterables.all(getContractLineNumbers().values(),     Predicates.<Long>all(Predicates.between(1L, null)))", "source != null"})
public class SourceDependencyParser {
    protected Reader source;
    protected Set<String> importNames;
    protected Map<ClassName, List<Long>> contractLineNumbers;
    protected boolean parsed;
    private static final List<String> TYPE_KEYWORDS = Arrays.asList("class", "enum", "interface");
    private static final List<String> CONTRACT_TYPES = Arrays.asList("Requires", "Ensures", "ThrowEnsures", "Invariant");

    public SourceDependencyParser(Reader reader) {
        this.source = reader;
        this.importNames = new HashSet<String>();
        this.contractLineNumbers = new HashMap<ClassName, List<Long>>();
        this.parsed = false;
    }

    @Ensures(value={"canQueryResults()"})
    public void parse() throws JavaUtils.ParseException {
        if (this.parsed) {
            return;
        }
        try {
            BalancedTokenizer balancedTokenizer = new BalancedTokenizer(this.source);
            String string = null;
            ClassName className = null;
            ArrayList<Long> arrayList = new ArrayList<Long>();
            block6: while (balancedTokenizer.hasNext()) {
                JavaTokenizer.Token token = balancedTokenizer.next();
                switch (token.kind) {
                    case WORD: {
                        String string2;
                        if (balancedTokenizer.getCurrentLevel() != 0) break;
                        if (token.text.equals("package")) {
                            string = JavaUtils.parseQualifiedName(balancedTokenizer);
                            break;
                        }
                        if (token.text.equals("import")) {
                            string2 = JavaUtils.parseQualifiedName(balancedTokenizer, true);
                            if (string2.equals("static")) {
                                string2 = string2 + " " + JavaUtils.parseQualifiedName(balancedTokenizer, true);
                            }
                            this.importNames.add(string2);
                            break;
                        }
                        if (!TYPE_KEYWORDS.contains(token.text)) break;
                        string2 = JavaUtils.parseQualifiedName(balancedTokenizer);
                        if (string != null) {
                            string2 = string + "." + string2;
                        }
                        className = new ClassName(string2.replace('.', '/'));
                        this.contractLineNumbers.put(className, new ArrayList<Long>(arrayList));
                        arrayList.clear();
                        JavaUtils.skipPast(balancedTokenizer, "{");
                        break;
                    }
                    case SYMBOL: {
                        if (balancedTokenizer.getCurrentLevel() == 0 && token.text.equals("}")) {
                            className = null;
                            break;
                        }
                        if (!token.text.equals("@")) break;
                        String string2 = JavaUtils.parseQualifiedName(balancedTokenizer);
                        if (!string2.startsWith("com.google.java.contract.") && (!CONTRACT_TYPES.contains(string2) || (string == null || !string.equals("com.google.java.contract")) && !this.importNames.contains("com.google.java.contract." + string2) && !this.importNames.contains("com.google.java.contract.*"))) continue block6;
                        List<Long> list = className != null ? this.contractLineNumbers.get(className) : arrayList;
                        this.parseContractClauses(balancedTokenizer, list);
                        break;
                    }
                }
            }
            this.parsed = true;
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new JavaUtils.ParseException(noSuchElementException);
        }
    }

    @Requires(value={"tokenizer != null", "lineNumbers != null"})
    private void parseContractClauses(BalancedTokenizer balancedTokenizer, List<Long> list) {
        boolean bl = true;
        while (balancedTokenizer.hasNext()) {
            long l2 = balancedTokenizer.getCurrentLineNumber();
            JavaTokenizer.Token token = balancedTokenizer.next();
            if (token.text.equals(")")) {
                return;
            }
            if (bl && token.kind == JavaTokenizer.TokenKind.QUOTE) {
                list.add(l2);
                bl = false;
                continue;
            }
            if (!token.text.equals(",")) continue;
            bl = true;
        }
    }

    public boolean canQueryResults() {
        return this.parsed;
    }

    @Requires(value={"canQueryResults()"})
    public Set<String> getImportNames() {
        return Collections.unmodifiableSet(this.importNames);
    }

    @Requires(value={"canQueryResults()"})
    public Map<ClassName, List<Long>> getContractLineNumbers() {
        return Collections.unmodifiableMap(this.contractLineNumbers);
    }
}

