/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.apt;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import com.google.java.contract.core.apt.AnnotationSourceInfo;
import com.google.java.contract.core.apt.FactoryUtils;
import com.google.java.contract.core.model.ClassName;
import com.google.java.contract.core.model.ContractAnnotationModel;
import com.google.java.contract.core.model.ElementModel;
import com.google.java.contract.core.model.TypeName;
import com.google.java.contract.core.util.JavaUtils;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.util.ElementScanner6;

@Invariant(value={"utils != null"})
abstract class AbstractTypeBuilder
extends ElementScanner6<Void, ElementModel> {
    protected FactoryUtils utils;
    protected Iterator<Long> rootLineNumberIterator;

    @Requires(value={"utils != null"})
    protected AbstractTypeBuilder(FactoryUtils factoryUtils) {
        this.utils = factoryUtils;
    }

    @Requires(value={"parent != null", "annotation != null", "owner != null", "utils.isContractAnnotation(annotation)"})
    @Ensures(value={"result != null"})
    private ContractAnnotationModel createBlankContractModel(Element element, AnnotationMirror annotationMirror, boolean bl, ClassName className) {
        TypeName typeName;
        boolean bl2;
        com.google.java.contract.core.model.ElementKind elementKind = this.utils.getAnnotationKindForName(annotationMirror);
        block0 : switch (element.getKind()) {
            default: {
                bl2 = element.getKind() != ElementKind.INTERFACE;
                typeName = null;
                break;
            }
            case CONSTRUCTOR: 
            case METHOD: {
                bl2 = element.getEnclosingElement().getKind() != ElementKind.INTERFACE;
                ExecutableElement executableElement = (ExecutableElement)element;
                switch (executableElement.getReturnType().getKind()) {
                    case VOID: {
                        typeName = this.utils.getTypeNameForType(executableElement.getReturnType());
                        break block0;
                    }
                    case NONE: {
                        typeName = null;
                        break block0;
                    }
                    case PACKAGE: {
                        throw new RuntimeException("ExecutableElement has PACKAGE return type");
                    }
                }
                typeName = this.utils.getTypeNameForType(this.utils.typeUtils.erasure(executableElement.getReturnType()));
            }
        }
        return new ContractAnnotationModel(elementKind, bl, bl2, className, typeName);
    }

    @Requires(value={"parent != null", "annotation != null", "owner != null", "utils.isContractAnnotation(annotation)"})
    @Ensures(value={"result != null"})
    protected ContractAnnotationModel createContractModel(Element element, AnnotationMirror annotationMirror, boolean bl, ClassName className) {
        ContractAnnotationModel contractAnnotationModel = this.createBlankContractModel(element, annotationMirror, bl, className);
        List<Long> list = null;
        if (this.rootLineNumberIterator == null) {
            list = this.getLineNumbers(element, annotationMirror);
        }
        AnnotationValue annotationValue = null;
        for (AnnotationValue annotationValue2 : annotationMirror.getElementValues().values()) {
            List list2 = (List)annotationValue2.getValue();
            Iterator iterator = list2.iterator();
            Iterator<Long> iterator2 = this.rootLineNumberIterator != null ? this.rootLineNumberIterator : list.iterator();
            while (iterator.hasNext()) {
                String string = (String)((AnnotationValue)iterator.next()).getValue();
                Long l2 = iterator2.hasNext() ? iterator2.next() : null;
                contractAnnotationModel.addValue(string, l2);
            }
            annotationValue = annotationValue2;
        }
        AnnotationSourceInfo annotationSourceInfo = new AnnotationSourceInfo(element, annotationMirror, annotationValue, contractAnnotationModel.getValues());
        contractAnnotationModel.setSourceInfo(annotationSourceInfo);
        return contractAnnotationModel;
    }

    @Requires(value={"parent != null", "annotation != null", "owner != null", "p != null"})
    protected void visitAnnotation(Element element, AnnotationMirror annotationMirror, boolean bl, ClassName className, ElementModel elementModel) {
        if (this.utils.isContractAnnotation(annotationMirror)) {
            ContractAnnotationModel contractAnnotationModel = this.createContractModel(element, annotationMirror, bl, className);
            elementModel.addEnclosedElement(contractAnnotationModel);
        }
    }

    @Requires(value={"parent != null", "annotation != null"})
    @Ensures(value={"result != null"})
    protected List<Long> getLineNumbers(Element element, AnnotationMirror annotationMirror) {
        if (JavaUtils.classExists("com.sun.source.util.Trees")) {
            try {
                return (List)Class.forName("com.google.java.contract.core.apt.JavacUtils").getMethod("getLineNumbers", ProcessingEnvironment.class, Element.class, AnnotationMirror.class).invoke(null, this.utils.processingEnv, element, annotationMirror);
            }
            catch (Exception exception) {
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    @Requires(value={"element != null"})
    @Ensures(value={"result != null"})
    protected Set<String> getImportNames(Element element) {
        if (JavaUtils.classExists("com.sun.source.util.Trees")) {
            try {
                return (Set)Class.forName("com.google.java.contract.core.apt.JavacUtils").getMethod("getImportNames", ProcessingEnvironment.class, Element.class).invoke(null, this.utils.processingEnv, element);
            }
            catch (Exception exception) {
                return Collections.emptySet();
            }
        }
        return Collections.emptySet();
    }

    @Requires(value={"parent != null", "owner != null", "p != null"})
    protected void scanAnnotations(Element element, boolean bl, ClassName className, ElementModel elementModel) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            this.visitAnnotation(element, annotationMirror, bl, className, elementModel);
        }
    }
}

