/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.agent;

import com.google.java.contract.Invariant;
import com.google.java.contract.core.agent.ClassContractHandle;
import com.google.java.contract.core.agent.ContractAnalyzer;
import com.google.java.contract.core.agent.ContractFixingClassAdapter;
import com.google.java.contract.core.agent.LineNumberingClassAdapter;
import com.google.java.contract.core.agent.SpecificationMethodAdapter;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.util.DebugUtils;
import java.util.Iterator;
import java.util.List;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.MethodNode;

@Invariant(value={"getClassName() == null || ClassName.isBinaryName(getClassName())", "getContracts() != null", "getParent() != null"})
class SpecificationClassAdapter
extends ClassAdapter {
    protected String className;
    protected ContractAnalyzer contracts;

    public SpecificationClassAdapter(ClassVisitor classVisitor, ContractAnalyzer contractAnalyzer) {
        super(classVisitor);
        this.contracts = contractAnalyzer;
    }

    @Override
    public void visit(int n2, int n3, String string, String string2, String string3, String[] stringArray) {
        super.visit(n2, n3, string, string2, string3, stringArray);
        this.className = string;
    }

    @Override
    public MethodVisitor visitMethod(int n2, String string, String string2, String string3, String[] stringArray) {
        MethodVisitor methodVisitor = this.cv.visitMethod(n2, string, string2, string3, stringArray);
        if ((n2 & 0x500) != 0) {
            return methodVisitor;
        }
        return new SpecificationMethodAdapter(this, methodVisitor, n2, string, string2);
    }

    @Override
    public void visitEnd() {
        if (this.contracts != null) {
            List<ClassContractHandle> list = this.contracts.getClassHandles(ContractKind.ACCESS);
            for (ClassContractHandle object2 : list) {
                object2.getContractMethod().accept(this.cv);
            }
            List<ClassContractHandle> list2 = this.contracts.getClassHandles(ContractKind.HELPER);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                ClassContractHandle classContractHandle = (ClassContractHandle)iterator.next();
                MethodNode methodNode = classContractHandle.getContractMethod();
                DebugUtils.info("instrument", "helper method " + this.className + "." + methodNode.name + methodNode.desc);
                ClassVisitor classVisitor = this.cv;
                List<Long> list3 = classContractHandle.getLineNumbers();
                if (list3 != null) {
                    classVisitor = new LineNumberingClassAdapter(classVisitor, list3);
                }
                methodNode.accept(new ContractFixingClassAdapter(classVisitor));
                classContractHandle.setInjected(true);
            }
        }
        super.visitEnd();
    }

    String getClassName() {
        return this.className;
    }

    ClassVisitor getParent() {
        return this.cv;
    }

    ContractAnalyzer getContracts() {
        return this.contracts;
    }
}

