/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.agent;

import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.AdviceAdapter;

@Invariant(value={"lineNumbers == null || ContractMethodSignatures.isLineNumberList(lineNumbers)"})
abstract class LineNumberingMethodAdapter
extends AdviceAdapter {
    protected List<Long> lineNumbers = null;

    @Requires(value={"mv != null", "name != null", "desc != null"})
    public LineNumberingMethodAdapter(MethodVisitor methodVisitor, int n2, String string, String string2) {
        super(methodVisitor, n2, string, string2);
    }

    @Override
    protected void onMethodEnter() {
        Long l2;
        if (this.lineNumbers != null && !this.lineNumbers.isEmpty() && (l2 = this.lineNumbers.get(0)) != null) {
            Label label = new Label();
            this.mark(label);
            this.mv.visitLineNumber(l2.intValue(), label);
        }
    }

    @Override
    protected void onMethodExit(int n2) {
    }

    @Override
    public void visitLineNumber(int n2, Label label) {
    }

    @Override
    public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n2) {
        String string4;
        if (this.lineNumbers != null && string.startsWith(string4 = "com$google$java$contract$local$success$")) {
            try {
                Long l2;
                int n3 = Integer.parseInt(string.substring(string4.length()));
                if (n3 < this.lineNumbers.size() && (l2 = this.lineNumbers.get(n3)) != null) {
                    this.mv.visitLineNumber(l2.intValue(), label);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        super.visitLocalVariable(string, string2, string3, label, label2, n2);
    }
}

