/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.agent;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.ClassContractHandle;
import com.google.java.contract.core.agent.ContractMethodSignatures;
import com.google.java.contract.core.agent.MethodContractHandle;
import com.google.java.contract.core.model.ContractKind;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.EmptyVisitor;
import org.objectweb.asm.tree.MethodNode;

@Invariant(value={"className == null || ClassName.isBinaryName(className)", "classHandles != null", "!classHandles.contains(null)", "methodHandles != null", "!methodHandles.keySet().contains(null)", "Iterables.all(methodHandles.values(), Predicates.<MethodContractHandle>all(Predicates.nonNull()))"})
class ContractAnalyzer
extends EmptyVisitor {
    protected List<ClassContractHandle> classHandles = new ArrayList<ClassContractHandle>();
    protected Map<String, ArrayList<MethodContractHandle>> methodHandles = new HashMap<String, ArrayList<MethodContractHandle>>();
    protected String className;
    protected MethodNode lastMethodNode;

    ContractAnalyzer() {
    }

    @Requires(value={"kind != null"})
    @Ensures(value={"result != null", "!result.contains(null)"})
    List<ClassContractHandle> getClassHandles(ContractKind contractKind) {
        ArrayList<ClassContractHandle> arrayList = new ArrayList<ClassContractHandle>();
        for (ClassContractHandle classContractHandle : this.classHandles) {
            if (!contractKind.equals((Object)classContractHandle.getKind())) continue;
            arrayList.add(classContractHandle);
        }
        return arrayList;
    }

    @Requires(value={"kind != null", "name != null", "desc != null", "extraCount >= 0"})
    @Ensures(value={"result != null", "!result.contains(null)"})
    List<MethodContractHandle> getMethodHandles(ContractKind contractKind, String string, String string2, int n2) {
        ArrayList<MethodContractHandle> arrayList = this.methodHandles.get(string);
        if (arrayList == null) {
            return Collections.emptyList();
        }
        ArrayList<MethodContractHandle> arrayList2 = new ArrayList<MethodContractHandle>();
        for (MethodContractHandle methodContractHandle : arrayList) {
            if (!contractKind.equals((Object)methodContractHandle.getKind()) || !this.descArgumentsMatch(string2, methodContractHandle.getContractMethod().desc, n2)) continue;
            arrayList2.add(methodContractHandle);
        }
        return arrayList2;
    }

    @Requires(value={"kind != null"})
    ClassContractHandle getClassHandle(ContractKind contractKind) {
        ArrayList arrayList = new ArrayList();
        for (ClassContractHandle classContractHandle : this.classHandles) {
            if (!contractKind.equals((Object)classContractHandle.getKind())) continue;
            return classContractHandle;
        }
        return null;
    }

    @Requires(value={"kind != null", "name != null", "desc != null", "extraCount >= 0"})
    MethodContractHandle getMethodHandle(ContractKind contractKind, String string, String string2, int n2) {
        ArrayList<MethodContractHandle> arrayList = this.methodHandles.get(string);
        if (arrayList == null) {
            return null;
        }
        for (MethodContractHandle methodContractHandle : arrayList) {
            if (!contractKind.equals((Object)methodContractHandle.getKind()) || !this.descArgumentsMatch(string2, methodContractHandle.getContractMethod().desc, n2)) continue;
            return methodContractHandle;
        }
        return null;
    }

    @Requires(value={"desc1 != null", "desc2 != null", "offset >= 0"})
    private boolean descArgumentsMatch(String string, String string2, int n2) {
        Type[] typeArray = Type.getArgumentTypes(string);
        Type[] typeArray2 = Type.getArgumentTypes(string2);
        if (typeArray2.length - typeArray.length != n2) {
            return false;
        }
        for (int i2 = 0; i2 < typeArray.length; ++i2) {
            if (typeArray[i2].equals(typeArray2[i2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void visit(int n2, int n3, String string, String string2, String string3, String[] stringArray) {
        this.className = string;
    }

    @Override
    public MethodVisitor visitMethod(int n2, String string, String string2, String string3, String[] stringArray) {
        this.captureLastMethodNode();
        this.lastMethodNode = new MethodNode(n2, string, string2, string3, stringArray);
        return this.lastMethodNode;
    }

    @Override
    public void visitEnd() {
        this.captureLastMethodNode();
    }

    @Ensures(value={"lastMethodNode == null"})
    protected void captureLastMethodNode() {
        if (this.lastMethodNode == null) {
            return;
        }
        ContractKind contractKind = ContractMethodSignatures.getKind(this.lastMethodNode);
        if (contractKind != null) {
            List<Long> list = ContractMethodSignatures.getLineNumbers(this.lastMethodNode);
            if (contractKind.isClassContract() || contractKind.isHelperContract()) {
                ClassContractHandle classContractHandle = new ClassContractHandle(contractKind, this.className, this.lastMethodNode, list);
                this.classHandles.add(classContractHandle);
            } else {
                MethodContractHandle methodContractHandle = new MethodContractHandle(contractKind, this.className, this.lastMethodNode, list);
                this.internMethod(methodContractHandle.getMethodName()).add(methodContractHandle);
            }
        }
        this.lastMethodNode = null;
    }

    @Requires(value={"name != null"})
    @Ensures(value={"result != null", "result == methodHandles.get(name)"})
    protected List<MethodContractHandle> internMethod(String string) {
        ArrayList<MethodContractHandle> arrayList = this.methodHandles.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.methodHandles.put(string, arrayList);
        }
        return arrayList;
    }
}

