/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileReader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.ProgressLoggerInterface;
import java.io.File;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.Option;
import picard.cmdline.Usage;

public class SortSam
extends CommandLineProgram {
    @Usage
    public String USAGE = this.getStandardUsagePreamble() + "Sorts the input SAM or BAM.\n" + "" + "Input and output formats are determined by file extension.";
    @Option(doc="The BAM or SAM file to sort.", shortName="I")
    public File INPUT;
    @Option(doc="The sorted BAM or SAM output file. ", shortName="O")
    public File OUTPUT;
    @Option(shortName="SO", doc="Sort order of output file")
    public SAMFileHeader.SortOrder SORT_ORDER;
    private final Log log = Log.getInstance(SortSam.class);

    public static void main(String[] argv) {
        new SortSam().instanceMainWithExit(argv);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        SAMFileReader reader = new SAMFileReader(IOUtil.openFileForReading((File)this.INPUT));
        reader.getFileHeader().setSortOrder(this.SORT_ORDER);
        SAMFileWriter writer = new SAMFileWriterFactory().makeSAMOrBAMWriter(reader.getFileHeader(), false, this.OUTPUT);
        writer.setProgressLogger((ProgressLoggerInterface)new ProgressLogger(this.log, 10000000, "Wrote", "records from a sorting collection"));
        ProgressLogger progress = new ProgressLogger(this.log, 10000000, "Read");
        for (SAMRecord rec : reader) {
            writer.addAlignment(rec);
            progress.record(rec);
        }
        this.log.info(new Object[]{"Finished reading inputs, merging and writing to output now."});
        reader.close();
        writer.close();
        return 0;
    }
}

