/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.na12878kb.core;

import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.util.CloseableIterator;
import org.broadinstitute.sting.gatk.walkers.na12878kb.core.MongoVariantContext;
import org.broadinstitute.sting.gatk.walkers.na12878kb.core.OneChunkIterator;
import org.broadinstitute.sting.gatk.walkers.na12878kb.core.SiteIterator;
import org.broadinstitute.sting.gatk.walkers.na12878kb.core.SiteSelector;
import org.broadinstitute.sting.gatk.walkers.na12878kb.core.errors.InvalidRecordHandler;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.GenomeLocSortedSet;

public class SiteManager {
    private final List<SmartIteratorChunk> chunks = new ArrayList<SmartIteratorChunk>();
    private final GenomeLocParser parser;

    public SiteManager(GenomeLocParser parser) {
        this.parser = parser;
        SiteSelector selector = new SiteSelector(parser);
        this.chunks.add(new SmartIteratorChunk(selector, null));
    }

    protected SiteManager(GenomeLocParser parser, DBCursor cursor) {
        this.parser = parser;
        this.chunks.add(new SmartIteratorChunk(cursor));
    }

    protected SiteManager(GenomeLocParser parser, SiteSelector selector) {
        this.parser = parser;
        this.chunks.add(new SmartIteratorChunk(selector, null));
    }

    public SiteManager(GenomeLocParser parser, GenomeLocSortedSet allIntervals, SAMSequenceDictionary dictionary) {
        this.parser = parser;
        for (GenomeLoc contig : GenomeLocSortedSet.createSetFromSequenceDictionary((SAMSequenceDictionary)dictionary)) {
            SiteSelector selector = new SiteSelector(parser);
            if (allIntervals == null) {
                selector.addInterval(contig);
                this.chunks.add(new SmartIteratorChunk(selector, null));
                continue;
            }
            List contigIntervals = allIntervals.getOverlapping(contig);
            if (contigIntervals.isEmpty()) continue;
            if (!SiteSelector.hasTooManyIntervals(contigIntervals)) {
                selector.addIntervals(contigIntervals);
                this.chunks.add(new SmartIteratorChunk(selector, null));
                continue;
            }
            selector.addInterval(contig);
            this.chunks.add(new SmartIteratorChunk(selector, contigIntervals));
        }
        if (this.chunks.isEmpty()) {
            throw new IllegalArgumentException("No valid intervals were requested for the manager");
        }
    }

    public SiteIterator<MongoVariantContext> getIterator(DBCollection sites, DBObject sortOrder) {
        return new SmartSiteIterator<MongoVariantContext>(this.chunks, sites, sortOrder);
    }

    public SiteIterator<MongoVariantContext> getIterator() {
        for (SmartIteratorChunk chunk : this.chunks) {
            if (chunk.cursor != null) continue;
            throw new IllegalStateException("Trying to iterate over managed chunks that haven't been initialized with a cursor");
        }
        return new SmartSiteIterator<MongoVariantContext>(this.chunks);
    }

    public SiteManager onlyReviewed() {
        for (SmartIteratorChunk chunk : this.chunks) {
            chunk.selector.onlyReviewed();
        }
        return this;
    }

    private final class SmartSiteIterator<T extends MongoVariantContext>
    implements Iterable<T>,
    CloseableIterator<T>,
    SiteIterator<T> {
        final DBCollection sites;
        final DBObject sortOrder;
        InvalidRecordHandler<T> errorHandler = null;
        final LinkedList<SmartIteratorChunk> myChunks;
        OneChunkIterator<T> currentChunkIterator = null;

        public SmartSiteIterator(List<SmartIteratorChunk> chunks, DBCollection sites, DBObject sortOrder) {
            this.sites = sites;
            this.sortOrder = sortOrder;
            this.myChunks = new LinkedList<SmartIteratorChunk>(chunks);
            this.currentChunkIterator = this.makeIterator(sites, sortOrder, true);
        }

        public SmartSiteIterator(List<SmartIteratorChunk> chunks) {
            this.sites = null;
            this.sortOrder = null;
            this.myChunks = new LinkedList<SmartIteratorChunk>(chunks);
            this.currentChunkIterator = this.makeIterator(this.sites, this.sortOrder, true);
        }

        private OneChunkIterator<T> makeIterator(DBCollection sites, DBObject sortOrder, boolean errorIfDone) {
            if (this.myChunks.isEmpty()) {
                if (errorIfDone) {
                    throw new IllegalStateException("Trying to access data from a closed stream or one with no valid intervals");
                }
                return null;
            }
            SmartIteratorChunk chunk = this.myChunks.removeFirst();
            DBCursor cursor = chunk.cursor != null ? chunk.cursor : sites.find(chunk.selector.toQuery()).sort(sortOrder);
            return new OneChunkIterator<T>(SiteManager.this.parser, cursor, chunk.locs, this.errorHandler);
        }

        @Override
        public void setErrorHandler(InvalidRecordHandler<T> errorHandler) {
            this.errorHandler = errorHandler;
            if (this.currentChunkIterator != null) {
                this.currentChunkIterator.setErrorHandler(errorHandler);
            }
        }

        private void assureActiveStream() {
            if (this.currentChunkIterator == null) {
                throw new IllegalStateException("Trying to access data from a closed stream");
            }
            while (!this.currentChunkIterator.hasNext() && !this.myChunks.isEmpty()) {
                this.currentChunkIterator.close();
                this.currentChunkIterator = this.makeIterator(this.sites, this.sortOrder, false);
            }
        }

        @Override
        public List<T> getSitesBefore(GenomeLoc loc) {
            this.assureActiveStream();
            return this.currentChunkIterator.getSitesBefore(loc);
        }

        @Override
        public List<T> getSitesAtLocation(GenomeLoc loc) {
            this.assureActiveStream();
            return this.currentChunkIterator.getSitesAtLocation(loc);
        }

        @Override
        public List<T> getNextEquivalents() {
            this.assureActiveStream();
            return this.currentChunkIterator.getNextEquivalents();
        }

        @Override
        public List<T> toList() {
            LinkedList<T> l = new LinkedList<T>();
            while (this.hasNext()) {
                l.addAll(this.currentChunkIterator.toList());
            }
            return l;
        }

        public boolean hasNext() {
            if (this.currentChunkIterator == null) {
                return false;
            }
            if (!this.currentChunkIterator.hasNext()) {
                this.currentChunkIterator.close();
                this.currentChunkIterator = this.makeIterator(this.sites, this.sortOrder, false);
                return this.hasNext();
            }
            return true;
        }

        public T next() {
            if (this.currentChunkIterator == null) {
                throw new IllegalStateException("Trying to access data from a closed stream");
            }
            return (T)this.currentChunkIterator.next();
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }

        public void close() {
            if (this.currentChunkIterator != null) {
                this.currentChunkIterator.close();
            }
        }

        public void remove() {
            throw new UnsupportedOperationException("Not supported: remove");
        }
    }

    private final class SmartIteratorChunk {
        final SiteSelector selector;
        final List<GenomeLoc> locs;
        final DBCursor cursor;

        public SmartIteratorChunk(SiteSelector selector, List<GenomeLoc> locs) {
            this.selector = selector;
            this.locs = locs;
            this.cursor = null;
        }

        public SmartIteratorChunk(DBCursor cursor) {
            this.cursor = cursor;
            this.selector = null;
            this.locs = null;
        }
    }
}

