/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.sam;

import java.util.HashMap;
import java.util.Map;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMProgramRecord;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.datasources.reads.SAMReaderID;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.sam.NWaySAMFileWriter;

public class BySampleSAMFileWriter
extends NWaySAMFileWriter {
    private final Map<String, SAMReaderID> sampleToWriterMap;

    public BySampleSAMFileWriter(GenomeAnalysisEngine toolkit, String ext, SAMFileHeader.SortOrder order, boolean presorted, boolean indexOnTheFly, boolean generateMD5, SAMProgramRecord pRecord, boolean keep_records) {
        super(toolkit, ext, order, presorted, indexOnTheFly, generateMD5, pRecord, keep_records);
        this.sampleToWriterMap = new HashMap<String, SAMReaderID>(toolkit.getSAMFileHeader().getReadGroups().size() * 2);
        for (SAMReaderID readerID : toolkit.getReadsDataSource().getReaderIDs()) {
            for (SAMReadGroupRecord rg : toolkit.getReadsDataSource().getHeader(readerID).getReadGroups()) {
                String sample = rg.getSample();
                if (this.sampleToWriterMap.containsKey(sample) && this.sampleToWriterMap.get(sample) != readerID) {
                    throw new ReviewedStingException("The same sample appears in multiple files, this input cannot be multiplexed using the BySampleSAMFileWriter, try NWaySAMFileWriter instead.");
                }
                this.sampleToWriterMap.put(sample, readerID);
            }
        }
    }

    @Override
    public void addAlignment(SAMRecord samRecord) {
        super.addAlignment(samRecord, this.sampleToWriterMap.get(samRecord.getReadGroup().getSample()));
    }
}

