/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.pileup;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class PileupElement
implements Comparable<PileupElement> {
    private static final LinkedList<CigarElement> EMPTY_LINKED_LIST = new LinkedList();
    private static final EnumSet<CigarOperator> ON_GENOME_OPERATORS = EnumSet.of(CigarOperator.M, CigarOperator.EQ, CigarOperator.X, CigarOperator.D);
    public static final byte DELETION_BASE = BaseUtils.Base.D.base;
    public static final byte DELETION_QUAL = 16;
    public static final byte A_FOLLOWED_BY_INSERTION_BASE = 87;
    public static final byte C_FOLLOWED_BY_INSERTION_BASE = 88;
    public static final byte T_FOLLOWED_BY_INSERTION_BASE = 89;
    public static final byte G_FOLLOWED_BY_INSERTION_BASE = 90;
    protected final GATKSAMRecord read;
    protected final int offset;
    private final CigarElement currentCigarElement;
    private final int currentCigarOffset;
    private final int offsetInCurrentCigar;

    public PileupElement(GATKSAMRecord read, int baseOffset, CigarElement currentElement, int currentCigarOffset, int offsetInCurrentCigar) {
        assert (currentElement != null);
        this.read = read;
        this.offset = baseOffset;
        this.currentCigarElement = currentElement;
        this.currentCigarOffset = currentCigarOffset;
        this.offsetInCurrentCigar = offsetInCurrentCigar;
        assert (this.read != null);
        assert (this.offset >= 0 && this.offset < this.read.getReadLength());
        assert (this.currentCigarOffset >= 0);
        assert (this.currentCigarOffset < read.getCigarLength());
        assert (this.offsetInCurrentCigar >= 0);
        assert (this.offsetInCurrentCigar < currentElement.getLength());
    }

    public PileupElement(PileupElement toCopy) {
        this(toCopy.read, toCopy.offset, toCopy.currentCigarElement, toCopy.currentCigarOffset, toCopy.offsetInCurrentCigar);
    }

    public boolean isDeletion() {
        return this.currentCigarElement.getOperator() == CigarOperator.D;
    }

    public boolean isBeforeDeletionStart() {
        return !this.isDeletion() && this.atEndOfCurrentCigar() && this.hasOperator(this.getNextOnGenomeCigarElement(), CigarOperator.D);
    }

    public boolean isAfterDeletionEnd() {
        return !this.isDeletion() && this.atStartOfCurrentCigar() && this.hasOperator(this.getPreviousOnGenomeCigarElement(), CigarOperator.D);
    }

    @Ensures(value={"result != null"})
    public GATKSAMRecord getRead() {
        return this.read;
    }

    @Ensures(value={"result >= 0", "result <= read.getReadLength()"})
    public int getOffset() {
        return this.offset;
    }

    @Ensures(value={"result != DELETION_BASE || (isDeletion() && result == DELETION_BASE)"})
    public byte getBase() {
        return this.isDeletion() ? DELETION_BASE : this.read.getReadBases()[this.offset];
    }

    @Deprecated
    public int getBaseIndex() {
        return BaseUtils.simpleBaseToBaseIndex(this.getBase());
    }

    public byte getQual() {
        return this.isDeletion() ? (byte)16 : this.read.getBaseQualities()[this.offset];
    }

    public byte getBaseInsertionQual() {
        return this.isDeletion() ? (byte)16 : this.read.getBaseInsertionQualities()[this.offset];
    }

    public byte getBaseDeletionQual() {
        return this.isDeletion() ? (byte)16 : this.read.getBaseDeletionQualities()[this.offset];
    }

    @Ensures(value={"result >= 0"})
    public int getLengthOfImmediatelyFollowingIndel() {
        CigarElement element = this.getNextIndelCigarElement();
        return element == null ? 0 : element.getLength();
    }

    private CigarElement getNextIndelCigarElement() {
        if (this.isBeforeDeletionStart()) {
            CigarElement element = this.getNextOnGenomeCigarElement();
            if (element == null || element.getOperator() != CigarOperator.D) {
                throw new IllegalStateException("Immediately before deletion but the next cigar element isn't a deletion " + element);
            }
            return element;
        }
        if (this.isBeforeInsertion()) {
            CigarElement element = this.getBetweenNextPosition().get(0);
            if (element.getOperator() != CigarOperator.I) {
                throw new IllegalStateException("Immediately before insertion but the next cigar element isn't an insertion " + element);
            }
            return element;
        }
        return null;
    }

    @Ensures(value={"result == null || result.length() == getLengthOfImmediatelyFollowingIndel()"})
    public String getBasesOfImmediatelyFollowingInsertion() {
        CigarElement element = this.getNextIndelCigarElement();
        if (element != null && element.getOperator() == CigarOperator.I) {
            int getFrom = this.offset + 1;
            byte[] bases = Arrays.copyOfRange(this.read.getReadBases(), getFrom, getFrom + element.getLength());
            return new String(bases);
        }
        return null;
    }

    public int getMappingQual() {
        return this.read.getMappingQuality();
    }

    @Ensures(value={"result != null"})
    public String toString() {
        return String.format("%s @ %d = %c Q%d", this.getRead().getReadName(), this.getOffset(), Character.valueOf((char)this.getBase()), this.getQual());
    }

    @Override
    public int compareTo(PileupElement pileupElement) {
        if (this.offset < pileupElement.offset) {
            return -1;
        }
        if (this.offset > pileupElement.offset) {
            return 1;
        }
        if (this.read.getAlignmentStart() < pileupElement.read.getAlignmentStart()) {
            return -1;
        }
        if (this.read.getAlignmentStart() > pileupElement.read.getAlignmentStart()) {
            return 1;
        }
        return 0;
    }

    public int getRepresentativeCount() {
        if (this.read.isReducedRead()) {
            if (this.isDeletion() && this.offset + 1 >= this.read.getReadLength()) {
                throw new UserException.MalformedBAM((SAMRecord)this.read, String.format("Adjacent I/D events in read %s -- cigar: %s", this.read.getReadName(), this.read.getCigarString()));
            }
            return this.isDeletion() ? MathUtils.fastRound((double)(this.read.getReducedCount(this.offset) + this.read.getReducedCount(this.offset + 1)) / 2.0) : this.read.getReducedCount(this.offset);
        }
        return 1;
    }

    public void adjustRepresentativeCount(int adjustmentFactor) {
        if (!this.read.isReducedRead()) {
            throw new IllegalArgumentException("Trying to adjust the representative count of a read that is not reduced");
        }
        this.read.adjustReducedCount(this.offset, adjustmentFactor);
    }

    @Ensures(value={"result != null"})
    public CigarElement getCurrentCigarElement() {
        return this.currentCigarElement;
    }

    public int getCurrentCigarOffset() {
        return this.currentCigarOffset;
    }

    @Ensures(value={"result >= 0", "result < getCurrentCigarElement().getLength()"})
    public int getOffsetInCurrentCigar() {
        return this.offsetInCurrentCigar;
    }

    @Ensures(value={"result != null"})
    public LinkedList<CigarElement> getBetweenPrevPosition() {
        return this.atStartOfCurrentCigar() ? this.getBetween(Direction.PREV) : EMPTY_LINKED_LIST;
    }

    @Ensures(value={"result != null"})
    public LinkedList<CigarElement> getBetweenNextPosition() {
        return this.atEndOfCurrentCigar() ? this.getBetween(Direction.NEXT) : EMPTY_LINKED_LIST;
    }

    @Ensures(value={"result != null"})
    private LinkedList<CigarElement> getBetween(Direction direction) {
        CigarElement elt;
        int increment = direction == Direction.NEXT ? 1 : -1;
        LinkedList<CigarElement> elements = null;
        int nCigarElements = this.read.getCigarLength();
        for (int i = this.currentCigarOffset + increment; i >= 0 && i < nCigarElements && !ON_GENOME_OPERATORS.contains((elt = this.read.getCigar().getCigarElement(i)).getOperator()); i += increment) {
            if (elements == null) {
                elements = new LinkedList<CigarElement>();
            }
            if (increment > 0) {
                elements.add(elt);
                continue;
            }
            elements.addFirst(elt);
        }
        return elements == null ? EMPTY_LINKED_LIST : elements;
    }

    @Ensures(value={"result == null || ON_GENOME_OPERATORS.contains(result.getOperator())"})
    public CigarElement getPreviousOnGenomeCigarElement() {
        return this.getNeighboringOnGenomeCigarElement(Direction.PREV);
    }

    @Ensures(value={"result == null || ON_GENOME_OPERATORS.contains(result.getOperator())"})
    public CigarElement getNextOnGenomeCigarElement() {
        return this.getNeighboringOnGenomeCigarElement(Direction.NEXT);
    }

    @Ensures(value={"result == null || ON_GENOME_OPERATORS.contains(result.getOperator())"})
    private CigarElement getNeighboringOnGenomeCigarElement(Direction direction) {
        int increment = direction == Direction.NEXT ? 1 : -1;
        int nCigarElements = this.read.getCigarLength();
        for (int i = this.currentCigarOffset + increment; i >= 0 && i < nCigarElements; i += increment) {
            CigarElement elt = this.read.getCigar().getCigarElement(i);
            if (!ON_GENOME_OPERATORS.contains(elt.getOperator())) continue;
            return elt;
        }
        return null;
    }

    @Requires(value={"toMatch != null"})
    private boolean hasOperator(CigarElement maybeCigarElement, CigarOperator toMatch) {
        return maybeCigarElement != null && maybeCigarElement.getOperator() == toMatch;
    }

    public boolean isAfterInsertion() {
        return this.isAfter(this.getBetweenPrevPosition(), CigarOperator.I);
    }

    public boolean isBeforeInsertion() {
        return this.isBefore(this.getBetweenNextPosition(), CigarOperator.I);
    }

    public boolean isAfterSoftClip() {
        return this.isAfter(this.getBetweenPrevPosition(), CigarOperator.S);
    }

    public boolean isBeforeSoftClip() {
        return this.isBefore(this.getBetweenNextPosition(), CigarOperator.S);
    }

    public boolean isNextToSoftClip() {
        return this.isAfterSoftClip() || this.isBeforeSoftClip();
    }

    public boolean atEndOfCurrentCigar() {
        return this.offsetInCurrentCigar == this.currentCigarElement.getLength() - 1;
    }

    public boolean atStartOfCurrentCigar() {
        return this.offsetInCurrentCigar == 0;
    }

    @Requires(value={"elements != null", "op != null"})
    private boolean isAfter(LinkedList<CigarElement> elements, CigarOperator op) {
        return !elements.isEmpty() && elements.peekLast().getOperator() == op;
    }

    @Requires(value={"elements != null", "op != null"})
    private boolean isBefore(List<CigarElement> elements, CigarOperator op) {
        return !elements.isEmpty() && elements.get(0).getOperator() == op;
    }

    private static enum Direction {
        PREV,
        NEXT;

    }
}

