/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.pairhmm;

import com.google.java.contract.Requires;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.utils.MathUtils;

public abstract class PairHMM {
    protected static final Logger logger = Logger.getLogger(PairHMM.class);
    protected boolean constantsAreInitialized = false;
    protected byte[] previousHaplotypeBases;
    protected int maxHaplotypeLength;
    protected int maxReadLength;
    protected int paddedMaxReadLength;
    protected int paddedMaxHaplotypeLength;
    protected int paddedReadLength;
    protected int paddedHaplotypeLength;
    private boolean initialized = false;

    public void initialize(int readMaxLength, int haplotypeMaxLength) {
        if (readMaxLength <= 0) {
            throw new IllegalArgumentException("READ_MAX_LENGTH must be > 0 but got " + readMaxLength);
        }
        if (haplotypeMaxLength <= 0) {
            throw new IllegalArgumentException("HAPLOTYPE_MAX_LENGTH must be > 0 but got " + haplotypeMaxLength);
        }
        this.maxHaplotypeLength = haplotypeMaxLength;
        this.maxReadLength = readMaxLength;
        this.paddedMaxReadLength = readMaxLength + 1;
        this.paddedMaxHaplotypeLength = haplotypeMaxLength + 1;
        this.previousHaplotypeBases = null;
        this.constantsAreInitialized = false;
        this.initialized = true;
    }

    public final double computeReadLikelihoodGivenHaplotypeLog10(byte[] haplotypeBases, byte[] readBases, byte[] readQuals, byte[] insertionGOP, byte[] deletionGOP, byte[] overallGCP, boolean recacheReadValues) {
        if (!this.initialized) {
            throw new IllegalStateException("Must call initialize before calling computeReadLikelihoodGivenHaplotypeLog10");
        }
        if (haplotypeBases == null) {
            throw new IllegalArgumentException("haplotypeBases cannot be null");
        }
        if (haplotypeBases.length > this.maxHaplotypeLength) {
            throw new IllegalArgumentException("Haplotype bases is too long, got " + haplotypeBases.length + " but max is " + this.maxHaplotypeLength);
        }
        if (readBases == null) {
            throw new IllegalArgumentException("readBases cannot be null");
        }
        if (readBases.length > this.maxReadLength) {
            throw new IllegalArgumentException("readBases is too long, got " + readBases.length + " but max is " + this.maxReadLength);
        }
        if (readQuals.length != readBases.length) {
            throw new IllegalArgumentException("Read bases and read quals aren't the same size: " + readBases.length + " vs " + readQuals.length);
        }
        if (insertionGOP.length != readBases.length) {
            throw new IllegalArgumentException("Read bases and read insertion quals aren't the same size: " + readBases.length + " vs " + insertionGOP.length);
        }
        if (deletionGOP.length != readBases.length) {
            throw new IllegalArgumentException("Read bases and read deletion quals aren't the same size: " + readBases.length + " vs " + deletionGOP.length);
        }
        if (overallGCP.length != readBases.length) {
            throw new IllegalArgumentException("Read bases and overall GCP aren't the same size: " + readBases.length + " vs " + overallGCP.length);
        }
        this.paddedReadLength = readBases.length + 1;
        this.paddedHaplotypeLength = haplotypeBases.length + 1;
        int hapStartIndex = this.previousHaplotypeBases == null || haplotypeBases.length != this.previousHaplotypeBases.length || recacheReadValues ? 0 : PairHMM.findFirstPositionWhereHaplotypesDiffer(haplotypeBases, this.previousHaplotypeBases);
        double result = this.subComputeReadLikelihoodGivenHaplotypeLog10(haplotypeBases, readBases, readQuals, insertionGOP, deletionGOP, overallGCP, hapStartIndex, recacheReadValues);
        if (!MathUtils.goodLog10Probability(result)) {
            throw new IllegalStateException("PairHMM Log Probability cannot be greater than 0: " + String.format("haplotype: %s, read: %s, result: %f", Arrays.toString(haplotypeBases), Arrays.toString(readBases), result));
        }
        this.previousHaplotypeBases = haplotypeBases;
        return result;
    }

    @Requires(value={"readBases.length == readQuals.length", "readBases.length == insertionGOP.length", "readBases.length == deletionGOP.length", "readBases.length == overallGCP.length", "matchMatrix!=null", "insertionMatrix!=null", "deletionMatrix!=null"})
    protected abstract double subComputeReadLikelihoodGivenHaplotypeLog10(byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5, byte[] var6, int var7, boolean var8);

    public static int findFirstPositionWhereHaplotypesDiffer(byte[] haplotype1, byte[] haplotype2) {
        if (haplotype1 == null || haplotype1.length == 0) {
            throw new IllegalArgumentException("Haplotype1 is bad " + Arrays.toString(haplotype1));
        }
        if (haplotype2 == null || haplotype2.length == 0) {
            throw new IllegalArgumentException("Haplotype2 is bad " + Arrays.toString(haplotype2));
        }
        for (int iii = 0; iii < haplotype1.length && iii < haplotype2.length; ++iii) {
            if (haplotype1[iii] == haplotype2[iii]) continue;
            return iii;
        }
        return Math.min(haplotype1.length, haplotype2.length);
    }

    public static enum HMM_IMPLEMENTATION {
        EXACT,
        ORIGINAL,
        LOGLESS_CACHING;

    }
}

