/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.recalibration;

import org.apache.log4j.Logger;
import org.broadinstitute.sting.utils.LRUCache;
import org.broadinstitute.sting.utils.recalibration.EventType;

public class ReadCovariates {
    private static final Logger logger = Logger.getLogger(ReadCovariates.class);
    private static final int LRU_CACHE_SIZE = 500;
    private static final ThreadLocal<LRUCache<Integer, int[][][]>> keysCache = new ThreadLocal<LRUCache<Integer, int[][][]>>(){

        @Override
        protected LRUCache<Integer, int[][][]> initialValue() {
            return new LRUCache<Integer, int[][][]>(500);
        }
    };
    private final int[][][] keys;
    private int currentCovariateIndex = 0;

    public ReadCovariates(int readLength, int numberOfCovariates) {
        LRUCache<Integer, int[][][]> cache = keysCache.get();
        int[][][] cachedKeys = (int[][][])cache.get(readLength);
        if (cachedKeys == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Keys cache miss for length " + readLength + " cache size " + cache.size()));
            }
            this.keys = new int[EventType.values().length][readLength][numberOfCovariates];
            cache.put(readLength, this.keys);
        } else {
            this.keys = cachedKeys;
        }
    }

    public void setCovariateIndex(int index) {
        this.currentCovariateIndex = index;
    }

    public void addCovariate(int mismatch, int insertion, int deletion, int readOffset) {
        this.keys[EventType.BASE_SUBSTITUTION.ordinal()][readOffset][this.currentCovariateIndex] = mismatch;
        this.keys[EventType.BASE_INSERTION.ordinal()][readOffset][this.currentCovariateIndex] = insertion;
        this.keys[EventType.BASE_DELETION.ordinal()][readOffset][this.currentCovariateIndex] = deletion;
    }

    public int[] getKeySet(int readPosition, EventType errorModel) {
        return this.keys[errorModel.ordinal()][readPosition];
    }

    public int[][] getKeySet(EventType errorModel) {
        return this.keys[errorModel.ordinal()];
    }

    protected int[][] getMismatchesKeySet() {
        return this.getKeySet(EventType.BASE_SUBSTITUTION);
    }

    protected int[][] getInsertionsKeySet() {
        return this.getKeySet(EventType.BASE_INSERTION);
    }

    protected int[][] getDeletionsKeySet() {
        return this.getKeySet(EventType.BASE_DELETION);
    }

    protected int[] getMismatchesKeySet(int readPosition) {
        return this.getKeySet(readPosition, EventType.BASE_SUBSTITUTION);
    }

    protected int[] getInsertionsKeySet(int readPosition) {
        return this.getKeySet(readPosition, EventType.BASE_INSERTION);
    }

    protected int[] getDeletionsKeySet(int readPosition) {
        return this.getKeySet(readPosition, EventType.BASE_DELETION);
    }
}

