/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.locusiterator;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.picard.util.PeekableIterator;
import org.broadinstitute.sting.utils.locusiterator.AlignmentStateMachine;
import org.broadinstitute.sting.utils.locusiterator.LIBSDownsamplingInfo;
import org.broadinstitute.sting.utils.locusiterator.PerSampleReadStateManager;
import org.broadinstitute.sting.utils.locusiterator.SamplePartitioner;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

final class ReadStateManager
implements Iterable<Map.Entry<String, PerSampleReadStateManager>> {
    private final List<String> samples;
    private final PeekableIterator<GATKSAMRecord> iterator;
    private final SamplePartitioner<GATKSAMRecord> samplePartitioner;
    private final Map<String, PerSampleReadStateManager> readStatesBySample = new LinkedHashMap<String, PerSampleReadStateManager>();
    private LinkedList<GATKSAMRecord> submittedReads;
    private final boolean keepSubmittedReads;
    private int totalReadStates = 0;

    public ReadStateManager(Iterator<GATKSAMRecord> source, List<String> samples, LIBSDownsamplingInfo LIBSDownsamplingInfo2, boolean keepSubmittedReads) {
        this.samples = samples;
        this.iterator = new PeekableIterator(source);
        this.keepSubmittedReads = keepSubmittedReads;
        this.submittedReads = new LinkedList();
        for (String sample : samples) {
            this.readStatesBySample.put(sample, new PerSampleReadStateManager(LIBSDownsamplingInfo2));
        }
        this.samplePartitioner = new SamplePartitioner(LIBSDownsamplingInfo2, samples);
    }

    @Override
    public Iterator<Map.Entry<String, PerSampleReadStateManager>> iterator() {
        return this.readStatesBySample.entrySet().iterator();
    }

    public boolean isEmpty() {
        return this.totalReadStates == 0;
    }

    public int size() {
        return this.totalReadStates;
    }

    public int size(String sample) {
        return this.readStatesBySample.get(sample).size();
    }

    public AlignmentStateMachine getFirst() {
        for (PerSampleReadStateManager manager : this.readStatesBySample.values()) {
            if (manager.isEmpty()) continue;
            return manager.getFirst();
        }
        return null;
    }

    public boolean hasNext() {
        return this.totalReadStates > 0 || this.iterator.hasNext();
    }

    public void updateReadStates() {
        for (PerSampleReadStateManager perSampleReadStateManager : this.readStatesBySample.values()) {
            this.totalReadStates -= perSampleReadStateManager.updateReadStates();
        }
    }

    private boolean readStartsAtCurrentPosition(GATKSAMRecord read, int currentContigIndex, int currentAlignmentStart) {
        return read.getAlignmentStart() == currentAlignmentStart && read.getReferenceIndex() == currentContigIndex;
    }

    public void collectPendingReads() {
        int firstAlignmentStart;
        int firstContigIndex;
        if (!this.iterator.hasNext()) {
            return;
        }
        if (this.isEmpty()) {
            firstContigIndex = ((GATKSAMRecord)((Object)this.iterator.peek())).getReferenceIndex();
            firstAlignmentStart = ((GATKSAMRecord)((Object)this.iterator.peek())).getAlignmentStart();
        } else {
            AlignmentStateMachine firstState = this.getFirst();
            firstContigIndex = firstState.getReferenceIndex();
            firstAlignmentStart = firstState.getGenomePosition();
        }
        while (this.iterator.hasNext() && this.readStartsAtCurrentPosition((GATKSAMRecord)((Object)this.iterator.peek()), firstContigIndex, firstAlignmentStart)) {
            this.submitRead((GATKSAMRecord)((Object)this.iterator.next()));
        }
        this.samplePartitioner.doneSubmittingReads();
        for (String sample : this.samples) {
            Collection<GATKSAMRecord> newReads = this.samplePartitioner.getReadsForSample(sample);
            if (this.keepSubmittedReads) {
                this.submittedReads.addAll(newReads);
            }
            PerSampleReadStateManager statesBySample = this.readStatesBySample.get(sample);
            this.addReadsToSample(statesBySample, newReads);
        }
        this.samplePartitioner.reset();
    }

    @Requires(value={"read != null"})
    protected void submitRead(GATKSAMRecord read) {
        this.samplePartitioner.submitRead(read);
    }

    @Ensures(value={"result != null", "result != submittedReads"})
    public List<GATKSAMRecord> transferSubmittedReads() {
        if (!this.keepSubmittedReads) {
            throw new UnsupportedOperationException("cannot transferSubmittedReads if you aren't keeping them");
        }
        LinkedList<GATKSAMRecord> prevSubmittedReads = this.submittedReads;
        this.submittedReads = new LinkedList();
        return prevSubmittedReads;
    }

    public boolean isKeepingSubmittedReads() {
        return this.keepSubmittedReads;
    }

    @Ensures(value={"result != null", "keepSubmittedReads || result.isEmpty()"})
    protected List<GATKSAMRecord> getSubmittedReads() {
        return this.submittedReads;
    }

    private void addReadsToSample(PerSampleReadStateManager readStates, Collection<GATKSAMRecord> reads) {
        if (reads.isEmpty()) {
            return;
        }
        LinkedList<AlignmentStateMachine> newReadStates = new LinkedList<AlignmentStateMachine>();
        for (GATKSAMRecord read : reads) {
            AlignmentStateMachine state = new AlignmentStateMachine(read);
            if (state.stepForwardOnGenome() == null) continue;
            newReadStates.add(state);
        }
        this.totalReadStates += readStates.addStatesAtNextAlignmentStart(newReadStates);
    }
}

