/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.tools;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMRecord;

public class SplitReads
extends CommandLineProgram {
    @Usage(programVersion="1.0")
    public String USAGE = "Splits reads: extracts sub-sequences of the specified length(s) from left and/or right ends of all the reads into the specified output bam file(s). For the reads in the input that are mapped, the subsequences in the output bam(s) will have appropriately adjusted alignment positions and chopped cigars.";
    @Option(shortName="I", doc="Input file (bam or sam) with read sequences to split.", optional=false)
    public File IN = null;
    @Option(shortName="E", doc="Read end to select, 1=left, 2=right; default: select both ends.", optional=true)
    public List<Integer> READ_ENDS = new ArrayList<Integer>();
    @Option(shortName="N", doc="Number of bases to keep in the corresponding segment of the read. Synchronized with READ_ENDS argument; if single number is given, all selected segments (ends) will have specified length.", optional=false)
    public List<Integer> LENGTH = new ArrayList<Integer>();
    @Option(shortName="S", doc="Read name for each segment (read end) will be set as original read name followed by the corresponding suffix.Synchronized with READ_ENDS argument and must have the same number of entries if specified (note that default READ_ENDS is a list of (1,2). By default, suffixes are empty strings, i.e. all segments have the same name(s) as the original read.", optional=true)
    public List<String> SUFFIXES = new ArrayList<String>();
    @Option(shortName="O", optional=false, doc="Each read end will be sent into the corresponding file (synchronized with READ_ENDS). If only one file name is specified, all read segments will be printed into that file.")
    public List<File> OUTPUT_BAMS = new ArrayList<File>();
    @Option(shortName="U", doc="Split and output only unmapped reads; mapped reads will be ignored.", optional=true)
    public boolean UNMAPPED = false;

    public static void main(String[] argv) {
        System.exit(new SplitReads().instanceMain(argv));
    }

    protected int doWork() {
        if (this.READ_ENDS.size() == 0) {
            this.READ_ENDS.add(1);
            this.READ_ENDS.add(2);
        }
        for (Integer i : this.READ_ENDS) {
            if (i.equals(1) || i.equals(2)) continue;
            throw new RuntimeException("Unknown value specified for READ_ENDS: " + i);
        }
        if (this.SUFFIXES.size() == 0) {
            for (Integer i : this.READ_ENDS) {
                this.SUFFIXES.add("");
            }
        } else if (this.SUFFIXES.size() != this.READ_ENDS.size()) {
            throw new RuntimeException("Number of suffixes specified must be equal to the number of read ends requested.Passed: " + this.READ_ENDS.size() + " READ_ENDS and " + this.SUFFIXES.size() + " SUFFIXES arguments.");
        }
        if (this.LENGTH.size() == 1) {
            this.LENGTH = Collections.nCopies(this.READ_ENDS.size(), this.LENGTH.get(0));
        }
        if (this.LENGTH.size() != this.READ_ENDS.size()) {
            throw new RuntimeException("Number of lengths specified must be equal to the number of read ends requested.Passed: " + this.READ_ENDS.size() + " READ_ENDS and " + this.LENGTH.size() + " LENGTH arguments.");
        }
        if (this.READ_ENDS.size() != this.OUTPUT_BAMS.size() && this.OUTPUT_BAMS.size() != 1) {
            throw new RuntimeException("Number of output files must be either one, or equal to the number of read ends requested.Passed: " + this.READ_ENDS.size() + " READ_ENDS and " + this.OUTPUT_BAMS.size() + " OUTPUT_BAMS arguments.");
        }
        SAMFileReader inReader = new SAMFileReader(this.IN);
        ArrayList<SAMFileWriter> outWriters = new ArrayList<SAMFileWriter>(this.OUTPUT_BAMS.size());
        for (File outName : this.OUTPUT_BAMS) {
            outWriters.add(new SAMFileWriterFactory().makeSAMOrBAMWriter(inReader.getFileHeader(), true, outName));
        }
        for (SAMRecord read : inReader) {
            if (this.UNMAPPED && !read.getReadUnmappedFlag()) continue;
            for (int i = 0; i < this.READ_ENDS.size(); ++i) {
                SAMRecord newRecord = null;
                try {
                    newRecord = (SAMRecord)read.clone();
                }
                catch (CloneNotSupportedException e) {
                    throw new RuntimeException("Clone not supported by SAMRecord implementation");
                }
                int whichEnd = this.READ_ENDS.get(i);
                int length = this.LENGTH.get(i);
                String name = read.getReadName();
                if (length > read.getReadLength()) {
                    throw new RuntimeException("Read " + name + " is shorter than the specified length (" + read.getReadLength() + "<" + length + ")");
                }
                int start = 0;
                int stop = 0;
                switch (whichEnd) {
                    case 1: {
                        start = 0;
                        stop = start + this.LENGTH.get(i);
                        break;
                    }
                    case 2: {
                        stop = read.getReadLength();
                        start = stop - this.LENGTH.get(i);
                    }
                }
                newRecord.setReadBases(Arrays.copyOfRange(read.getReadBases(), start, stop));
                newRecord.setBaseQualities(Arrays.copyOfRange(read.getBaseQualities(), start, stop));
                newRecord.setReadName(name + this.SUFFIXES.get(i));
                if (!read.getReadUnmappedFlag()) {
                    newRecord.setAlignmentStart(read.getAlignmentStart() + start);
                    newRecord.setCigar(this.chopCigar(read.getCigar(), start, length));
                }
                if (outWriters.size() > 1) {
                    ((SAMFileWriter)outWriters.get(i)).addAlignment(newRecord);
                    continue;
                }
                ((SAMFileWriter)outWriters.get(0)).addAlignment(newRecord);
            }
        }
        inReader.close();
        for (SAMFileWriter w : outWriters) {
            w.close();
        }
        return 0;
    }

    private Cigar chopCigar(Cigar origCigar, int start, int length) {
        int elementEnd = 0;
        Cigar newCigar = new Cigar();
        Iterator elements = origCigar.getCigarElements().iterator();
        if (!elements.hasNext()) {
            System.out.println("CIGAR HAS NO ELEMENTS!");
        }
        CigarElement ce = null;
        while (elementEnd <= start) {
            ce = (CigarElement)elements.next();
            switch (ce.getOperator()) {
                case N: 
                case D: {
                    break;
                }
                case I: 
                case M: 
                case EQ: 
                case X: 
                case S: 
                case H: {
                    elementEnd += ce.getLength();
                }
            }
        }
        newCigar.add(new CigarElement(Math.min(elementEnd - start, length), ce.getOperator()));
        int selectionEnd = start + length;
        while (elementEnd < selectionEnd) {
            ce = (CigarElement)elements.next();
            switch (ce.getOperator()) {
                case N: 
                case D: {
                    newCigar.add(new CigarElement(ce.getLength(), ce.getOperator()));
                    break;
                }
                case I: 
                case M: 
                case EQ: 
                case X: 
                case S: 
                case H: {
                    if ((elementEnd += ce.getLength()) > selectionEnd) {
                        newCigar.add(new CigarElement(ce.getLength() - elementEnd + selectionEnd, ce.getOperator()));
                        break;
                    }
                    newCigar.add(new CigarElement(ce.getLength(), ce.getOperator()));
                }
            }
        }
        return newCigar;
    }
}

