/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.vcf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;
import org.broad.tribble.TribbleException;
import org.broad.tribble.util.ParsingUtils;
import org.broadinstitute.variant.variantcontext.VariantContextComparator;
import org.broadinstitute.variant.vcf.VCFCompoundHeaderLine;
import org.broadinstitute.variant.vcf.VCFContigHeaderLine;
import org.broadinstitute.variant.vcf.VCFFilterHeaderLine;
import org.broadinstitute.variant.vcf.VCFFormatHeaderLine;
import org.broadinstitute.variant.vcf.VCFHeaderLine;
import org.broadinstitute.variant.vcf.VCFHeaderLineCount;
import org.broadinstitute.variant.vcf.VCFHeaderLineType;
import org.broadinstitute.variant.vcf.VCFHeaderVersion;
import org.broadinstitute.variant.vcf.VCFIDHeaderLine;
import org.broadinstitute.variant.vcf.VCFInfoHeaderLine;

public class VCFHeader {
    private final Set<VCFHeaderLine> mMetaData = new LinkedHashSet<VCFHeaderLine>();
    private final Map<String, VCFInfoHeaderLine> mInfoMetaData = new LinkedHashMap<String, VCFInfoHeaderLine>();
    private final Map<String, VCFFormatHeaderLine> mFormatMetaData = new LinkedHashMap<String, VCFFormatHeaderLine>();
    private final Map<String, VCFFilterHeaderLine> mFilterMetaData = new LinkedHashMap<String, VCFFilterHeaderLine>();
    private final Map<String, VCFHeaderLine> mOtherMetaData = new LinkedHashMap<String, VCFHeaderLine>();
    private final List<VCFContigHeaderLine> contigMetaData = new ArrayList<VCFContigHeaderLine>();
    private final List<String> mGenotypeSampleNames = new ArrayList<String>();
    public static final String METADATA_INDICATOR = "##";
    public static final String HEADER_INDICATOR = "#";
    public static final String SOURCE_KEY = "source";
    public static final String REFERENCE_KEY = "reference";
    public static final String CONTIG_KEY = "contig";
    public static final String INTERVALS_KEY = "intervals";
    public static final String EXCLUDE_INTERVALS_KEY = "excludeIntervals";
    public static final String INTERVAL_MERGING_KEY = "interval_merging";
    public static final String INTERVAL_SET_RULE_KEY = "interval_set_rule";
    public static final String INTERVAL_PADDING_KEY = "interval_padding";
    private boolean samplesWereAlreadySorted = true;
    private ArrayList<String> sampleNamesInOrder = null;
    private HashMap<String, Integer> sampleNameToOffset = null;
    private boolean writeEngineHeaders = true;
    private boolean writeCommandLine = true;

    public VCFHeader() {
        this(Collections.emptySet(), Collections.emptySet());
    }

    public VCFHeader(Set<VCFHeaderLine> metaData) {
        this.mMetaData.addAll(metaData);
        this.loadVCFVersion();
        this.loadMetaDataMaps();
    }

    public VCFHeader(VCFHeader toCopy) {
        this(toCopy.mMetaData, toCopy.mGenotypeSampleNames);
    }

    public VCFHeader(Set<VCFHeaderLine> metaData, Set<String> genotypeSampleNames) {
        this(metaData, new ArrayList<String>(genotypeSampleNames));
    }

    public VCFHeader(Set<VCFHeaderLine> metaData, List<String> genotypeSampleNames) {
        this(metaData);
        if (genotypeSampleNames.size() != new HashSet<String>(genotypeSampleNames).size()) {
            throw new TribbleException.InvalidHeader("BUG: VCF header has duplicate sample names");
        }
        this.mGenotypeSampleNames.addAll(genotypeSampleNames);
        this.samplesWereAlreadySorted = ParsingUtils.isSorted(genotypeSampleNames);
        this.buildVCFReaderMaps(genotypeSampleNames);
    }

    private void buildVCFReaderMaps(Collection<String> genotypeSampleNamesInAppearenceOrder) {
        this.sampleNamesInOrder = new ArrayList(genotypeSampleNamesInAppearenceOrder.size());
        this.sampleNameToOffset = new HashMap(genotypeSampleNamesInAppearenceOrder.size());
        int i = 0;
        for (String name : genotypeSampleNamesInAppearenceOrder) {
            this.sampleNamesInOrder.add(name);
            this.sampleNameToOffset.put(name, i++);
        }
        Collections.sort(this.sampleNamesInOrder);
    }

    public void addMetaDataLine(VCFHeaderLine headerLine) {
        this.mMetaData.add(headerLine);
        this.loadMetaDataMaps();
    }

    public List<VCFContigHeaderLine> getContigLines() {
        return Collections.unmodifiableList(this.contigMetaData);
    }

    public SAMSequenceDictionary getSequenceDictionary() {
        List<VCFContigHeaderLine> contigHeaderLines = this.getContigLines();
        if (contigHeaderLines.isEmpty()) {
            return null;
        }
        ArrayList<SAMSequenceRecord> sequenceRecords = new ArrayList<SAMSequenceRecord>(contigHeaderLines.size());
        for (VCFContigHeaderLine contigHeaderLine : contigHeaderLines) {
            sequenceRecords.add(contigHeaderLine.getSAMSequenceRecord());
        }
        return new SAMSequenceDictionary(sequenceRecords);
    }

    public void setSequenceDictionary(SAMSequenceDictionary dictionary) {
        this.contigMetaData.clear();
        for (SAMSequenceRecord record : dictionary.getSequences()) {
            this.contigMetaData.add(new VCFContigHeaderLine(record, null));
        }
        this.mMetaData.addAll(this.contigMetaData);
    }

    public VariantContextComparator getVCFRecordComparator() {
        return new VariantContextComparator((Collection<VCFContigHeaderLine>)this.getContigLines());
    }

    public List<VCFFilterHeaderLine> getFilterLines() {
        ArrayList<VCFFilterHeaderLine> filters = new ArrayList<VCFFilterHeaderLine>();
        for (VCFHeaderLine line : this.mMetaData) {
            if (!(line instanceof VCFFilterHeaderLine)) continue;
            filters.add((VCFFilterHeaderLine)line);
        }
        return filters;
    }

    public List<VCFIDHeaderLine> getIDHeaderLines() {
        ArrayList<VCFIDHeaderLine> filters = new ArrayList<VCFIDHeaderLine>();
        for (VCFHeaderLine line : this.mMetaData) {
            if (!(line instanceof VCFIDHeaderLine)) continue;
            filters.add((VCFIDHeaderLine)((Object)line));
        }
        return filters;
    }

    public void loadVCFVersion() {
        ArrayList<VCFHeaderLine> toRemove = new ArrayList<VCFHeaderLine>();
        for (VCFHeaderLine line : this.mMetaData) {
            if (!VCFHeaderVersion.isFormatString(line.getKey())) continue;
            toRemove.add(line);
        }
        this.mMetaData.removeAll(toRemove);
    }

    private void loadMetaDataMaps() {
        for (VCFHeaderLine line : this.mMetaData) {
            if (line instanceof VCFInfoHeaderLine) {
                VCFInfoHeaderLine infoLine = (VCFInfoHeaderLine)line;
                this.addMetaDataMapBinding(this.mInfoMetaData, infoLine);
                continue;
            }
            if (line instanceof VCFFormatHeaderLine) {
                VCFFormatHeaderLine formatLine = (VCFFormatHeaderLine)line;
                this.addMetaDataMapBinding(this.mFormatMetaData, formatLine);
                continue;
            }
            if (line instanceof VCFFilterHeaderLine) {
                VCFFilterHeaderLine filterLine = (VCFFilterHeaderLine)line;
                this.mFilterMetaData.put(filterLine.getID(), filterLine);
                continue;
            }
            if (line instanceof VCFContigHeaderLine) {
                this.contigMetaData.add((VCFContigHeaderLine)line);
                continue;
            }
            this.mOtherMetaData.put(line.getKey(), line);
        }
        if (this.hasFormatLine("GL") && !this.hasFormatLine("PL")) {
            this.addMetaDataLine(new VCFFormatHeaderLine("PL", VCFHeaderLineCount.G, VCFHeaderLineType.Integer, "Normalized, Phred-scaled likelihoods for genotypes as defined in the VCF specification"));
        }
    }

    private <T extends VCFCompoundHeaderLine> void addMetaDataMapBinding(Map<String, T> map, T line) {
        String key = line.getID();
        if (!map.containsKey(key)) {
            map.put(key, line);
        }
    }

    public Set<HEADER_FIELDS> getHeaderFields() {
        return new LinkedHashSet<HEADER_FIELDS>(Arrays.asList(HEADER_FIELDS.values()));
    }

    public Set<VCFHeaderLine> getMetaDataInInputOrder() {
        return VCFHeader.makeGetMetaDataSet(this.mMetaData);
    }

    public Set<VCFHeaderLine> getMetaDataInSortedOrder() {
        return VCFHeader.makeGetMetaDataSet(new TreeSet<VCFHeaderLine>(this.mMetaData));
    }

    private static Set<VCFHeaderLine> makeGetMetaDataSet(Set<VCFHeaderLine> headerLinesInSomeOrder) {
        LinkedHashSet<VCFHeaderLine> lines = new LinkedHashSet<VCFHeaderLine>();
        lines.add(new VCFHeaderLine(VCFHeaderVersion.VCF4_1.getFormatString(), VCFHeaderVersion.VCF4_1.getVersionString()));
        lines.addAll(headerLinesInSomeOrder);
        return Collections.unmodifiableSet(lines);
    }

    public VCFHeaderLine getMetaDataLine(String key) {
        for (VCFHeaderLine line : this.mMetaData) {
            if (!line.getKey().equals(key)) continue;
            return line;
        }
        return null;
    }

    public List<String> getGenotypeSamples() {
        return this.mGenotypeSampleNames;
    }

    public int getNGenotypeSamples() {
        return this.mGenotypeSampleNames.size();
    }

    public boolean hasGenotypingData() {
        return this.getNGenotypeSamples() > 0;
    }

    public boolean samplesWereAlreadySorted() {
        return this.samplesWereAlreadySorted;
    }

    public int getColumnCount() {
        return HEADER_FIELDS.values().length + (this.hasGenotypingData() ? this.mGenotypeSampleNames.size() + 1 : 0);
    }

    public Collection<VCFInfoHeaderLine> getInfoHeaderLines() {
        return this.mInfoMetaData.values();
    }

    public Collection<VCFFormatHeaderLine> getFormatHeaderLines() {
        return this.mFormatMetaData.values();
    }

    public VCFInfoHeaderLine getInfoHeaderLine(String id) {
        return this.mInfoMetaData.get(id);
    }

    public VCFFormatHeaderLine getFormatHeaderLine(String id) {
        return this.mFormatMetaData.get(id);
    }

    public VCFFilterHeaderLine getFilterHeaderLine(String id) {
        return this.mFilterMetaData.get(id);
    }

    public boolean hasInfoLine(String id) {
        return this.getInfoHeaderLine(id) != null;
    }

    public boolean hasFormatLine(String id) {
        return this.getFormatHeaderLine(id) != null;
    }

    public boolean hasFilterLine(String id) {
        return this.getFilterHeaderLine(id) != null;
    }

    public VCFHeaderLine getOtherHeaderLine(String key) {
        return this.mOtherMetaData.get(key);
    }

    public boolean isWriteEngineHeaders() {
        return this.writeEngineHeaders;
    }

    public void setWriteEngineHeaders(boolean writeEngineHeaders) {
        this.writeEngineHeaders = writeEngineHeaders;
    }

    public boolean isWriteCommandLine() {
        return this.writeCommandLine;
    }

    public void setWriteCommandLine(boolean writeCommandLine) {
        this.writeCommandLine = writeCommandLine;
    }

    public ArrayList<String> getSampleNamesInOrder() {
        return this.sampleNamesInOrder;
    }

    public HashMap<String, Integer> getSampleNameToOffset() {
        return this.sampleNameToOffset;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[VCFHeader:");
        for (VCFHeaderLine line : this.mMetaData) {
            b.append("\n\t").append(line);
        }
        return b.append("\n]").toString();
    }

    public static enum HEADER_FIELDS {
        CHROM,
        POS,
        ID,
        REF,
        ALT,
        QUAL,
        FILTER,
        INFO;

    }
}

