/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.variantcontext;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlEngine;
import org.broad.tribble.TribbleException;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.JEXLMap;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.VariantContextBuilder;
import org.broadinstitute.variant.vcf.VCFCompoundHeaderLine;
import org.broadinstitute.variant.vcf.VCFHeader;

public class VariantContextUtils {
    private static Set<String> MISSING_KEYS_WARNED_ABOUT = new HashSet<String>();
    public static final JexlEngine engine = new JexlEngine();
    private static final boolean ASSUME_MISSING_FIELDS_ARE_STRINGS = false;

    public static Map<String, Object> calculateChromosomeCounts(VariantContext vc, Map<String, Object> attributes, boolean removeStaleValues) {
        return VariantContextUtils.calculateChromosomeCounts(vc, attributes, removeStaleValues, new HashSet<String>(0));
    }

    public static Map<String, Object> calculateChromosomeCounts(VariantContext vc, Map<String, Object> attributes, boolean removeStaleValues, Set<String> founderIds) {
        int AN = vc.getCalledChrCount();
        if (AN == 0 && removeStaleValues) {
            if (attributes.containsKey("AC")) {
                attributes.remove("AC");
            }
            if (attributes.containsKey("AF")) {
                attributes.remove("AF");
            }
            if (attributes.containsKey("AN")) {
                attributes.remove("AN");
            }
            return attributes;
        }
        if (vc.hasGenotypes()) {
            attributes.put("AN", AN);
            if (vc.getAlternateAlleles().size() > 0) {
                ArrayList<Double> alleleFreqs = new ArrayList<Double>();
                ArrayList<Integer> alleleCounts = new ArrayList<Integer>();
                ArrayList<Integer> foundersAlleleCounts = new ArrayList<Integer>();
                double totalFoundersChromosomes = vc.getCalledChrCount(founderIds);
                for (Allele allele : vc.getAlternateAlleles()) {
                    int foundersAltChromosomes = vc.getCalledChrCount(allele, founderIds);
                    alleleCounts.add(vc.getCalledChrCount(allele));
                    foundersAlleleCounts.add(foundersAltChromosomes);
                    if (AN == 0) {
                        alleleFreqs.add(0.0);
                        continue;
                    }
                    Double freq = (double)foundersAltChromosomes / totalFoundersChromosomes;
                    alleleFreqs.add(freq);
                }
                attributes.put("AC", alleleCounts.size() == 1 ? (Serializable)alleleCounts.get(0) : alleleCounts);
                attributes.put("AF", alleleFreqs.size() == 1 ? (Serializable)alleleFreqs.get(0) : alleleFreqs);
            } else {
                attributes.remove("AC");
                attributes.remove("AF");
            }
        }
        return attributes;
    }

    public static void calculateChromosomeCounts(VariantContextBuilder builder, boolean removeStaleValues) {
        VariantContext vc = builder.make();
        builder.attributes(VariantContextUtils.calculateChromosomeCounts(vc, new HashMap<String, Object>(vc.getAttributes()), removeStaleValues, new HashSet<String>(0)));
    }

    public static void calculateChromosomeCounts(VariantContextBuilder builder, boolean removeStaleValues, Set<String> founderIds) {
        VariantContext vc = builder.make();
        builder.attributes(VariantContextUtils.calculateChromosomeCounts(vc, new HashMap<String, Object>(vc.getAttributes()), removeStaleValues, founderIds));
    }

    public static final VCFCompoundHeaderLine getMetaDataForField(VCFHeader header, String field) {
        VCFCompoundHeaderLine metaData = header.getFormatHeaderLine(field);
        if (metaData == null) {
            metaData = header.getInfoHeaderLine(field);
        }
        if (metaData == null) {
            throw new TribbleException("Fully decoding VariantContext requires header line for all fields, but none was found for " + field);
        }
        return metaData;
    }

    public static List<JexlVCMatchExp> initializeMatchExps(String[] names, String[] exps) {
        if (names == null || exps == null) {
            throw new IllegalArgumentException("BUG: neither names nor exps can be null: names " + Arrays.toString(names) + " exps=" + Arrays.toString(exps));
        }
        if (names.length != exps.length) {
            throw new IllegalArgumentException("Inconsistent number of provided filter names and expressions: names=" + Arrays.toString(names) + " exps=" + Arrays.toString(exps));
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < names.length; ++i) {
            map.put(names[i], exps[i]);
        }
        return VariantContextUtils.initializeMatchExps(map);
    }

    public static List<JexlVCMatchExp> initializeMatchExps(ArrayList<String> names, ArrayList<String> exps) {
        String[] nameArray = new String[names.size()];
        String[] expArray = new String[exps.size()];
        return VariantContextUtils.initializeMatchExps(names.toArray(nameArray), exps.toArray(expArray));
    }

    public static List<JexlVCMatchExp> initializeMatchExps(Map<String, String> names_and_exps) {
        ArrayList<JexlVCMatchExp> exps = new ArrayList<JexlVCMatchExp>();
        for (Map.Entry<String, String> elt : names_and_exps.entrySet()) {
            String name = elt.getKey();
            String expStr = elt.getValue();
            if (name == null || expStr == null) {
                throw new IllegalArgumentException("Cannot create null expressions : " + name + " " + expStr);
            }
            try {
                Expression exp = engine.createExpression(expStr);
                exps.add(new JexlVCMatchExp(name, exp));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Argument " + name + "has a bad value. Invalid expression used (" + expStr + "). Please see the JEXL docs for correct syntax.");
            }
        }
        return exps;
    }

    public static boolean match(VariantContext vc, JexlVCMatchExp exp) {
        return VariantContextUtils.match(vc, Arrays.asList(exp)).get(exp);
    }

    public static Map<JexlVCMatchExp, Boolean> match(VariantContext vc, Collection<JexlVCMatchExp> exps) {
        return new JEXLMap(exps, vc);
    }

    public static boolean match(VariantContext vc, Genotype g, JexlVCMatchExp exp) {
        return VariantContextUtils.match(vc, g, Arrays.asList(exp)).get(exp);
    }

    public static Map<JexlVCMatchExp, Boolean> match(VariantContext vc, Genotype g, Collection<JexlVCMatchExp> exps) {
        return new JEXLMap(exps, vc, g);
    }

    @Requires(value={"vc != null"})
    @Ensures(value={"result != null"})
    public static VariantContext sitesOnlyVariantContext(VariantContext vc) {
        return new VariantContextBuilder(vc).noGenotypes().make();
    }

    @Requires(value={"vcs != null"})
    @Ensures(value={"result != null"})
    public static Collection<VariantContext> sitesOnlyVariantContexts(Collection<VariantContext> vcs) {
        ArrayList<VariantContext> r = new ArrayList<VariantContext>();
        for (VariantContext vc : vcs) {
            r.add(VariantContextUtils.sitesOnlyVariantContext(vc));
        }
        return r;
    }

    public static int getSize(VariantContext vc) {
        return vc.getEnd() - vc.getStart() + 1;
    }

    public static Set<String> genotypeNames(Collection<Genotype> genotypes) {
        HashSet<String> names = new HashSet<String>(genotypes.size());
        for (Genotype g : genotypes) {
            names.add(g.getSampleName());
        }
        return names;
    }

    @Requires(value={"! alleles.isEmpty()", "start > 0", "endForSymbolicAlleles == -1 || endForSymbolicAlleles > 0"})
    public static int computeEndFromAlleles(List<Allele> alleles, int start, int endForSymbolicAlleles) {
        Allele ref = alleles.get(0);
        if (ref.isNonReference()) {
            throw new IllegalStateException("computeEndFromAlleles requires first allele to be reference");
        }
        if (VariantContext.hasSymbolicAlleles(alleles)) {
            if (endForSymbolicAlleles == -1) {
                throw new IllegalStateException("computeEndFromAlleles found a symbolic allele but endForSymbolicAlleles was provided");
            }
            return endForSymbolicAlleles;
        }
        return start + Math.max(ref.length() - 1, 0);
    }

    static {
        engine.setSilent(false);
        engine.setLenient(false);
        engine.setDebug(false);
    }

    public static class JexlVCMatchExp {
        public String name;
        public Expression exp;

        public JexlVCMatchExp(String name, Expression exp) {
            this.name = name;
            this.exp = exp;
        }
    }
}

