/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.codecs.hapmap;

import java.util.HashMap;
import java.util.Map;
import org.broad.tribble.Feature;
import org.broad.tribble.annotation.Strand;
import org.broadinstitute.variant.variantcontext.Allele;

public class RawHapMapFeature
implements Feature {
    public static final String NULL_ALLELE_STRING = "-";
    public static final String INSERTION = "I";
    public static final String DELETION = "D";
    private final String name;
    private final String[] alleles;
    private Map<String, Allele> actualAlleles = null;
    private final String contig;
    private long position;
    private final Strand strand;
    private final String assembly;
    private final String center;
    private final String protLSID;
    private final String assayLSID;
    private final String panelLSID;
    private final String qccode;
    private final String[] genotypes;
    private final String headerLine;

    public RawHapMapFeature(String name, String[] alleles, String contig, Long position, Strand strand, String assembly, String center, String protLSID, String assayLSID, String panelLSID, String qccode, String[] genotypes, String headerLine) {
        this.name = name;
        this.alleles = alleles;
        this.contig = contig;
        this.position = position;
        this.strand = strand;
        this.assembly = assembly;
        this.center = center;
        this.protLSID = protLSID;
        this.assayLSID = assayLSID;
        this.panelLSID = panelLSID;
        this.qccode = qccode;
        this.genotypes = genotypes;
        this.headerLine = headerLine;
    }

    public String getChr() {
        return this.contig;
    }

    public int getStart() {
        return (int)this.position;
    }

    public int getEnd() {
        return (int)this.position;
    }

    public Strand getStrand() {
        return this.strand;
    }

    public String getAssembly() {
        return this.assembly;
    }

    public String getCenter() {
        return this.center;
    }

    public String getProtLSID() {
        return this.protLSID;
    }

    public String getAssayLSID() {
        return this.assayLSID;
    }

    public String getPanelLSID() {
        return this.panelLSID;
    }

    public String getQCCode() {
        return this.qccode;
    }

    public String getName() {
        return this.name;
    }

    public String[] getAlleles() {
        return this.alleles;
    }

    public String[] getGenotypes() {
        return this.genotypes;
    }

    public void updatePosition(long position) {
        this.position = position;
    }

    public void setActualAlleles(Map<String, Allele> alleleMap) {
        this.actualAlleles = new HashMap<String, Allele>(alleleMap);
    }

    public Map<String, Allele> getActualAlleles() {
        return this.actualAlleles;
    }

    public String[] getSampleIDs() {
        String[] header = this.headerLine.split("\\s+");
        String[] sample_ids = new String[header.length - 11];
        for (int i = 11; i < header.length; ++i) {
            sample_ids[i - 11] = header[i];
        }
        return sample_ids;
    }
}

