/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.na12878kb.core;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.broadinstitute.sting.gatk.walkers.na12878kb.core.MongoGenotype;
import org.broadinstitute.sting.gatk.walkers.na12878kb.core.MongoVariantContext;
import org.broadinstitute.sting.gatk.walkers.na12878kb.core.NA12878KnowledgeBase;
import org.broadinstitute.sting.gatk.walkers.na12878kb.core.PolymorphicStatus;
import org.broadinstitute.sting.gatk.walkers.na12878kb.core.TruthStatus;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.VariantContextBuilder;

public class ConsensusMaker {
    private static final double CONFIDENCE_THRESHOLD = 0.8;

    public MongoVariantContext makeConsensus(Collection<MongoVariantContext> allSupportingCalls) {
        if (allSupportingCalls == null || allSupportingCalls.isEmpty()) {
            throw new IllegalArgumentException("allSupportingCalls must be non-null, not empty collection");
        }
        MongoVariantContext firstMVC = allSupportingCalls.iterator().next();
        for (MongoVariantContext mvc : allSupportingCalls) {
            this.ensureSafeToCombineInConsensus(firstMVC, mvc);
        }
        List<MongoVariantContext> callsForConsensus = this.mostRecentCalls(allSupportingCalls);
        VariantContextBuilder builder = new VariantContextBuilder();
        VariantContext first = firstMVC.getVariantContext();
        builder.chr(first.getChr()).start((long)first.getStart()).stop((long)first.getEnd());
        List alleles = first.getAlleles();
        builder.alleles((Collection)alleles);
        LinkedHashSet<String> supportingCallSets = new LinkedHashSet<String>();
        for (MongoVariantContext vc : allSupportingCalls) {
            supportingCallSets.addAll(vc.getSupportingCallSets());
        }
        TruthStatus type = this.determineBayesianTruthEstimate(callsForConsensus);
        PolymorphicStatus status = this.determinePolymorphicStatus(callsForConsensus);
        Genotype gt = this.consensusGT(type, status, new LinkedList<Allele>(alleles), callsForConsensus);
        boolean isReviewed = this.isReviewed(callsForConsensus);
        boolean isComplexEvent = this.isComplexEvent(callsForConsensus);
        return MongoVariantContext.create(new LinkedList<String>(supportingCallSets), builder.make(), type, new Date(), gt, isReviewed, isComplexEvent);
    }

    private void ensureSafeToCombineInConsensus(MongoVariantContext canon, MongoVariantContext test) {
        if (!canon.getChr().equals(test.getChr())) {
            throw new IllegalArgumentException("Tried to make consensus from non-equivalent supporting calls (not equal chromosomes): " + canon + " vs " + test);
        }
        if (canon.getStart() != test.getStart()) {
            throw new IllegalArgumentException("Tried to make consensus from non-equivalent supporting calls (not equal start): " + canon + " vs " + test);
        }
        if (canon.getStop() != test.getStop()) {
            throw new IllegalArgumentException("Tried to make consensus from non-equivalent supporting calls (not equal end): " + canon + " vs " + test);
        }
        if (!canon.getRefAllele().equals((Object)test.getRefAllele()) || !canon.getAltAllele().equals((Object)test.getAltAllele())) {
            throw new IllegalArgumentException("Tried to make consensus from non-equivalent supporting calls (not equal alleles): " + canon + " vs " + test);
        }
    }

    @Requires(value={"individualCalls != null"})
    protected boolean isReviewed(Collection<MongoVariantContext> individualCalls) {
        for (MongoVariantContext vc : individualCalls) {
            if (!vc.isReviewed()) continue;
            return true;
        }
        return false;
    }

    @Requires(value={"individualCalls != null"})
    protected boolean isComplexEvent(Collection<MongoVariantContext> individualCalls) {
        for (MongoVariantContext vc : individualCalls) {
            if (!vc.isComplexEvent()) continue;
            return true;
        }
        return false;
    }

    @Requires(value={"individualCalls != null && ! individualCalls.isEmpty()"})
    @Ensures(value={"! result.isEmpty()"})
    protected Collection<MongoVariantContext> selectCallsForConsensus(Collection<MongoVariantContext> individualCalls) {
        LinkedList<MongoVariantContext> reviewed = new LinkedList<MongoVariantContext>();
        for (MongoVariantContext vc : this.mostRecentCalls(individualCalls)) {
            if (!vc.isReviewed()) continue;
            reviewed.add(vc);
        }
        return reviewed.isEmpty() ? individualCalls : reviewed;
    }

    @Requires(value={"individualCalls != null"})
    @Ensures(value={"result != null"})
    protected List<MongoVariantContext> mostRecentCalls(Collection<MongoVariantContext> individualCalls) {
        LinkedHashMap<String, ArrayList<MongoVariantContext>> byCallSet = new LinkedHashMap<String, ArrayList<MongoVariantContext>>();
        for (MongoVariantContext vc : individualCalls) {
            if (vc.getSupportingCallSets().size() != 1) {
                throw new IllegalArgumentException("Expected exactly one supporting call set but got " + vc.getSupportingCallSets());
            }
            ArrayList<MongoVariantContext> calls = (ArrayList<MongoVariantContext>)byCallSet.get(vc.getCallSetName());
            if (calls == null) {
                calls = new ArrayList<MongoVariantContext>();
                byCallSet.put(vc.getCallSetName(), calls);
            }
            calls.add(vc);
        }
        LinkedList<MongoVariantContext> uniques = new LinkedList<MongoVariantContext>();
        for (List callsFor1Callset : byCallSet.values()) {
            Collections.sort(callsFor1Callset, new Comparator<MongoVariantContext>(){

                @Override
                public int compare(MongoVariantContext o1, MongoVariantContext o2) {
                    return -1 * o1.getDate().compareTo(o2.getDate());
                }
            });
            uniques.add((MongoVariantContext)callsFor1Callset.get(0));
        }
        return uniques;
    }

    protected Genotype consensusGT(TruthStatus truthStatus, PolymorphicStatus polyStatus, List<Allele> alleles, Collection<MongoVariantContext> individualCalls) {
        if (!truthStatus.isTruePositive()) {
            return MongoGenotype.NO_CALL;
        }
        if (polyStatus.isDiscordant() || polyStatus.isUnknown()) {
            return MongoGenotype.NO_CALL;
        }
        Genotype g = MongoGenotype.NO_CALL;
        for (MongoVariantContext mvc : individualCalls) {
            Genotype mvcG = mvc.getGt().toGenotype(alleles);
            if (g.isNoCall()) {
                g = mvcG;
                continue;
            }
            if (mvcG.isNoCall()) continue;
            if (g.isMixed() || !g.isAvailable()) {
                throw new IllegalStateException("Unexpected genotype in mongo db " + g + " at " + individualCalls);
            }
            if (g.getType() == mvcG.getType()) continue;
            return MongoGenotype.createDiscordant(mvcG);
        }
        return g;
    }

    private PolymorphicStatus determinePolymorphicStatus(Collection<MongoVariantContext> individualCalls) {
        boolean hasReview = this.isReviewed(individualCalls);
        PolymorphicStatus status = PolymorphicStatus.UNKNOWN;
        for (MongoVariantContext vc : individualCalls) {
            if (hasReview && !vc.isReviewed()) continue;
            status = status.makeConsensus(vc.getPolymorphicStatus());
        }
        return status;
    }

    @Deprecated
    private TruthStatus determineTruth(Collection<MongoVariantContext> individualCalls) {
        boolean hasReview = this.isReviewed(individualCalls);
        TruthStatus type = TruthStatus.UNKNOWN;
        for (MongoVariantContext vc : individualCalls) {
            if (hasReview && !vc.isReviewed()) continue;
            type = type.makeConsensus(vc.getType());
        }
        return type;
    }

    protected TruthStatus determineBayesianTruthEstimate(Collection<MongoVariantContext> calls) {
        double LofSuspect;
        double LofFP;
        double totalL;
        double LofTP = this.calculateLikelihood(calls, TruthStatus.TRUE_POSITIVE);
        TruthStatus status = LofTP / (totalL = LofTP + (LofFP = this.calculateLikelihood(calls, TruthStatus.FALSE_POSITIVE)) + (LofSuspect = this.calculateLikelihood(calls, TruthStatus.SUSPECT))) >= 0.8 ? TruthStatus.TRUE_POSITIVE : (LofFP / totalL >= 0.8 ? TruthStatus.FALSE_POSITIVE : (LofSuspect / totalL >= 0.8 ? TruthStatus.SUSPECT : (this.allStatusesAreUnknown(calls) ? TruthStatus.UNKNOWN : TruthStatus.DISCORDANT)));
        return status;
    }

    private double calculateLikelihood(Collection<MongoVariantContext> calls, TruthStatus status) {
        double confidence = 1.0;
        for (MongoVariantContext call : calls) {
            if (call.getType() == TruthStatus.UNKNOWN) continue;
            double callConfidence = call.getConfidence();
            if (MathUtils.compareDoubles((double)callConfidence, (double)NA12878KnowledgeBase.InputCallsetConfidence.UNKNOWN.confidence) == 0) {
                callConfidence = NA12878KnowledgeBase.InputCallsetConfidence.REVIEW.confidence;
            }
            confidence *= call.getType() == status ? callConfidence : 1.0 - callConfidence;
        }
        return confidence;
    }

    private boolean allStatusesAreUnknown(Collection<MongoVariantContext> calls) {
        for (MongoVariantContext call : calls) {
            if (call.getType() == TruthStatus.UNKNOWN) continue;
            return false;
        }
        return true;
    }
}

