/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.bcf2;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.broad.tribble.TribbleException;
import org.broadinstitute.variant.bcf2.BCF2Type;
import org.broadinstitute.variant.vcf.VCFContigHeaderLine;
import org.broadinstitute.variant.vcf.VCFHeader;
import org.broadinstitute.variant.vcf.VCFHeaderLine;
import org.broadinstitute.variant.vcf.VCFIDHeaderLine;

public final class BCF2Utils {
    public static final int MAX_ALLELES_IN_GENOTYPES = 127;
    public static final int OVERFLOW_ELEMENT_MARKER = 15;
    public static final int MAX_INLINE_ELEMENTS = 14;
    public static final BCF2Type[] INTEGER_TYPES_BY_SIZE = new BCF2Type[]{BCF2Type.INT8, BCF2Type.INT16, BCF2Type.INT32};
    public static final BCF2Type[] ID_TO_ENUM;

    private BCF2Utils() {
    }

    @Requires(value={"header != null"})
    @Ensures(value={"result != null", "new HashSet(result).size() == result.size()"})
    public static ArrayList<String> makeDictionary(VCFHeader header) {
        HashSet<String> seen = new HashSet<String>();
        ArrayList<String> dict = new ArrayList<String>();
        seen.add("PASS");
        dict.add("PASS");
        for (VCFHeaderLine line : header.getMetaDataInInputOrder()) {
            VCFIDHeaderLine idLine;
            if (!(line instanceof VCFIDHeaderLine) || line instanceof VCFContigHeaderLine || seen.contains((idLine = (VCFIDHeaderLine)((Object)line)).getID())) continue;
            dict.add(idLine.getID());
            seen.add(idLine.getID());
        }
        return dict;
    }

    @Requires(value={"nElements >= 0", "nElements <= OVERFLOW_ELEMENT_MARKER", "type != null"})
    public static byte encodeTypeDescriptor(int nElements, BCF2Type type) {
        return (byte)((0xF & nElements) << 4 | type.getID() & 0xF);
    }

    @Ensures(value={"result >= 0"})
    public static int decodeSize(byte typeDescriptor) {
        return (0xF0 & typeDescriptor) >> 4;
    }

    @Ensures(value={"result >= 0"})
    public static int decodeTypeID(byte typeDescriptor) {
        return typeDescriptor & 0xF;
    }

    @Ensures(value={"result != null"})
    public static BCF2Type decodeType(byte typeDescriptor) {
        return ID_TO_ENUM[BCF2Utils.decodeTypeID(typeDescriptor)];
    }

    public static boolean sizeIsOverflow(byte typeDescriptor) {
        return BCF2Utils.decodeSize(typeDescriptor) == 15;
    }

    public static byte readByte(InputStream stream) throws IOException {
        return (byte)(stream.read() & 0xFF);
    }

    @Requires(value={"strings != null"})
    @Ensures(value={"result != null"})
    public static String collapseStringList(List<String> strings) {
        if (strings.isEmpty()) {
            return "";
        }
        if (strings.size() == 1) {
            return strings.get(0);
        }
        StringBuilder b = new StringBuilder();
        for (String s : strings) {
            if (s == null) continue;
            assert (s.indexOf(",") == -1);
            b.append(",").append(s);
        }
        return b.toString();
    }

    @Requires(value={"collapsed != null", "isCollapsedString(collapsed)"})
    @Ensures(value={"result != null"})
    public static List<String> explodeStringList(String collapsed) {
        assert (BCF2Utils.isCollapsedString(collapsed));
        String[] exploded = collapsed.substring(1).split(",");
        return Arrays.asList(exploded);
    }

    @Requires(value={"s != null"})
    public static boolean isCollapsedString(String s) {
        return s.length() > 0 && s.charAt(0) == ',';
    }

    @Requires(value={"vcfFile != null"})
    public static final File shadowBCF(File vcfFile) {
        String path = vcfFile.getAbsolutePath();
        if (path.contains(".vcf")) {
            return new File(path.replace(".vcf", ".bcf"));
        }
        File bcf = new File(path + ".bcf");
        if (bcf.canRead()) {
            return bcf;
        }
        try {
            FileOutputStream o = new FileOutputStream(bcf);
            o.close();
            bcf.delete();
            return bcf;
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Ensures(value={"result.isIntegerType()"})
    public static BCF2Type determineIntegerType(int value) {
        for (BCF2Type potentialType : INTEGER_TYPES_BY_SIZE) {
            if (!potentialType.withinRange(value)) continue;
            return potentialType;
        }
        throw new TribbleException("Integer cannot be encoded in allowable range of even INT32: " + value);
    }

    @Ensures(value={"result.isIntegerType()"})
    public static BCF2Type determineIntegerType(int[] values) {
        BCF2Type minType;
        int max = 0;
        int min = 0;
        for (int v : values) {
            if (v > max) {
                max = v;
            }
            if (v >= min) continue;
            min = v;
        }
        BCF2Type maxType = BCF2Utils.determineIntegerType(max);
        return maxType.compareTo(minType = BCF2Utils.determineIntegerType(min)) >= 0 ? maxType : minType;
    }

    @Requires(value={"t1.isIntegerType()", "t2.isIntegerType()"})
    @Ensures(value={"result.isIntegerType()"})
    public static BCF2Type maxIntegerType(BCF2Type t1, BCF2Type t2) {
        switch (t1) {
            case INT8: {
                return t2;
            }
            case INT16: {
                return t2 == BCF2Type.INT32 ? t2 : t1;
            }
            case INT32: {
                return t1;
            }
        }
        throw new TribbleException("BUG: unexpected BCF2Type " + (Object)((Object)t1));
    }

    @Ensures(value={"result.isIntegerType()"})
    public static BCF2Type determineIntegerType(List<Integer> values) {
        BCF2Type maxType = BCF2Type.INT8;
        block5: for (int value : values) {
            BCF2Type type1 = BCF2Utils.determineIntegerType(value);
            switch (type1) {
                case INT8: {
                    continue block5;
                }
                case INT16: {
                    maxType = BCF2Type.INT16;
                    continue block5;
                }
                case INT32: {
                    return BCF2Type.INT32;
                }
            }
            throw new TribbleException("Unexpected integer type " + (Object)((Object)type1));
        }
        return maxType;
    }

    public static List<Object> toList(Object o) {
        if (o == null) {
            return Collections.emptyList();
        }
        if (o instanceof List) {
            return (List)o;
        }
        return Collections.singletonList(o);
    }

    public static boolean headerLinesAreOrderedConsistently(VCFHeader outputHeader, VCFHeader genotypesBlockHeader) {
        if (!BCF2Utils.nullAsEmpty(outputHeader.getSampleNamesInOrder()).equals(BCF2Utils.nullAsEmpty(genotypesBlockHeader.getSampleNamesInOrder()))) {
            return false;
        }
        Iterator<VCFIDHeaderLine> outputLinesIt = outputHeader.getIDHeaderLines().iterator();
        Iterator<VCFIDHeaderLine> inputLinesIt = genotypesBlockHeader.getIDHeaderLines().iterator();
        while (inputLinesIt.hasNext()) {
            if (!outputLinesIt.hasNext()) {
                return false;
            }
            VCFIDHeaderLine outputLine = outputLinesIt.next();
            VCFIDHeaderLine inputLine = inputLinesIt.next();
            if (inputLine.getClass().equals(outputLine.getClass()) && inputLine.getID().equals(outputLine.getID())) continue;
            return false;
        }
        return true;
    }

    private static <T> List<T> nullAsEmpty(List<T> l) {
        if (l == null) {
            return Collections.emptyList();
        }
        return l;
    }

    static {
        int maxID = -1;
        for (BCF2Type v : BCF2Type.values()) {
            maxID = Math.max(v.getID(), maxID);
        }
        ID_TO_ENUM = new BCF2Type[maxID + 1];
        BCF2Type[] arr$ = BCF2Type.values();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            BCF2Type v;
            BCF2Utils.ID_TO_ENUM[v.getID()] = v = arr$[i$];
        }
    }
}

