/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.duplicates;

import java.util.Arrays;
import java.util.List;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.QualityUtils;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileupImpl;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class DupUtils {
    private static GATKSAMRecord tmpCopyRead(GATKSAMRecord read) {
        try {
            return (GATKSAMRecord)((Object)read.clone());
        }
        catch (CloneNotSupportedException e) {
            throw new ReviewedStingException("Unexpected Clone failure!");
        }
    }

    public static GATKSAMRecord combineDuplicates(GenomeLocParser genomeLocParser, List<GATKSAMRecord> duplicates, int maxQScore) {
        if (duplicates.size() == 0) {
            return null;
        }
        GATKSAMRecord comb = DupUtils.tmpCopyRead(duplicates.get(0));
        comb.setDuplicateReadFlag(false);
        int readLen = comb.getReadBases().length;
        byte[] bases = new byte[readLen];
        byte[] quals = new byte[readLen];
        for (int i = 0; i < readLen; ++i) {
            Pair<Byte, Byte> baseAndQual = DupUtils.combineBaseProbs(genomeLocParser, duplicates, i, maxQScore);
            bases[i] = baseAndQual.getFirst();
            quals[i] = baseAndQual.getSecond();
        }
        comb.setBaseQualities(quals);
        comb.setReadBases(bases);
        return comb;
    }

    private static Pair<Byte, Byte> baseProbs2BaseAndQual(double[] probs, int maxQScore) {
        byte bestBase = 0;
        double bestProb = Double.NEGATIVE_INFINITY;
        double sumProbs = 0.0;
        for (int i = 0; i < 4; ++i) {
            sumProbs += Math.pow(10.0, probs[i]);
            if (!(probs[i] > bestProb)) continue;
            bestBase = BaseUtils.baseIndexToSimpleBase(i);
            bestProb = probs[i];
        }
        Arrays.sort(probs);
        double normalizedP = Math.pow(10.0, bestProb) / sumProbs;
        byte qual = QualityUtils.trueProbToQual(normalizedP, maxQScore);
        return new Pair<Byte, Byte>(bestBase, qual);
    }

    private static void print4BaseQuals(String header, double[] probs) {
        System.out.printf("%s log10(P(b)) is ", header);
        for (int i = 0; i < 4; ++i) {
            System.out.printf("%c=%+.8f ", Character.valueOf((char)BaseUtils.baseIndexToSimpleBase(i)), probs[i]);
        }
        System.out.printf("%n", new Object[0]);
    }

    private static Pair<Byte, Byte> combineBaseProbs(GenomeLocParser genomeLocParser, List<GATKSAMRecord> duplicates, int readOffset, int maxQScore) {
        GenomeLoc loc = genomeLocParser.createGenomeLoc((SAMRecord)duplicates.get(0));
        ReadBackedPileupImpl pileup = new ReadBackedPileupImpl(loc, duplicates, readOffset);
        boolean debug = false;
        double[] qualSums = new double[]{0.0, 0.0, 0.0, 0.0};
        for (PileupElement e : pileup) {
            int baseIndex = e.getBaseIndex();
            byte qual = e.getQual();
            double pqual = QualityUtils.qualToProb(qual);
            for (int j = 0; j < 4; ++j) {
                int n = j;
                qualSums[n] = qualSums[n] + Math.log10(j == baseIndex ? pqual : (1.0 - pqual) / 3.0);
            }
        }
        Pair<Byte, Byte> combined = DupUtils.baseProbs2BaseAndQual(qualSums, maxQScore);
        return combined;
    }
}

