/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.tools;

import java.io.File;
import java.security.KeyPair;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.commandline.Advanced;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.CommandLineProgram;
import org.broadinstitute.sting.tools.GenerateGATKUserKey;
import org.broadinstitute.sting.utils.crypt.CryptUtils;
import org.broadinstitute.sting.utils.exceptions.UserException;

public class GenerateKeyPair
extends CommandLineProgram {
    private static Logger logger = Logger.getLogger(GenerateGATKUserKey.class);
    @Argument(fullName="outputDirectory", shortName="o", doc="Directory to which the key pair should be written (defaults to current working directory)", required=false)
    private File outputDirectory = new File(".");
    @Argument(fullName="keyNamePrefix", shortName="prefix", doc="The public/private key names will start with this prefix", required=false)
    private String keyNamePrefix = "GATK";
    @Argument(fullName="forceOverwriteKeys", shortName="f", doc="If specified, allow existing keys to be overwritten", required=false)
    private boolean overwriteKeys = false;
    @Advanced
    @Argument(fullName="keyLength", shortName="keyLength", doc="Length of the key in bits (DO NOT SPECIFY UNLESS YOU KNOW EXACTLY WHAT YOU'RE DOING)", required=false)
    private int keyLength = 2048;
    @Advanced
    @Argument(fullName="encryptionAlgorithm", shortName="encryptionAlgorithm ", doc="Encryption algorithm to use to generate the key pair (DO NOT SPECIFY UNLESS YOU KNOW EXACTLY WHAT YOU'RE DOING)", required=false)
    private String encryptionAlgorithm = "RSA";
    @Advanced
    @Argument(fullName="randNumberAlgorithm", shortName="randNumberAlgorithm", doc="Random number generation algorithm to use to generate the key pair (DO NOT SPECIFY UNLESS YOU KNOW EXACTLY WHAT YOU'RE DOING)", required=false)
    private String randNumberAlgorithm = "SHA1PRNG";
    public static final String DEFAULT_KEY_NAME_PREFIX = "GATK";
    public static final String PRIVATE_KEY_SUFFIX = "_private.key";
    public static final String PUBLIC_KEY_SUFFIX = "_public.key";

    @Override
    protected int execute() throws Exception {
        File privateKeyFile = new File(this.outputDirectory, this.keyNamePrefix + PRIVATE_KEY_SUFFIX);
        File publicKeyFile = new File(this.outputDirectory, this.keyNamePrefix + PUBLIC_KEY_SUFFIX);
        this.checkForPreexistingKeys(privateKeyFile, publicKeyFile);
        logger.info((Object)"Generating public/private key pair");
        logger.info((Object)String.format("Key Length: %d bits", this.keyLength));
        logger.info((Object)String.format("Encryption Algorithm: %s", this.encryptionAlgorithm));
        logger.info((Object)String.format("Random Number Generation Algorithm: %s", this.randNumberAlgorithm));
        logger.info((Object)"...");
        KeyPair keyPair = CryptUtils.generateKeyPair(this.keyLength, this.encryptionAlgorithm, this.randNumberAlgorithm);
        CryptUtils.writeKeyPair(keyPair, privateKeyFile, publicKeyFile);
        logger.info((Object)"Successfully wrote key pair to files:");
        logger.info((Object)String.format("Private Key: %s", privateKeyFile));
        logger.info((Object)String.format("Public Key: %s", publicKeyFile));
        return 0;
    }

    private void checkForPreexistingKeys(File ... keyFiles) {
        for (File keyFile : keyFiles) {
            if (!keyFile.exists() || this.overwriteKeys) continue;
            throw new UserException(String.format("Key file %s already exists -- refusing to overwrite unless -f is specified", keyFile.getAbsolutePath()));
        }
    }

    public static void main(String[] args) {
        try {
            GenerateKeyPair instance = new GenerateKeyPair();
            GenerateKeyPair.start(instance, args);
            System.exit(CommandLineProgram.result);
        }
        catch (UserException e) {
            GenerateKeyPair.exitSystemWithUserError(e);
        }
        catch (Exception e) {
            GenerateKeyPair.exitSystemWithError(e);
        }
    }
}

