/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.jna.drmaa.v1_0;

import com.sun.jna.Memory;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.StringArray;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.sting.jna.drmaa.v1_0.JnaJobInfo;
import org.broadinstitute.sting.jna.drmaa.v1_0.JnaJobTemplate;
import org.broadinstitute.sting.jna.drmaa.v1_0.LibDrmaa;
import org.ggf.drmaa.AlreadyActiveSessionException;
import org.ggf.drmaa.AuthorizationException;
import org.ggf.drmaa.ConflictingAttributeValuesException;
import org.ggf.drmaa.DefaultContactStringException;
import org.ggf.drmaa.DeniedByDrmException;
import org.ggf.drmaa.DrmCommunicationException;
import org.ggf.drmaa.DrmaaException;
import org.ggf.drmaa.DrmsExitException;
import org.ggf.drmaa.DrmsInitException;
import org.ggf.drmaa.ExitTimeoutException;
import org.ggf.drmaa.HoldInconsistentStateException;
import org.ggf.drmaa.InternalException;
import org.ggf.drmaa.InvalidAttributeFormatException;
import org.ggf.drmaa.InvalidAttributeValueException;
import org.ggf.drmaa.InvalidContactStringException;
import org.ggf.drmaa.InvalidJobException;
import org.ggf.drmaa.JobInfo;
import org.ggf.drmaa.JobTemplate;
import org.ggf.drmaa.NoActiveSessionException;
import org.ggf.drmaa.NoDefaultContactStringException;
import org.ggf.drmaa.PartialTimestamp;
import org.ggf.drmaa.PartialTimestampFormat;
import org.ggf.drmaa.ReleaseInconsistentStateException;
import org.ggf.drmaa.ResumeInconsistentStateException;
import org.ggf.drmaa.Session;
import org.ggf.drmaa.SuspendInconsistentStateException;
import org.ggf.drmaa.TryLaterException;
import org.ggf.drmaa.Version;

public class JnaSession
implements Session {
    private static final PartialTimestampFormat PARTIAL_TIMESTAMP_FORMAT = new PartialTimestampFormat();
    private static final ThreadLocal<Memory> threadError = new ThreadLocal<Memory>(){

        @Override
        protected Memory initialValue() {
            return new Memory(1024L);
        }
    };

    public void init(String contact) throws DrmaaException {
        JnaSession.checkError(LibDrmaa.drmaa_init(contact, (Pointer)JnaSession.getError(), LibDrmaa.DRMAA_ERROR_STRING_BUFFER_LEN));
    }

    public void exit() throws DrmaaException {
        JnaSession.checkError(LibDrmaa.drmaa_exit((Pointer)JnaSession.getError(), LibDrmaa.DRMAA_ERROR_STRING_BUFFER_LEN));
    }

    public JobTemplate createJobTemplate() throws DrmaaException {
        PointerByReference jtRef = new PointerByReference();
        JnaSession.checkError(LibDrmaa.drmaa_allocate_job_template(jtRef, (Pointer)JnaSession.getError(), LibDrmaa.DRMAA_ERROR_STRING_BUFFER_LEN));
        return new JnaJobTemplate(this, jtRef.getValue());
    }

    public void deleteJobTemplate(JobTemplate jobTemplate) throws DrmaaException {
        JnaJobTemplate jnaJobTemplate = (JnaJobTemplate)jobTemplate;
        JnaSession.checkError(LibDrmaa.drmaa_delete_job_template(jnaJobTemplate.getPointer(), (Pointer)JnaSession.getError(), LibDrmaa.DRMAA_ERROR_STRING_BUFFER_LEN));
    }

    public String runJob(JobTemplate jobTemplate) throws DrmaaException {
        Memory jobId = new Memory(1024L);
        JnaJobTemplate jnaJobTemplate = (JnaJobTemplate)jobTemplate;
        JnaSession.checkError(LibDrmaa.drmaa_run_job((Pointer)jobId, LibDrmaa.DRMAA_JOBNAME_BUFFER_LEN, jnaJobTemplate.getPointer(), (Pointer)JnaSession.getError(), LibDrmaa.DRMAA_ERROR_STRING_BUFFER_LEN));
        return jobId.getString(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List runBulkJobs(JobTemplate jobTemplate, int start, int end, int incr) throws DrmaaException {
        PointerByReference jobIds = new PointerByReference();
        JnaJobTemplate jnaJobTemplate = (JnaJobTemplate)jobTemplate;
        JnaSession.checkError(LibDrmaa.drmaa_run_bulk_jobs(jobIds, jnaJobTemplate.getPointer(), start, end, incr, (Pointer)JnaSession.getError(), LibDrmaa.DRMAA_ERROR_STRING_BUFFER_LEN));
        try {
            List<String> list = JnaSession.getJobIds(jobIds);
            return list;
        }
        finally {
            JnaSession.releaseJobIds(jobIds);
        }
    }

    public void control(String jobId, int action) throws DrmaaException {
        JnaSession.checkError(LibDrmaa.drmaa_control(jobId, action, (Pointer)JnaSession.getError(), LibDrmaa.DRMAA_ERROR_STRING_BUFFER_LEN));
    }

    public void synchronize(List list, long timeout, boolean dispose) throws DrmaaException {
        StringArray jobIds = new StringArray(list.toArray(new String[list.size()]));
        JnaSession.checkError(LibDrmaa.drmaa_synchronize((Pointer)jobIds, new NativeLong(timeout), dispose ? 1 : 0, (Pointer)JnaSession.getError(), LibDrmaa.DRMAA_ERROR_STRING_BUFFER_LEN));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobInfo wait(String jobId, long timeout) throws DrmaaException {
        Map<String, String> rusageMap;
        Memory jobIdOut = new Memory(1024L);
        IntByReference stat = new IntByReference();
        PointerByReference rusage2 = new PointerByReference();
        IntByReference exited = new IntByReference();
        IntByReference exitStatus = new IntByReference();
        IntByReference signaled = new IntByReference();
        Memory signal = new Memory(32L);
        IntByReference coreDumped = new IntByReference();
        IntByReference aborted = new IntByReference();
        int errnum = LibDrmaa.drmaa_wait(jobId, (Pointer)jobIdOut, LibDrmaa.DRMAA_JOBNAME_BUFFER_LEN, stat, new NativeLong(timeout), rusage2, (Pointer)JnaSession.getError(), LibDrmaa.DRMAA_ERROR_STRING_BUFFER_LEN);
        if (errnum == 24) {
            rusageMap = null;
        } else {
            try {
                rusageMap = JnaSession.collectionToMap(JnaSession.getAttrValues(rusage2));
            }
            finally {
                JnaSession.releaseAttrValues(rusage2);
            }
        }
        JnaSession.checkError(LibDrmaa.drmaa_wifexited(exited, stat.getValue(), (Pointer)JnaSession.getError(), LibDrmaa.DRMAA_ERROR_STRING_BUFFER_LEN));
        if (exited.getValue() != 0) {
            JnaSession.checkError(LibDrmaa.drmaa_wexitstatus(exitStatus, stat.getValue(), (Pointer)JnaSession.getError(), LibDrmaa.DRMAA_ERROR_STRING_BUFFER_LEN));
        }
        JnaSession.checkError(LibDrmaa.drmaa_wifsignaled(signaled, stat.getValue(), (Pointer)JnaSession.getError(), LibDrmaa.DRMAA_ERROR_STRING_BUFFER_LEN));
        if (signaled.getValue() != 0) {
            JnaSession.checkError(LibDrmaa.drmaa_wtermsig((Pointer)signal, LibDrmaa.DRMAA_SIGNAL_BUFFER_LEN, stat.getValue(), (Pointer)JnaSession.getError(), LibDrmaa.DRMAA_ERROR_STRING_BUFFER_LEN));
            JnaSession.checkError(LibDrmaa.drmaa_wcoredump(coreDumped, stat.getValue(), (Pointer)JnaSession.getError(), LibDrmaa.DRMAA_ERROR_STRING_BUFFER_LEN));
        }
        JnaSession.checkError(LibDrmaa.drmaa_wifaborted(aborted, stat.getValue(), (Pointer)JnaSession.getError(), LibDrmaa.DRMAA_ERROR_STRING_BUFFER_LEN));
        return new JnaJobInfo(jobIdOut.getString(0L), rusageMap, exited.getValue() != 0, exitStatus.getValue(), signaled.getValue() != 0, signal.getString(0L), coreDumped.getValue() != 0, aborted.getValue() != 0);
    }

    public int getJobProgramStatus(String jobId) throws DrmaaException {
        IntByReference remotePs = new IntByReference();
        JnaSession.checkError(LibDrmaa.drmaa_job_ps(jobId, remotePs, (Pointer)JnaSession.getError(), LibDrmaa.DRMAA_ERROR_STRING_BUFFER_LEN));
        return remotePs.getValue();
    }

    public String getContact() {
        Memory contact = new Memory(1024L);
        try {
            JnaSession.checkError(LibDrmaa.drmaa_get_contact((Pointer)contact, LibDrmaa.DRMAA_CONTACT_BUFFER_LEN, (Pointer)JnaSession.getError(), LibDrmaa.DRMAA_ERROR_STRING_BUFFER_LEN));
        }
        catch (DrmaaException e) {
            throw new RuntimeException(e);
        }
        return contact.getString(0L);
    }

    public Version getVersion() {
        IntByReference major = new IntByReference();
        IntByReference minor = new IntByReference();
        try {
            JnaSession.checkError(LibDrmaa.drmaa_version(major, minor, (Pointer)JnaSession.getError(), LibDrmaa.DRMAA_ERROR_STRING_BUFFER_LEN));
        }
        catch (DrmaaException e) {
            throw new RuntimeException(e);
        }
        return new Version(major.getValue(), minor.getValue());
    }

    public String getDrmSystem() {
        Memory drmSystem = new Memory(1024L);
        try {
            JnaSession.checkError(LibDrmaa.drmaa_get_DRM_system((Pointer)drmSystem, LibDrmaa.DRMAA_DRM_SYSTEM_BUFFER_LEN, (Pointer)JnaSession.getError(), LibDrmaa.DRMAA_ERROR_STRING_BUFFER_LEN));
        }
        catch (DrmaaException e) {
            throw new RuntimeException(e);
        }
        return drmSystem.getString(0L);
    }

    public String getDrmaaImplementation() {
        Memory drmaaImplementation = new Memory(1024L);
        try {
            JnaSession.checkError(LibDrmaa.drmaa_get_DRMAA_implementation((Pointer)drmaaImplementation, LibDrmaa.DRMAA_DRMAA_IMPLEMENTATION_BUFFER_LEN, (Pointer)JnaSession.getError(), LibDrmaa.DRMAA_ERROR_STRING_BUFFER_LEN));
        }
        catch (DrmaaException e) {
            throw new RuntimeException(e);
        }
        return drmaaImplementation.getString(0L);
    }

    public static void setAttribute(Pointer jt, String name, String value) throws DrmaaException {
        if (!JnaSession.getAttrNames().contains(name)) {
            throw new InvalidAttributeValueException("Attribute " + name + " is not supported by this implementation of DRMAA");
        }
        JnaSession.checkError(LibDrmaa.drmaa_set_attribute(jt, name, value, (Pointer)JnaSession.getError(), LibDrmaa.DRMAA_ERROR_STRING_BUFFER_LEN));
    }

    public static String getAttribute(Pointer jt, String name) throws DrmaaException {
        if (JnaSession.getAttrNames().contains(name)) {
            Memory attrBuffer = new Memory(1024L);
            JnaSession.checkError(LibDrmaa.drmaa_get_attribute(jt, name, (Pointer)attrBuffer, LibDrmaa.DRMAA_ATTR_BUFFER_LEN, (Pointer)JnaSession.getError(), LibDrmaa.DRMAA_ERROR_STRING_BUFFER_LEN));
            return attrBuffer.getString(0L);
        }
        throw new InvalidAttributeValueException("Attribute " + name + " is not supported by this implementation of DRMAA");
    }

    public static void setVectorAttribute(Pointer jt, String name, Collection<String> values) throws DrmaaException {
        StringArray valuesArray = new StringArray(values.toArray(new String[values.size()]));
        JnaSession.checkError(LibDrmaa.drmaa_set_vector_attribute(jt, name, (Pointer)valuesArray, (Pointer)JnaSession.getError(), LibDrmaa.DRMAA_ERROR_STRING_BUFFER_LEN));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getVectorAttribute(Pointer jt, String name) throws DrmaaException {
        PointerByReference values = new PointerByReference();
        JnaSession.checkError(LibDrmaa.drmaa_get_vector_attribute(jt, name, values, (Pointer)JnaSession.getError(), LibDrmaa.DRMAA_ERROR_STRING_BUFFER_LEN));
        try {
            List<String> list = JnaSession.getAttrValues(values);
            return list;
        }
        finally {
            JnaSession.releaseAttrValues(values);
        }
    }

    public static void setPartialTime(Pointer jt, String name, PartialTimestamp partialTimestamp) throws DrmaaException {
        JnaSession.setAttribute(jt, name, PARTIAL_TIMESTAMP_FORMAT.format(partialTimestamp));
    }

    public static PartialTimestamp getPartialTime(Pointer jt, String name) throws DrmaaException {
        String time = JnaSession.getAttribute(jt, name);
        if (time == null) {
            return null;
        }
        try {
            return PARTIAL_TIMESTAMP_FORMAT.parse(time);
        }
        catch (ParseException e) {
            throw new InternalException(name + " property is unparsable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getAttrNames() throws DrmaaException {
        PointerByReference values = new PointerByReference();
        JnaSession.checkError(LibDrmaa.drmaa_get_attribute_names(values, (Pointer)JnaSession.getError(), LibDrmaa.DRMAA_ERROR_STRING_BUFFER_LEN));
        try {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(JnaSession.getAttrNames(values));
            return linkedHashSet;
        }
        finally {
            JnaSession.releaseAttrNames(values);
        }
    }

    public static Collection<String> mapToCollection(Map<String, String> map) {
        LinkedHashSet<String> collection = new LinkedHashSet<String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            collection.add(entry.getKey() + "=" + entry.getValue());
        }
        return collection;
    }

    public static Map<String, String> collectionToMap(Collection<String> list) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String entry : list) {
            int equals;
            if (entry == null || (equals = entry.indexOf(61)) < 0) continue;
            map.put(entry.substring(0, equals), entry.substring(equals + 1));
        }
        return map;
    }

    public static String formatLimit(long secs) {
        long seconds = secs % 60L;
        long minutes = secs / 60L % 60L;
        long hours = secs / 3600L;
        return String.format("%d:%02d:%02d", hours, minutes, seconds);
    }

    public static long parseLimit(String limit) {
        long seconds = 0L;
        if (limit != null) {
            for (String token : limit.split(":")) {
                seconds *= 60L;
                seconds += Long.parseLong(token);
            }
        }
        return seconds;
    }

    private static List<String> getAttrNames(PointerByReference names) throws DrmaaException {
        ArrayList<String> namesList = new ArrayList<String>();
        IntByReference size = new IntByReference();
        int errnum = LibDrmaa.drmaa_get_num_attr_names(names.getValue(), size);
        JnaSession.checkError(errnum, "unable to get attribute names");
        int num = size.getValue();
        Memory value = new Memory(1024L);
        for (int i = 1; i <= num; ++i) {
            errnum = LibDrmaa.drmaa_get_next_attr_name(names.getValue(), (Pointer)value, LibDrmaa.DRMAA_ATTR_BUFFER_LEN);
            JnaSession.checkError(errnum, "unable to get attribute name " + i);
            if (errnum == 25) break;
            namesList.add(value.getString(0L));
        }
        return namesList;
    }

    private static List<String> getAttrValues(PointerByReference values) throws DrmaaException {
        ArrayList<String> valuesList = new ArrayList<String>();
        IntByReference size = new IntByReference();
        int errnum = LibDrmaa.drmaa_get_num_attr_values(values.getValue(), size);
        JnaSession.checkError(errnum, "unable to get attribute values");
        int num = size.getValue();
        Memory value = new Memory(1024L);
        for (int i = 1; i <= num; ++i) {
            errnum = LibDrmaa.drmaa_get_next_attr_value(values.getValue(), (Pointer)value, LibDrmaa.DRMAA_ATTR_BUFFER_LEN);
            JnaSession.checkError(errnum, "unable to get attribute value " + i);
            if (errnum == 25) break;
            valuesList.add(value.getString(0L));
        }
        return valuesList;
    }

    private static List<String> getJobIds(PointerByReference jobIds) throws DrmaaException {
        ArrayList<String> jobIdsList = new ArrayList<String>();
        IntByReference size = new IntByReference();
        int errnum = LibDrmaa.drmaa_get_num_job_ids(jobIds.getValue(), size);
        JnaSession.checkError(errnum, "unable to get jobIds");
        int num = size.getValue();
        Memory value = new Memory(1024L);
        for (int i = 1; i <= num; ++i) {
            errnum = LibDrmaa.drmaa_get_next_job_id(jobIds.getValue(), (Pointer)value, LibDrmaa.DRMAA_JOBNAME_BUFFER_LEN);
            JnaSession.checkError(errnum, "unable to get jobId " + i);
            if (errnum == 25) break;
            jobIdsList.add(value.getString(0L));
        }
        return jobIdsList;
    }

    private static void releaseAttrNames(PointerByReference names) throws DrmaaException {
        LibDrmaa.drmaa_release_attr_names(names.getValue());
    }

    private static void releaseAttrValues(PointerByReference values) throws DrmaaException {
        LibDrmaa.drmaa_release_attr_values(values.getValue());
    }

    private static void releaseJobIds(PointerByReference jobIds) throws DrmaaException {
        LibDrmaa.drmaa_release_job_ids(jobIds.getValue());
    }

    private static Memory getError() {
        return threadError.get();
    }

    private static void checkError(int errnum) throws DrmaaException {
        if (errnum != 0) {
            JnaSession.checkError(errnum, JnaSession.getError().getString(0L));
        }
    }

    private static void checkError(int errnum, String error) throws DrmaaException {
        switch (errnum) {
            case 0: {
                break;
            }
            case 1: {
                throw new InternalException(error);
            }
            case 2: {
                throw new DrmCommunicationException(error);
            }
            case 3: {
                throw new AuthorizationException(error);
            }
            case 4: {
                throw new IllegalArgumentException(error);
            }
            case 5: {
                throw new NoActiveSessionException(error);
            }
            case 6: {
                throw new OutOfMemoryError(error);
            }
            case 7: {
                throw new InvalidContactStringException(error);
            }
            case 8: {
                throw new DefaultContactStringException(error);
            }
            case 9: {
                throw new NoDefaultContactStringException(error);
            }
            case 10: {
                throw new DrmsInitException(error);
            }
            case 11: {
                throw new AlreadyActiveSessionException(error);
            }
            case 12: {
                throw new DrmsExitException(error);
            }
            case 13: {
                throw new InvalidAttributeFormatException(error);
            }
            case 14: {
                throw new InvalidAttributeValueException(error);
            }
            case 15: {
                throw new ConflictingAttributeValuesException(error);
            }
            case 16: {
                throw new TryLaterException(error);
            }
            case 17: {
                throw new DeniedByDrmException(error);
            }
            case 18: {
                throw new InvalidJobException(error);
            }
            case 19: {
                throw new ResumeInconsistentStateException(error);
            }
            case 20: {
                throw new SuspendInconsistentStateException(error);
            }
            case 21: {
                throw new HoldInconsistentStateException(error);
            }
            case 22: {
                throw new ReleaseInconsistentStateException(error);
            }
            case 23: {
                throw new ExitTimeoutException(error);
            }
            case 24: {
                break;
            }
            case 25: {
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown error code %d: %s", errnum, error));
            }
        }
    }
}

