/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.vcf;

import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import net.sf.picard.cmdline.CommandLineParser;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.Log;
import net.sf.picard.util.MergingIterator;
import net.sf.picard.util.ProgressLogger;
import net.sf.picard.vcf.VariantContextComparator;
import net.sf.picard.vcf.VariantContextIterator;
import net.sf.picard.vcf.VariantContextIteratorFactory;
import net.sf.picard.vcf.VariantContextUtils;
import net.sf.samtools.SAMSequenceDictionary;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.writer.Options;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriter;
import org.broadinstitute.variant.vcf.VCFHeader;
import org.broadinstitute.variant.vcf.VCFUtils;

public class MergeVcfs
extends CommandLineProgram {
    @Usage
    public final String USAGE = CommandLineParser.getStandardUsagePreamble(this.getClass()) + "Merges multiple VCF or BCF files into one VCF file. Input files must be sorted by their contigs " + "and, within contigs, by start position. The input files must have the same sample and " + "contig lists. An index file is created and a sequence dictionary is required by default.";
    @Option(shortName="I", doc="VCF or BCF input files", minElements=1)
    public List<File> INPUT;
    @Option(shortName="O", doc="The merged VCF file")
    public File OUTPUT;
    @Option(shortName="D", doc="The index sequence dictionary (required if CREATE_INDEX=true)", optional=true)
    public File SEQUENCE_DICTIONARY;
    private final Log log = Log.getInstance(MergeVcfs.class);

    public static void main(String[] argv) {
        new MergeVcfs().instanceMainWithExit(argv);
    }

    public MergeVcfs() {
        this.CREATE_INDEX = true;
    }

    @Override
    protected int doWork() {
        ProgressLogger progress = new ProgressLogger(this.log, 10000);
        ArrayList sampleList = new ArrayList();
        ArrayList iteratorCollection = new ArrayList(this.INPUT.size());
        HashSet<VCFHeader> headers = new HashSet<VCFHeader>(this.INPUT.size());
        VariantContextComparator variantContextComparator = null;
        for (File file : this.INPUT) {
            IoUtil.assertFileIsReadable(file);
            VariantContextIterator variantIterator = VariantContextIteratorFactory.create(file);
            VCFHeader header = variantIterator.getHeader();
            if (variantContextComparator == null) {
                variantContextComparator = new VariantContextComparator(header.getContigLines());
            } else if (!variantContextComparator.isCompatible(header.getContigLines())) {
                throw new IllegalArgumentException("The contig entries in input file " + file.getAbsolutePath() + " are not compatible with the others.");
            }
            if (sampleList.isEmpty()) {
                sampleList.addAll(header.getSampleNamesInOrder());
            } else if (!sampleList.equals(header.getSampleNamesInOrder())) {
                throw new IllegalArgumentException("Input file " + file.getAbsolutePath() + " has sample entries that don't match the other files.");
            }
            headers.add(header);
            iteratorCollection.add(variantIterator);
        }
        EnumSet<Options> options = this.CREATE_INDEX != false ? EnumSet.of(Options.INDEX_ON_THE_FLY) : EnumSet.noneOf(Options.class);
        SAMSequenceDictionary sequenceDictionary = this.SEQUENCE_DICTIONARY != null ? VariantContextUtils.getSequenceDictionary(this.SEQUENCE_DICTIONARY) : null;
        VariantContextWriter out = VariantContextUtils.getConditionallyCompressingWriter(this.OUTPUT, sequenceDictionary, options);
        out.writeHeader(new VCFHeader(VCFUtils.smartMergeHeaders(headers, (boolean)false), sampleList));
        MergingIterator<VariantContext> mergingIterator = new MergingIterator<VariantContext>(variantContextComparator, iteratorCollection);
        while (mergingIterator.hasNext()) {
            VariantContext context = mergingIterator.next();
            out.add(context);
            progress.record(context.getChr(), context.getStart());
        }
        out.close();
        return 0;
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.CREATE_INDEX.booleanValue() && this.SEQUENCE_DICTIONARY == null) {
            return new String[]{"If CREATE_INDEX is set a sequence dictionary must be specified."};
        }
        return null;
    }
}

