/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser.readers;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.readers.BinaryFileIterator;
import net.sf.picard.illumina.parser.readers.MMapBackedIteratorFactory;
import net.sf.picard.util.UnsignedTypeUtil;

public class TileMetricsOutReader
implements Iterator<IlluminaTileMetrics> {
    private static final int HEADER_SIZE = 2;
    private static final int EXPECTED_RECORD_SIZE = 10;
    private static final int EXPECTED_VERSION = 2;
    private final BinaryFileIterator<ByteBuffer> bbIterator;

    public TileMetricsOutReader(File tileMetricsOutFile) {
        this.bbIterator = MMapBackedIteratorFactory.getByteBufferIterator(2, 10, tileMetricsOutFile);
        ByteBuffer header = this.bbIterator.getHeaderBytes();
        int actualVersion = UnsignedTypeUtil.uByteToInt(header.get());
        if (actualVersion != 2) {
            throw new PicardException("TileMetricsOutReader expects the version number to be 2.  Actual Version in Header( " + actualVersion + ")");
        }
        int actualRecordSize = UnsignedTypeUtil.uByteToInt(header.get());
        if (10 != actualRecordSize) {
            throw new PicardException("TileMetricsOutReader expects the record size to be 10.  Actual Record Size in Header( " + actualRecordSize + ")");
        }
    }

    @Override
    public boolean hasNext() {
        return this.bbIterator.hasNext();
    }

    @Override
    public IlluminaTileMetrics next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return new IlluminaTileMetrics(this.bbIterator.next());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public class IlluminaTileMetrics {
        private final int laneNumber;
        private final int tileNumber;
        private final int metricCode;
        private final float metricValue;

        public IlluminaTileMetrics(ByteBuffer bb) {
            this.laneNumber = UnsignedTypeUtil.uShortToInt(bb.getShort());
            this.tileNumber = UnsignedTypeUtil.uShortToInt(bb.getShort());
            this.metricCode = UnsignedTypeUtil.uShortToInt(bb.getShort());
            this.metricValue = bb.getFloat();
        }

        public int getLaneNumber() {
            return this.laneNumber;
        }

        public int getTileNumber() {
            return this.tileNumber;
        }

        public int getMetricCode() {
            return this.metricCode;
        }

        public float getMetricValue() {
            return this.metricValue;
        }

        public boolean equals(Object o) {
            if (o instanceof IlluminaTileMetrics) {
                IlluminaTileMetrics that = (IlluminaTileMetrics)o;
                return this.laneNumber == that.laneNumber && this.tileNumber == that.tileNumber && this.metricCode == that.metricCode && this.metricValue == that.metricValue;
            }
            return false;
        }

        public int hashCode() {
            return String.format("%s:%s:%s:%s", this.laneNumber, this.tileNumber, this.metricCode, Float.valueOf(this.metricValue)).hashCode();
        }
    }
}

