/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.sf.picard.PicardException;
import net.sf.picard.util.BasicInputParser;
import net.sf.samtools.util.CloseableIterator;

public class DelimitedTextFileWithHeaderParser
implements Iterable<Row> {
    private final Map<String, Integer> columnLabelIndices = new HashMap<String, Integer>();
    private final BasicInputParser parser;
    private TheIterator extantIterator;

    public DelimitedTextFileWithHeaderParser(BasicInputParser parser) {
        this.parser = parser;
        if (!parser.hasNext()) {
            throw new PicardException("No header line found in file " + parser.getFileName());
        }
        String[] columnLabels = (String[])parser.next();
        for (int i = 0; i < columnLabels.length; ++i) {
            this.columnLabelIndices.put(columnLabels[i], i);
        }
    }

    public boolean hasColumn(String columnLabel) {
        return this.columnLabelIndices.containsKey(columnLabel);
    }

    public Set<String> columnLabels() {
        return this.columnLabelIndices.keySet();
    }

    @Override
    public CloseableIterator<Row> iterator() {
        if (this.extantIterator != null) {
            throw new ConcurrentModificationException("Only one iterator allowed at a time.");
        }
        this.extantIterator = new TheIterator();
        return this.extantIterator;
    }

    public void close() {
        this.parser.close();
    }

    public int getCurrentLineNumber() {
        return this.parser.getCurrentLineNumber();
    }

    public Set<String> getColumnNames() {
        return Collections.unmodifiableSet(this.columnLabelIndices.keySet());
    }

    class TheIterator
    implements CloseableIterator<Row> {
        TheIterator() {
        }

        public boolean hasNext() {
            return DelimitedTextFileWithHeaderParser.this.parser.hasNext();
        }

        public Row next() {
            String[] fields = (String[])DelimitedTextFileWithHeaderParser.this.parser.next();
            String source = DelimitedTextFileWithHeaderParser.this.parser.getCurrentLine();
            return new Row(fields, source);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void close() {
            DelimitedTextFileWithHeaderParser.this.extantIterator = null;
        }
    }

    public class Row {
        private final String[] fields;
        private final String currentLine;

        Row(String[] fields, String source) {
            this.fields = fields;
            this.currentLine = source;
        }

        public String[] getFields() {
            return this.fields;
        }

        public String getField(String columnLabel) {
            Integer key = (Integer)DelimitedTextFileWithHeaderParser.this.columnLabelIndices.get(columnLabel);
            if (key == null) {
                throw new NoSuchElementException(String.format("column %s in %s", columnLabel, DelimitedTextFileWithHeaderParser.this.parser.getFileName()));
            }
            return this.fields[key];
        }

        public Integer getIntegerField(String columnLabel) {
            if (this.fields[(Integer)DelimitedTextFileWithHeaderParser.this.columnLabelIndices.get(columnLabel)] == null) {
                return null;
            }
            return Integer.parseInt(this.fields[(Integer)DelimitedTextFileWithHeaderParser.this.columnLabelIndices.get(columnLabel)]);
        }

        public String getCurrentLine() {
            return this.currentLine;
        }
    }
}

