/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.help;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import org.broadinstitute.sting.gatk.walkers.Walker;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.help.DocletUtils;

public class ResourceBundleExtractorDoclet {
    public static final String VERSION_TAGLET_NAME = "version";
    public static final String SUMMARY_TAGLET_NAME = "help.summary";
    public static final String DESCRIPTION_TAGLET_NAME = "help.description";
    protected final Properties resourceText = new Properties();
    protected final Set<String> undocumentedWalkers = new HashSet<String>();
    protected String buildTimestamp = null;
    protected String absoluteVersion = null;

    public static boolean start(RootDoc rootDoc) throws IOException {
        ResourceBundleExtractorDoclet doclet = new ResourceBundleExtractorDoclet();
        PrintStream out = doclet.loadData(rootDoc, true);
        doclet.processDocs(rootDoc, out);
        return true;
    }

    protected PrintStream loadData(RootDoc rootDoc, boolean overwriteResourcesFile) {
        PrintStream out = System.out;
        for (String[] options : rootDoc.options()) {
            if (options[0].equals("-out")) {
                try {
                    this.loadExistingResourceFile(options[1], rootDoc);
                    if (overwriteResourcesFile) {
                        out = new PrintStream(options[1]);
                    }
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (options[0].equals("-build-timestamp")) {
                this.buildTimestamp = options[1];
            }
            if (!options[0].equals("-absolute-version")) continue;
            this.absoluteVersion = options[1];
        }
        this.resourceText.setProperty("build.timestamp", this.buildTimestamp);
        return out;
    }

    protected void processDocs(RootDoc rootDoc, PrintStream out) {
        HashSet<PackageDoc> packages = new HashSet<PackageDoc>();
        for (ClassDoc currentClass : rootDoc.classes()) {
            PackageDoc containingPackage = currentClass.containingPackage();
            packages.add(containingPackage);
            if (ResourceBundleExtractorDoclet.isRequiredJavadocMissing(currentClass) && ResourceBundleExtractorDoclet.isWalker(currentClass)) {
                this.undocumentedWalkers.add(currentClass.name());
            }
            this.renderHelpText(DocletUtils.getClassName((ProgramElementDoc)currentClass), (Doc)currentClass);
        }
        for (PackageDoc currentPackage : packages) {
            this.renderHelpText(currentPackage.name(), (Doc)currentPackage);
        }
        try {
            this.resourceText.store(out, "Strings displayed by the Sting help system");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String blink = "\u001b[5m";
        String reset = "\u001b[m";
        if (this.undocumentedWalkers.size() > 0) {
            Utils.warnUser(String.format("The following walkers are currently undocumented: %s%s%s", "\u001b[5m", Utils.join(" ", this.undocumentedWalkers), "\u001b[m"));
        }
    }

    public static int optionLength(String option) {
        if (option.equals("-build-timestamp") || option.equals("-out") || option.equals("-absolute-version")) {
            return 2;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadExistingResourceFile(String resourceFileName, RootDoc rootDoc) throws IOException {
        try {
            BufferedReader resourceFile = new BufferedReader(new FileReader(resourceFileName));
            try {
                this.resourceText.load(resourceFile);
            }
            finally {
                resourceFile.close();
            }
        }
        catch (FileNotFoundException e) {
            rootDoc.printNotice("Resource file not found -- generating a new one from scratch.");
        }
    }

    protected static boolean isWalker(ClassDoc classDoc) {
        return DocletUtils.assignableToClass((ProgramElementDoc)classDoc, Walker.class, true);
    }

    private static boolean isRequiredJavadocMissing(ClassDoc classDoc) {
        return classDoc.commentText().length() == 0 || classDoc.commentText().contains("Created by IntelliJ");
    }

    private void renderHelpText(String elementName, Doc element) {
        StringBuilder summaryBuilder = new StringBuilder();
        for (Tag tag : element.firstSentenceTags()) {
            summaryBuilder.append(tag.text());
        }
        String summary = summaryBuilder.toString();
        String description = element.commentText();
        if (this.absoluteVersion != null) {
            this.resourceText.setProperty(String.format("%s.%s", elementName, VERSION_TAGLET_NAME), this.absoluteVersion);
        }
        this.resourceText.setProperty(String.format("%s.%s", elementName, SUMMARY_TAGLET_NAME), ResourceBundleExtractorDoclet.formatText(summary));
        this.resourceText.setProperty(String.format("%s.%s", elementName, DESCRIPTION_TAGLET_NAME), ResourceBundleExtractorDoclet.formatText(description));
    }

    private static String formatText(String text) {
        Scanner scanner = new Scanner(text);
        StringBuilder output = new StringBuilder();
        while (scanner.hasNextLine()) {
            if (output.length() > 0) {
                output.append(' ');
            }
            output.append(scanner.nextLine().trim());
        }
        return output.toString();
    }
}

