/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils;

import java.util.Comparator;
import net.sf.samtools.SAMSequenceDictionary;

public class ContigComparator
implements Comparator<String> {
    final SAMSequenceDictionary dict;

    public ContigComparator(SAMSequenceDictionary dict) {
        if (dict == null) {
            throw new IllegalArgumentException("dict cannot be null");
        }
        this.dict = dict;
    }

    @Override
    public int compare(String chr1, String chr2) {
        int index1 = this.getIndex(chr1);
        int index2 = this.getIndex(chr2);
        return Integer.valueOf(index1).compareTo(index2);
    }

    private int getIndex(String chr) {
        if (chr == null) {
            throw new IllegalArgumentException("chr is null");
        }
        int index = this.dict.getSequenceIndex(chr);
        if (index == -1) {
            throw new IllegalArgumentException("Unknown contig " + chr);
        }
        return index;
    }
}

