/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.io;

import java.io.File;
import java.io.InputStream;

public class Resource {
    private final String path;
    private final Class<?> relativeClass;

    public Resource(String path, Class<?> relativeClass) {
        this.path = path;
        this.relativeClass = relativeClass;
    }

    public Class<?> getRelativeClass() {
        return this.relativeClass;
    }

    public String getPath() {
        return this.path;
    }

    public String getFullPath() {
        if (this.relativeClass == null) {
            return this.path;
        }
        if (new File(this.path).isAbsolute()) {
            return this.path;
        }
        return String.format("%s%s%s", this.relativeClass.getPackage().getName().replace('.', File.separatorChar), File.separator, this.path);
    }

    public InputStream getResourceContentsAsStream() {
        InputStream inputStream;
        Class<?> clazz = this.getRelativeClass();
        if (clazz == null) {
            inputStream = ClassLoader.getSystemResourceAsStream(this.path);
            if (inputStream == null) {
                throw new IllegalArgumentException("Resource not found: " + this.path);
            }
        } else {
            inputStream = clazz.getResourceAsStream(this.path);
            if (inputStream == null) {
                throw new IllegalArgumentException("Resource not found relative to " + clazz + ": " + this.path);
            }
        }
        return inputStream;
    }
}

