/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.sf.samtools.util.CloseableIterator;
import org.apache.log4j.Logger;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.sam.reader.AlignmentReader;
import org.broad.igv.sam.reader.AlignmentReaderFactory;
import org.broad.igv.tools.parsers.DataConsumer;

public class CoverageCounter {
    private static Logger log = Logger.getLogger(CoverageCounter.class);
    private String alignmentFile;
    private DataConsumer consumer;
    private int windowSize = 1;
    private int minMappingQuality = 0;
    static final int STRANDS_BY_READ = 1;
    static final int STRANDS_BY_FIRST_IN_PAIR = 2;
    static final int STRANDS_BY_SECOND_IN_PAIR = 4;
    static final int BASES = 8;
    public static final int INCLUDE_DUPS = 32;
    public static final int PAIRED_COVERAGE = 64;
    private boolean outputSeparate;
    private boolean firstInPair;
    private boolean secondInPair;
    private boolean outputBases;
    private static final int[] output_strands = new int[]{0, 1};
    public static final int NUM_STRANDS = output_strands.length;
    private int extFactor;
    private int preExtFactor;
    private int postExtFactor;
    private boolean includeDuplicates = false;
    private boolean pairedCoverage = false;
    private Genome genome;
    private File wigFile = null;
    private int totalCount = 0;
    private Locus queryInterval;
    private float[] buffer;
    private static final Set<Byte> nucleotidesKeep = new HashSet<Byte>();
    private static final byte[] nucleotides;
    private boolean writeStdOut;

    public CoverageCounter(String alignmentFile, DataConsumer consumer, int windowSize, int extFactor, File wigFile, Genome genome, String queryString, int minMapQual, int countFlags) {
        this.alignmentFile = alignmentFile;
        this.consumer = consumer;
        this.windowSize = windowSize;
        this.extFactor = extFactor;
        this.wigFile = wigFile;
        this.genome = genome;
        this.parseOptions(queryString, minMapQual, countFlags);
        int multiplier = this.outputBases ? 5 : 1;
        int datacols = (this.outputSeparate ? 2 : 1) * multiplier;
        this.buffer = new float[datacols];
    }

    public void setPreExtFactor(int preExtFactor) {
        this.preExtFactor = preExtFactor;
    }

    public void setPosExtFactor(int postExtFactor) {
        this.postExtFactor = postExtFactor;
    }

    private void parseOptions(String queryString, int minMapQual, int countFlags) {
        if (queryString != null) {
            this.queryInterval = Locus.fromString(queryString);
            if (this.queryInterval == null) {
                throw new IllegalArgumentException("Error parsing queryString: " + queryString);
            }
        }
        this.minMappingQuality = minMapQual;
        this.outputSeparate = (countFlags & 1) > 0;
        this.firstInPair = (countFlags & 2) > 0;
        this.secondInPair = (countFlags & 4) > 0;
        this.outputSeparate |= this.firstInPair || this.secondInPair;
        if (this.firstInPair && this.secondInPair) {
            throw new IllegalArgumentException("Can't set both first and second in pair");
        }
        this.outputBases = (countFlags & 8) > 0;
        this.includeDuplicates = (countFlags & 0x20) > 0;
        this.pairedCoverage = (countFlags & 0x40) > 0;
    }

    private boolean passFilter(Alignment alignment) {
        boolean pairingInfo;
        boolean bl = pairingInfo = !this.firstInPair && !this.secondInPair || alignment.getFirstOfPairStrand() != Strand.NONE;
        if (this.pairedCoverage) {
            ReadMate mate = alignment.getMate();
            if (!alignment.isProperPair() || alignment.getMate() == null || alignment.getStart() > mate.getStart()) {
                return false;
            }
            if (Math.abs(alignment.getInferredInsertSize()) > 10000) {
                log.warn("Very large insert size: " + Math.abs(alignment.getInferredInsertSize()) + " for read " + alignment.getReadName() + ".  Skipped.");
                return false;
            }
        }
        return alignment.isMapped() && pairingInfo && (this.includeDuplicates || !alignment.isDuplicate()) && alignment.getMappingQuality() >= this.minMappingQuality && !alignment.isVendorFailedRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void parse() throws IOException {
        int maxExtFactor = Math.max(this.extFactor, Math.max(this.preExtFactor, this.postExtFactor));
        int tolerance = (int)((double)this.windowSize * (Math.floor(maxExtFactor / this.windowSize) + 2.0));
        this.consumer.setSortTolerance(tolerance);
        AlignmentReader reader = null;
        CloseableIterator<Alignment> iter = null;
        String lastChr = "";
        ReadCounter counter = null;
        WigWriter wigWriter = null;
        if (this.wigFile != null || this.writeStdOut) {
            wigWriter = new WigWriter(this.wigFile, this.windowSize);
        }
        try {
            if (this.queryInterval == null) {
                reader = AlignmentReaderFactory.getReader(this.alignmentFile, false);
                iter = reader.iterator();
            } else {
                reader = AlignmentReaderFactory.getReader(this.alignmentFile, true);
                iter = reader.query(this.queryInterval.getChr(), this.queryInterval.getStart() - 1, this.queryInterval.getEnd(), false);
            }
            while (iter != null && iter.hasNext()) {
                int adjustedEnd;
                AlignmentBlock[] blocks;
                Strand strand;
                Alignment alignment = (Alignment)iter.next();
                if (!this.passFilter(alignment) || (strand = this.firstInPair ? alignment.getFirstOfPairStrand() : (this.secondInPair ? alignment.getSecondOfPairStrand() : alignment.getReadStrand())).equals((Object)Strand.NONE)) continue;
                boolean readNegStrand = alignment.isNegativeStrand();
                ++this.totalCount;
                String alignmentChr = alignment.getChr();
                if (alignmentChr.equals(lastChr)) {
                    if (counter != null) {
                        counter.closeBucketsBefore(alignment.getAlignmentStart() - tolerance, wigWriter);
                    }
                } else {
                    if (counter != null) {
                        counter.closeBucketsBefore(Integer.MAX_VALUE, wigWriter);
                    }
                    counter = new ReadCounter(alignmentChr);
                    lastChr = alignmentChr;
                }
                if ((blocks = alignment.getAlignmentBlocks()) != null && !this.pairedCoverage) {
                    for (AlignmentBlock block : blocks) {
                        if (block.isSoftClipped()) continue;
                        byte[] bases = block.getBases();
                        int blockStart = block.getStart();
                        int blockEnd = block.getEnd();
                        int adjustedStart = block.getStart();
                        int adjustedEnd2 = block.getEnd();
                        if (this.preExtFactor > 0) {
                            if (readNegStrand) {
                                adjustedEnd2 = blockEnd + this.preExtFactor;
                            } else {
                                adjustedStart = Math.max(0, blockStart - this.preExtFactor);
                            }
                        }
                        if (this.postExtFactor > 0) {
                            if (readNegStrand) {
                                adjustedStart = Math.max(0, blockEnd - this.postExtFactor);
                            } else {
                                adjustedEnd2 = blockStart + this.postExtFactor;
                            }
                        } else if (this.extFactor > 0) {
                            if (readNegStrand) {
                                adjustedStart = Math.max(0, adjustedStart - this.extFactor);
                            } else {
                                adjustedEnd2 += this.extFactor;
                            }
                        }
                        if (this.queryInterval != null) {
                            adjustedStart = Math.max(this.queryInterval.getStart() - 1, adjustedStart);
                            adjustedEnd2 = Math.min(this.queryInterval.getEnd(), adjustedEnd2);
                        }
                        for (int pos = adjustedStart; pos < adjustedEnd2; ++pos) {
                            byte base = 0;
                            int baseIdx = pos - blockStart;
                            if (bases != null && baseIdx >= 0 && baseIdx < bases.length) {
                                base = bases[baseIdx];
                            }
                            counter.incrementCount(pos, base, strand);
                        }
                    }
                    continue;
                }
                int adjustedStart = alignment.getAlignmentStart();
                int n = adjustedEnd = this.pairedCoverage ? adjustedStart + Math.abs(alignment.getInferredInsertSize()) : alignment.getAlignmentEnd();
                if (readNegStrand) {
                    adjustedStart = Math.max(0, adjustedStart - this.extFactor);
                } else {
                    adjustedEnd += this.extFactor;
                }
                if (this.queryInterval != null) {
                    adjustedStart = Math.max(this.queryInterval.getStart() - 1, adjustedStart);
                    adjustedEnd = Math.min(this.queryInterval.getEnd(), adjustedEnd);
                }
                for (int pos = adjustedStart; pos < adjustedEnd; ++pos) {
                    counter.incrementCount(pos, (byte)78, strand);
                }
            }
            this.consumer.setAttribute("totalCount", String.valueOf(this.totalCount));
            this.consumer.parsingComplete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (counter != null) {
                counter.closeBucketsBefore(Integer.MAX_VALUE, wigWriter);
            }
            if (iter != null) {
                iter.close();
            }
            if (reader != null) {
                reader.close();
            }
            if (wigWriter != null) {
                wigWriter.close();
            }
        }
    }

    public String[] getTrackNames(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        String[] trackNames = new String[this.buffer.length];
        String[] strandArr = this.outputSeparate ? new String[]{"Positive Strand", "Negative Strand"} : new String[]{"Combined Strands"};
        int col = 0;
        for (String sA : strandArr) {
            if (this.outputBases) {
                byte[] arr$ = nucleotides;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Byte n = arr$[i$];
                    trackNames[col] = prefix + " " + sA + " " + new String(new byte[]{n});
                    ++col;
                }
                continue;
            }
            trackNames[col] = prefix + " " + sA;
            ++col;
        }
        return trackNames;
    }

    public void setWriteStdOut(boolean writeStdOut) {
        this.writeStdOut = writeStdOut;
    }

    static {
        for (byte b : nucleotides = new byte[]{65, 67, 71, 84, 78}) {
            nucleotidesKeep.add(b);
        }
    }

    class WigWriter {
        String lastChr = null;
        int lastPosition = 0;
        int step;
        int span;
        PrintWriter pw;

        WigWriter(File file, int step) throws IOException {
            this.step = step;
            this.span = step;
            OutputStreamWriter writer = file != null ? new FileWriter(file) : new OutputStreamWriter(System.out);
            this.pw = new PrintWriter(writer);
        }

        public void addData(String chr, int start, int end, float[] data) {
            for (float di : data) {
                if (!Float.isNaN(di)) continue;
                return;
            }
            if (CoverageCounter.this.genome.getChromosome(chr) == null) {
                return;
            }
            if (end <= start) {
                return;
            }
            int dataSpan = end - start;
            if (this.lastChr == null) {
                this.outputHeader(chr);
            } else if (!chr.equals(this.lastChr) || dataSpan != this.span) {
                this.span = dataSpan;
                this.outputStepLine(chr);
            }
            this.pw.print(start + 1);
            for (int i = 0; i < data.length; ++i) {
                this.pw.print("\t" + data[i]);
            }
            this.pw.println();
            this.lastPosition = start;
            this.lastChr = chr;
        }

        private void close() {
            this.pw.close();
        }

        private void outputTrackLine() {
            this.pw.println("track type=wiggle_0");
        }

        private void outputColumnLabelLine() {
            String[] trackNames = CoverageCounter.this.getTrackNames("");
            if (trackNames.length != 1) {
                String labels = "Pos";
                for (String s : trackNames) {
                    labels = labels + "," + s;
                }
                this.pw.println("#Columns: " + labels);
            }
        }

        private void outputStepLine(String chr) {
            this.pw.println("variableStep chrom=" + chr + " span=" + this.span);
        }

        private void outputHeader(String chr) {
            this.outputTrackLine();
            this.outputColumnLabelLine();
            this.outputStepLine(chr);
        }
    }

    class Counter {
        int[] strandCount;
        int totalCount = 0;
        private Map<Byte, Integer>[] baseTypeCounts;

        Counter() {
            if (CoverageCounter.this.outputBases) {
                this.baseTypeCounts = new HashMap[NUM_STRANDS];
                for (int ii = 0; ii < NUM_STRANDS; ++ii) {
                    this.baseTypeCounts[ii] = new HashMap<Byte, Integer>();
                }
            }
            if (CoverageCounter.this.outputSeparate) {
                this.strandCount = new int[NUM_STRANDS];
            }
        }

        int getCount(int strand) {
            return this.strandCount[strand];
        }

        public int getTotalCounts() {
            return this.totalCount;
        }

        void increment(byte base, int strand) {
            if (CoverageCounter.this.outputBases) {
                this.incrementNucleotide(base, strand);
            }
            if (CoverageCounter.this.outputSeparate) {
                int n = strand;
                this.strandCount[n] = this.strandCount[n] + 1;
            }
            ++this.totalCount;
        }

        private void incrementNucleotide(byte base, int strand) {
            Map<Byte, Integer> btc = this.baseTypeCounts[strand];
            if (!nucleotidesKeep.contains(base)) {
                base = 0;
            }
            int orig = 0;
            if (btc.containsKey(base)) {
                orig = btc.get(base);
            }
            btc.put(base, orig + 1);
        }

        public int getBaseCount(byte base, int strand) {
            return this.baseTypeCounts[strand].containsKey(base) ? this.baseTypeCounts[strand].get(base) : 0;
        }

        public int getBaseCount(byte base) {
            int count = 0;
            for (int strand = 0; strand < NUM_STRANDS; ++strand) {
                count += this.getBaseCount(base, strand);
            }
            return count;
        }
    }

    class ReadCounter {
        String chr;
        TreeMap<Integer, Counter> counts = new TreeMap();

        ReadCounter(String chr) {
            this.chr = chr;
        }

        void incrementCount(int position, byte base, Strand strand) {
            Counter counter = this.getCounterForPosition(position);
            int strandNum = strand.equals((Object)Strand.POSITIVE) ? 0 : 1;
            counter.increment(base, strandNum);
        }

        private Counter getCounterForPosition(int position) {
            int idx = position / CoverageCounter.this.windowSize;
            return this.getCounter(idx);
        }

        private Counter getCounter(int idx) {
            if (!this.counts.containsKey(idx)) {
                this.counts.put(idx, new Counter());
            }
            return this.counts.get(idx);
        }

        void closeBucketsBefore(int position, WigWriter wigWriter) {
            ArrayList<Integer> bucketsToClose = new ArrayList<Integer>();
            int bucket = position / CoverageCounter.this.windowSize;
            for (Map.Entry<Integer, Counter> entry : this.counts.entrySet()) {
                Chromosome chromosome;
                if (entry.getKey() >= bucket) continue;
                int bucketStartPosition = entry.getKey() * CoverageCounter.this.windowSize;
                int bucketEndPosition = bucketStartPosition + CoverageCounter.this.windowSize;
                if (CoverageCounter.this.genome != null && (chromosome = CoverageCounter.this.genome.getChromosome(this.chr)) != null) {
                    bucketEndPosition = Math.min(bucketEndPosition, chromosome.getLength());
                }
                int bucketSize = bucketEndPosition - bucketStartPosition;
                Counter counter = entry.getValue();
                int col = 0;
                if (!CoverageCounter.this.outputBases) {
                    if (CoverageCounter.this.outputSeparate) {
                        for (byte by : output_strands) {
                            ((CoverageCounter)CoverageCounter.this).buffer[col] = (float)counter.getCount(by) / (float)bucketSize;
                            ++col;
                        }
                    } else {
                        ((CoverageCounter)CoverageCounter.this).buffer[col] = (float)counter.getTotalCounts() / (float)bucketSize;
                        ++col;
                    }
                } else if (CoverageCounter.this.outputSeparate) {
                    for (byte by : output_strands) {
                        for (byte base : nucleotides) {
                            ((CoverageCounter)CoverageCounter.this).buffer[col] = (float)counter.getBaseCount(base, by) / (float)bucketSize;
                            ++col;
                        }
                    }
                } else {
                    for (byte by : nucleotides) {
                        ((CoverageCounter)CoverageCounter.this).buffer[col] = (float)counter.getBaseCount(by) / (float)bucketSize;
                        ++col;
                    }
                }
                CoverageCounter.this.consumer.addData(this.chr, bucketStartPosition, bucketEndPosition, CoverageCounter.this.buffer, null);
                if (wigWriter != null) {
                    wigWriter.addData(this.chr, bucketStartPosition, bucketEndPosition, CoverageCounter.this.buffer);
                }
                bucketsToClose.add(entry.getKey());
            }
            for (Integer key : bucketsToClose) {
                this.counts.remove(key);
            }
        }
    }
}

