/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.broad.igv.cli_plugin.Argument;
import org.broad.igv.cli_plugin.LineFeatureDecoder;
import org.broad.igv.cli_plugin.LineFeatureEncoder;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.SpliceJunctionFeature;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.tribble.UCSCCodec;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.util.StringUtils;
import org.broad.igv.util.collections.MultiMap;
import org.broad.tribble.Feature;
import org.broad.tribble.util.ParsingUtils;

public class IGVBEDCodec
extends UCSCCodec<BasicFeature>
implements LineFeatureEncoder<Feature>,
LineFeatureDecoder<BasicFeature> {
    static final Pattern BR_PATTERN = Pattern.compile("<br>");
    static final Pattern EQ_PATTERN = Pattern.compile("=");
    Genome genome;
    private String[] tokens = new String[50];

    public IGVBEDCodec() {
        this((Genome)null);
    }

    public IGVBEDCodec(Genome genome) {
        super(BasicFeature.class);
        this.genome = genome;
    }

    public void setGffTags(boolean gffTags) {
        this.gffTags = gffTags;
    }

    public boolean isGffTags() {
        return this.gffTags;
    }

    @Override
    public BasicFeature decode(String[] tokens) {
        return this.decode(tokens, tokens.length);
    }

    public BasicFeature decode(String[] tokens, int tokenCount) {
        String colorString;
        BasicFeature feature;
        if (tokenCount < 2) {
            return null;
        }
        String c = tokens[0];
        String chr = this.genome == null ? c : this.genome.getChromosomeAlias(c);
        int start = Integer.parseInt(tokens[1]);
        int end = start + 1;
        if (tokenCount > 2) {
            end = Integer.parseInt(tokens[2]);
        }
        BasicFeature basicFeature = feature = this.spliceJunctions ? new SpliceJunctionFeature(chr, start, end) : new BasicFeature(chr, start, end);
        if (tokenCount > 3) {
            if (this.gffTags) {
                String geneSymbols;
                MultiMap<String, String> atts = new MultiMap<String, String>();
                this.tagHelper.parseAttributes(tokens[3], atts);
                String name = this.tagHelper.getName(atts);
                feature.setName(name);
                String id = atts.get("ID");
                if (id != null) {
                    FeatureDB.addFeature(id, feature, this.genome);
                    feature.setIdentifier(id);
                } else {
                    feature.setIdentifier(name);
                }
                String alias = atts.get("Alias");
                if (alias != null) {
                    FeatureDB.addFeature(alias, feature, this.genome);
                }
                if ((geneSymbols = atts.get("Symbol")) != null) {
                    String[] symbols;
                    for (String sym : symbols = geneSymbols.split(",")) {
                        FeatureDB.addFeature(sym.trim(), feature, this.genome);
                    }
                }
                feature.setAttributes(atts);
            } else {
                String name = tokens[3].replaceAll("\"", "");
                feature.setName(name);
                feature.setIdentifier(name);
            }
        }
        if (tokenCount > 4) {
            try {
                float score = Float.parseFloat(tokens[4]);
                feature.setScore(score);
                if (this.spliceJunctions) {
                    ((SpliceJunctionFeature)feature).setJunctionDepth((int)score);
                }
            }
            catch (NumberFormatException numberFormatException) {
                return feature;
            }
        }
        if (tokenCount > 5) {
            int strand;
            String strandString = tokens[5].trim();
            int n = strand = strandString.length() == 0 ? 32 : (int)strandString.charAt(0);
            if (strand == 45) {
                feature.setStrand(Strand.NEGATIVE);
            } else if (strand == 43) {
                feature.setStrand(Strand.POSITIVE);
            } else {
                feature.setStrand(Strand.NONE);
            }
        }
        if (tokenCount > 7) {
            feature.setThickStart(Integer.parseInt(tokens[6]));
            feature.setThickEnd(Integer.parseInt(tokens[7]));
        }
        if (tokenCount > 8 && (colorString = tokens[8]).trim().length() > 0 && !colorString.equals(".")) {
            feature.setColor(ParsingUtils.parseColor(colorString));
        }
        if (tokenCount > 11) {
            this.createExons(start, tokens, feature, chr, feature.getStrand());
            if (this.spliceJunctions) {
                SpliceJunctionFeature junctionFeature = (SpliceJunctionFeature)feature;
                List<Exon> exons = feature.getExons();
                junctionFeature.setJunctionStart(start + exons.get(0).getLength());
                junctionFeature.setJunctionEnd(end - exons.get(1).getLength());
            }
        }
        return feature;
    }

    @Override
    public BasicFeature decode(String nextLine) {
        String trimLine = nextLine.trim();
        if (trimLine.length() == 0) {
            return null;
        }
        if (nextLine.startsWith("#") || nextLine.startsWith("track") || nextLine.startsWith("browser")) {
            this.readHeaderLine(nextLine);
            return null;
        }
        int numTokens = ParsingUtils.splitWhitespace(trimLine, this.tokens);
        return this.decode(this.tokens, numTokens);
    }

    @Override
    public boolean canDecode(String path) {
        return path.toLowerCase().endsWith(".bed");
    }

    private void createExons(int start, String[] tokens, BasicFeature gene, String chr, Strand strand) throws NumberFormatException {
        int exonNumber;
        int cdStart = Integer.parseInt(tokens[6]);
        int cdEnd = Integer.parseInt(tokens[7]);
        int exonCount = Integer.parseInt(tokens[9]);
        String[] exonSizes = new String[exonCount];
        String[] startsBuffer = new String[exonCount];
        ParsingUtils.split(tokens[10], exonSizes, ',');
        ParsingUtils.split(tokens[11], startsBuffer, ',');
        int n = exonNumber = strand == Strand.NEGATIVE ? exonCount : 1;
        if (startsBuffer.length == exonSizes.length) {
            for (int i = 0; i < startsBuffer.length; ++i) {
                int exonStart = start + Integer.parseInt(startsBuffer[i]);
                int exonEnd = exonStart + Integer.parseInt(exonSizes[i]);
                Exon exon = new Exon(chr, exonStart, exonEnd, strand);
                exon.setCodingStart(cdStart);
                exon.setCodingEnd(cdEnd);
                exon.setNumber(exonNumber);
                gene.addExon(exon);
                if (strand == Strand.NEGATIVE) {
                    --exonNumber;
                    continue;
                }
                ++exonNumber;
            }
        }
    }

    @Override
    public String encode(Feature feature) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(feature.getChr());
        buffer.append("\t");
        int featureStart = feature.getStart();
        buffer.append(String.valueOf(featureStart));
        buffer.append("\t");
        buffer.append(String.valueOf(feature.getEnd()));
        BasicFeature basicFeature = null;
        if (!(feature instanceof BasicFeature)) {
            return buffer.toString();
        }
        basicFeature = (BasicFeature)feature;
        if (basicFeature.getName() != null || this.gffTags && basicFeature.getDescription() != null) {
            boolean more;
            buffer.append("\t");
            if (this.gffTags && basicFeature.getDescription() != null) {
                String[] attrs = BR_PATTERN.split(basicFeature.getDescription());
                buffer.append("\"");
                for (String att : attrs) {
                    String[] kv = EQ_PATTERN.split(att, 2);
                    if (kv.length <= 1) continue;
                    buffer.append(kv[0].trim());
                    buffer.append("=");
                    String value = kv[1].trim();
                    buffer.append(StringUtils.encodeURL(value));
                    buffer.append(";");
                }
                buffer.append("\"");
            } else {
                buffer.append(basicFeature.getName());
            }
            boolean bl = more = !Float.isNaN(basicFeature.getScore()) || basicFeature.getStrand() != Strand.NONE || basicFeature.getColor() != null || basicFeature.getExonCount() > 0;
            if (more) {
                buffer.append("\t");
                float score = basicFeature.getScore();
                if (Float.isNaN(score)) {
                    buffer.append("1000");
                } else {
                    boolean isInt = Math.floor(score) == (double)score;
                    buffer.append(String.valueOf(isInt ? (float)((int)score) : score));
                }
                boolean bl2 = more = basicFeature.getStrand() != Strand.NONE || basicFeature.getColor() != null || basicFeature.getExonCount() > 0;
                if (more) {
                    buffer.append("\t");
                    Strand strand = basicFeature.getStrand();
                    if (strand == Strand.NONE) {
                        buffer.append(" ");
                    } else if (strand == Strand.POSITIVE) {
                        buffer.append("+");
                    } else if (strand == Strand.NEGATIVE) {
                        buffer.append("-");
                    }
                    boolean bl3 = more = basicFeature.getColor() != null || basicFeature.getExonCount() > 0;
                    if (more) {
                        List<Exon> exons = basicFeature.getExons();
                        if (basicFeature.getColor() != null || exons != null) {
                            buffer.append("\t");
                            buffer.append(String.valueOf(basicFeature.getThickStart()));
                            buffer.append("\t");
                            buffer.append(String.valueOf(basicFeature.getThickEnd()));
                            buffer.append("\t");
                            Color c = basicFeature.getColor();
                            buffer.append(c == null ? "." : ColorUtilities.colorToString(c));
                            buffer.append("\t");
                            if (exons != null && exons.size() > 0) {
                                buffer.append(String.valueOf(exons.size()));
                                buffer.append("\t");
                                for (Exon exon : exons) {
                                    buffer.append(String.valueOf(exon.getLength()));
                                    buffer.append(",");
                                }
                                buffer.append("\t");
                                for (Exon exon : exons) {
                                    int exonStart = exon.getStart() - featureStart;
                                    buffer.append(String.valueOf(exonStart));
                                    buffer.append(",");
                                }
                            }
                        }
                    }
                }
            }
        }
        return buffer.toString();
    }

    @Override
    public int getNumCols(String line) {
        return line.split("\t").length;
    }

    @Override
    public String getHeader() {
        return null;
    }

    @Override
    public void setInputs(List<String> commands, Map<Argument, Object> argumentMap, Argument argument) {
    }
}

