/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.broad.igv.Globals;
import org.broad.igv.feature.AbstractFeatureParser;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.FeatureParser;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.IExon;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.tribble.IGVBEDCodec;
import org.broad.igv.util.ParsingUtils;
import org.broad.tribble.Feature;

public class FeatureFileUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void computeBedDensity(String iFile, String oFile, int windowSize, int step) throws IOException {
        BufferedReader br = null;
        PrintWriter pw = null;
        try {
            String nextLine;
            br = ParsingUtils.openBufferedReader(iFile);
            pw = new PrintWriter(new BufferedWriter(new FileWriter(oFile)));
            LinkedHashMap<Integer, Window> openWindows = new LinkedHashMap<Integer, Window>();
            int lastWindowOutput = 0;
            String lastChr = null;
            while ((nextLine = br.readLine()) != null) {
                int w;
                String[] tokens;
                if (nextLine.startsWith("track") || nextLine.startsWith("#") || (tokens = Globals.tabPattern.split(nextLine)).length < 3) continue;
                String chr = tokens[0];
                int start = Integer.parseInt(tokens[1]);
                int end = Integer.parseInt(tokens[2]);
                if (!chr.equals(lastChr)) {
                    lastWindowOutput = 0;
                    for (Window window : openWindows.values()) {
                        w = window.idx;
                        int windowCenter = w * step + windowSize / 2;
                        int windowStart = windowCenter - step / 2;
                        int windowEnd = windowStart + step;
                        pw.println(lastChr + "\t" + windowStart + "\t" + windowEnd + "\t" + window.count);
                    }
                    openWindows.clear();
                    lastChr = chr;
                }
                int startWindow = start / step;
                int endWindow = (end + windowSize) / step;
                for (w = startWindow; w < endWindow; ++w) {
                    Window window = (Window)openWindows.get(w);
                    if (window == null) {
                        window = new Window(w);
                        openWindows.put(w, window);
                    }
                    window.increment();
                }
                if (startWindow <= lastWindowOutput) continue;
                for (w = lastWindowOutput; w < startWindow; ++w) {
                    Window window = (Window)openWindows.get(w);
                    if (window == null) continue;
                    int windowCenter = w * step + windowSize / 2;
                    int windowStart = windowCenter - step / 2;
                    int windowEnd = windowStart + step;
                    pw.println(chr + "\t" + windowStart + "\t" + windowEnd + "\t" + window.count);
                }
                for (w = lastWindowOutput; w < startWindow; ++w) {
                    openWindows.remove(w);
                }
                lastWindowOutput = startWindow - 1;
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (pw != null) {
                pw.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createCanonicalGeneFile(String iFile, String outputFile) throws IOException {
        BufferedReader br = null;
        PrintWriter pw = null;
        try {
            br = new BufferedReader(new FileReader(iFile));
            pw = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
            FeatureParser parser = AbstractFeatureParser.getInstanceFor(iFile, null);
            List<Feature> features = parser.loadFeatures(br, null);
            IGVBEDCodec codec = new IGVBEDCodec();
            HashMap genes = new HashMap();
            for (Feature f : features) {
                BasicFeature transcript = (BasicFeature)f;
                String geneName = transcript.getName();
                ArrayList<BasicFeature> genelist = (ArrayList<BasicFeature>)genes.get(geneName);
                if (genelist == null) {
                    genelist = new ArrayList<BasicFeature>();
                    genes.put(geneName, genelist);
                }
                boolean foundOverlap = false;
                for (BasicFeature gene : genelist) {
                    if (!gene.overlaps(transcript)) continue;
                    gene.setThickStart(Math.min(gene.getThickStart(), transcript.getThickStart()));
                    gene.setThickEnd(Math.max(gene.getThickEnd(), transcript.getThickEnd()));
                    FeatureFileUtils.mergeExons(gene, transcript.getExons());
                    foundOverlap = true;
                    break;
                }
                if (foundOverlap) continue;
                genelist.add(transcript);
            }
            for (List geneList : genes.values()) {
                for (BasicFeature gene : geneList) {
                    pw.println(codec.encode(gene));
                }
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (pw != null) {
                pw.close();
            }
        }
    }

    private static void mergeExons(BasicFeature gene, List<Exon> exons) {
        HashSet<Exon> exonProxies = new HashSet<Exon>(gene.getExons());
        for (Exon exon : gene.getExons()) {
            exonProxies.add((Exon)Exon.getExonProxy(exon));
        }
        for (Exon exon : exons) {
            IExon proxy = Exon.getExonProxy(exon);
            if (exonProxies.contains(proxy)) continue;
            gene.addExon(exon);
        }
        FeatureUtils.sortFeatureList(gene.getExons());
    }

    static void covertProbeMapToBedFile(String probeMapFile, String bedFile) throws FileNotFoundException, IOException {
        String nextLine;
        BufferedReader br = new BufferedReader(new FileReader(probeMapFile));
        PrintWriter pw = new PrintWriter(new FileWriter(bedFile));
        while ((nextLine = br.readLine()) != null) {
            String[] tokens = nextLine.split("\t");
            Locus locus = Locus.fromString(tokens[1].trim());
            pw.println(locus.getChr() + "\t" + locus.getStart() + "\t" + locus.getEnd() + "\t" + tokens[0].trim());
        }
        br.close();
        pw.close();
    }

    static void splitEmblFileByType(String emblFile, String outputDirectory) throws IOException {
        String nextLine;
        BufferedReader br = new BufferedReader(new FileReader(emblFile));
        HashSet<String> codes = new HashSet<String>();
        while ((nextLine = br.readLine()) != null) {
            String code;
            if (!nextLine.startsWith("FT") || nextLine.length() <= 19 || (code = nextLine.substring(5, 19).trim()).length() <= 0) continue;
            codes.add(code);
        }
        br.close();
        HashMap<String, PrintWriter> writers = new HashMap<String, PrintWriter>();
        for (String code : codes) {
            writers.put(code, new PrintWriter(new FileWriter(new File(outputDirectory, code + ".embl"))));
        }
        br = new BufferedReader(new FileReader(emblFile));
        PrintWriter currentWriter = null;
        while ((nextLine = br.readLine()) != null) {
            if (nextLine.startsWith("ID")) {
                for (PrintWriter pw : writers.values()) {
                    pw.println(nextLine);
                }
                continue;
            }
            if (nextLine.startsWith("FT")) {
                String code;
                code = nextLine.substring(5, 19).trim();
                if (code.length() > 0) {
                    currentWriter = (PrintWriter)writers.get(code);
                }
                if (currentWriter == null) continue;
                currentWriter.println(nextLine);
                continue;
            }
            currentWriter = null;
        }
        br.close();
        for (PrintWriter pw : writers.values()) {
            pw.close();
        }
    }

    static class Window {
        int idx;
        int count;

        Window(int idx) {
            this.idx = idx;
        }

        void increment() {
            ++this.count;
        }
    }
}

