/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.vcf;

import java.io.InputStream;
import net.sf.picard.vcf.VariantContextIterator;
import net.sf.samtools.util.CloserUtil;
import org.broad.tribble.readers.LineIterator;
import org.broad.tribble.readers.LineIteratorImpl;
import org.broad.tribble.readers.LineReaderUtil;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.vcf.VCFCodec;
import org.broadinstitute.variant.vcf.VCFHeader;

public class VcfIterator
implements VariantContextIterator {
    private final VCFCodec vcfCodec = new VCFCodec();
    private final VCFHeader vcfHeader;
    private final LineIterator lineIterator;

    public VcfIterator(InputStream vcfStream) {
        this.lineIterator = new LineIteratorImpl(LineReaderUtil.fromBufferedStream(vcfStream));
        this.vcfHeader = (VCFHeader)this.vcfCodec.readActualHeader(this.lineIterator);
    }

    @Override
    public void close() {
        CloserUtil.close(this.lineIterator);
    }

    @Override
    public VCFHeader getHeader() {
        return this.vcfHeader;
    }

    @Override
    public boolean hasNext() {
        return this.lineIterator.hasNext();
    }

    @Override
    public VariantContext next() {
        return this.vcfCodec.decode((String)this.lineIterator.next());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

