/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser.readers;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.readers.BclQualityEvaluationStrategy;
import net.sf.picard.util.UnsignedTypeUtil;
import net.sf.samtools.util.CloserUtil;

public class BclReader
implements Iterator<BclValue> {
    private static final int HEADER_SIZE = 4;
    private final BclQualityEvaluationStrategy bclQualityEvaluationStrategy;
    public final long numClusters;
    private final InputStream inputStream;
    private final String filePath;
    private static final byte BASE_MASK = 3;
    private static final byte A_VAL = 0;
    private static final byte C_VAL = 1;
    private static final byte G_VAL = 2;
    private static final byte T_VAL = 3;
    private long nextCluster;

    public BclReader(File file, BclQualityEvaluationStrategy bclQualityEvaluationStrategy) {
        this.bclQualityEvaluationStrategy = bclQualityEvaluationStrategy;
        this.filePath = file.getAbsolutePath();
        boolean isGzip = this.filePath.endsWith(".gz");
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            this.inputStream = isGzip ? new GZIPInputStream(bufferedInputStream) : bufferedInputStream;
        }
        catch (FileNotFoundException fnfe) {
            throw new PicardException("File not found: (" + this.filePath + ")", fnfe);
        }
        catch (IOException ioe) {
            throw new PicardException("Error reading file: (" + this.filePath + ")", ioe);
        }
        this.numClusters = this.getNumClusters();
        if (file.length() == 0L) {
            throw new PicardException("Zero length BCL file detected: " + this.filePath);
        }
        if (!isGzip) {
            this.assertProperFileStructure(file);
        }
        this.nextCluster = 0L;
    }

    private long getNumClusters() {
        byte[] header = new byte[4];
        try {
            int headerBytesRead = this.inputStream.read(header);
            if (headerBytesRead != 4) {
                throw new PicardException("Malformed file, expected header of size 4 but received " + headerBytesRead);
            }
        }
        catch (IOException ioe) {
            throw new PicardException("Unable to read header for file (" + this.filePath + ")", ioe);
        }
        ByteBuffer headerBuf = ByteBuffer.wrap(header);
        headerBuf.order(ByteOrder.LITTLE_ENDIAN);
        return UnsignedTypeUtil.uIntToLong(headerBuf.getInt());
    }

    private void assertProperFileStructure(File file) {
        long elementsInFile = file.length() - 4L;
        if (this.numClusters != elementsInFile) {
            throw new PicardException("Expected " + this.numClusters + " in file but found " + elementsInFile);
        }
    }

    @Override
    public boolean hasNext() {
        return this.nextCluster < this.numClusters;
    }

    @Override
    public BclValue next() {
        byte quality;
        byte base;
        byte[] elements = new byte[1];
        try {
            if (this.inputStream.read(elements) != 1) {
                throw new PicardException("Error when reading byte from file (" + this.filePath + ")");
            }
        }
        catch (EOFException eofe) {
            throw new PicardException("Attempted to read byte from file but none were available: (" + this.filePath + ")", eofe);
        }
        catch (IOException ioe) {
            throw new PicardException("Error when reading byte from file (" + this.filePath + ")", ioe);
        }
        byte element = elements[0];
        if (element == 0) {
            base = 46;
            quality = 2;
        } else {
            switch (element & 3) {
                case 0: {
                    base = 65;
                    break;
                }
                case 1: {
                    base = 67;
                    break;
                }
                case 2: {
                    base = 71;
                    break;
                }
                case 3: {
                    base = 84;
                    break;
                }
                default: {
                    throw new PicardException("Impossible case! BCL Base value neither A, C, G, nor T! Value(" + (element & 3) + ") + in file(" + this.filePath + ")");
                }
            }
            quality = this.bclQualityEvaluationStrategy.reviseAndConditionallyLogQuality((byte)(UnsignedTypeUtil.uByteToInt(element) >>> 2));
        }
        ++this.nextCluster;
        return new BclValue(base, quality);
    }

    public void close() {
        CloserUtil.close(this.inputStream);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public class BclValue {
        public final byte base;
        public final byte quality;

        public BclValue(byte base, byte quality) {
            this.base = base;
            this.quality = quality;
        }
    }
}

