/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.runtime;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import com.google.java.contract.core.util.DebugUtils;
import com.google.java.contract.core.util.PatternMap;

@Invariant(value={"blacklist != null"})
public class BlacklistManager {
    protected static BlacklistManager instance = null;
    protected PatternMap<Boolean> blacklist = new PatternMap();

    protected BlacklistManager() {
        this.blacklist.put("java.*", true);
        this.blacklist.put("javax.*", true);
        this.blacklist.put("com.sun.*", true);
        this.blacklist.put("sun.*", true);
    }

    public static BlacklistManager getInstance() {
        if (instance == null) {
            instance = new BlacklistManager();
        }
        return instance;
    }

    @Requires(value={"pattern != null"})
    @Ensures(value={"isIgnored(pattern)"})
    public synchronized void ignore(String string) {
        DebugUtils.info("activation", string + " +blacklist");
        this.blacklist.put(string, true);
    }

    @Requires(value={"pattern != null"})
    @Ensures(value={"!isIgnored(pattern)"})
    public synchronized void unignore(String string) {
        DebugUtils.info("activation", string + " -blacklist");
        this.blacklist.put(string, false);
    }

    @Requires(value={"pattern != null"})
    public synchronized boolean isIgnored(String string) {
        if (string.endsWith(".*") && this.blacklist.isOverriden(string)) {
            return false;
        }
        Boolean bl = this.blacklist.get(string);
        return bl != null && bl != false;
    }
}

