/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingWorker;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.feature.tribble.CodecFactory;
import org.broad.igv.sam.reader.AlignmentIndexer;
import org.broad.igv.sam.reader.FeatureIndex;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.TribbleException;
import org.broad.tribble.index.Index;
import org.broad.tribble.index.IndexFactory;
import org.jdesktop.layout.GroupLayout;

public class IndexCreatorDialog
extends JDialog {
    File file;
    File idxFile;
    IndexWorker worker;
    FileType fileType;
    static String introText = "An index file for @filename could not be located. An index is required to view @filetype files in IGV.  Click \"Go\" to create one now.";
    private JButton cancelButton;
    private JButton goButton;
    private JTextPane introTextPane;
    private JLabel jLabel1;
    private JScrollPane jScrollPane2;
    private JProgressBar progressBar;
    private JLabel timeRemainingLabel;

    public IndexCreatorDialog(Frame parent, boolean modal, File file, File idxFile) {
        super(parent, modal);
        this.initComponents();
        this.file = file;
        this.idxFile = idxFile;
        this.determineFileType(file);
        if (this.fileType == null) {
            throw new IllegalArgumentException("Cannot determine file type for " + file.getAbsolutePath());
        }
        int timeEst = 1 + (int)Math.ceil((double)file.length() / 1.0E9);
        String txt = introText.replace("@filename", file.getName()).replace("@time", String.valueOf(timeEst)).replace("@filetype", this.fileType.name());
        this.introTextPane.setText(txt);
        this.introTextPane.setBorder(BorderFactory.createEmptyBorder());
        switch (this.fileType) {
            case SAM: {
                this.worker = new SamIndexWorker();
                break;
            }
            case VCF: {
                this.worker = new VCFIndexWorker();
            }
        }
    }

    private void determineFileType(File file) {
        for (FileType ft : FileType.values()) {
            if (!file.getName().toLowerCase().endsWith(ft.name().toLowerCase())) continue;
            this.fileType = ft;
        }
    }

    public Object getIndex() {
        if (this.worker == null || !this.worker.isDone()) {
            return null;
        }
        try {
            return this.worker.get();
        }
        catch (Exception ex) {
            MessageUtils.showMessage(ex.getMessage());
            return null;
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.progressBar = new JProgressBar();
        this.timeRemainingLabel = new JLabel();
        this.goButton = new JButton();
        this.cancelButton = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.introTextPane = new JTextPane();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("Estimated time remaining: ");
        this.goButton.setText("Go");
        this.goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndexCreatorDialog.this.goButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndexCreatorDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.introTextPane.setBackground(this.getParent().getBackground());
        this.introTextPane.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.introTextPane.setEditable(false);
        this.introTextPane.setText("An index file for [filename goes here] could not be located.  An index is required to view alignments in IGV.  Click \"Go\" to create one now.  This will take approximately [time goes here] to complete.");
        this.introTextPane.setFocusable(false);
        this.jScrollPane2.setViewportView(this.introTextPane);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(30, 30, 30).add(layout.createParallelGroup(1).add(this.jScrollPane2, -2, 343, -2).add(layout.createSequentialGroup().add(this.jLabel1).add(18, 18, 18).add(this.timeRemainingLabel, -2, 103, -2)).add(layout.createParallelGroup(2).add(layout.createSequentialGroup().add(this.cancelButton).add(18, 18, 18).add(this.goButton)).add(this.progressBar, -2, 351, -2))).addContainerGap(26, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().addContainerGap(23, Short.MAX_VALUE).add(this.jScrollPane2, -2, 132, -2).add(35, 35, 35).add(layout.createParallelGroup(3).add(this.jLabel1, -2, 27, -2).add(this.timeRemainingLabel, -2, 16, -2)).addPreferredGap(0).add(this.progressBar, -2, -1, -2).add(18, 18, 18).add(layout.createParallelGroup(3).add(this.goButton).add(this.cancelButton)).addContainerGap()));
        this.pack();
    }

    private void goButtonActionPerformed(ActionEvent evt) {
        if (this.worker.isDone() || this.worker.isCancelled()) {
            this.setVisible(false);
        } else {
            this.goButton.setEnabled(false);
            this.worker.execute();
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        if (this.worker != null) {
            this.worker.cancel(true);
        }
        this.setVisible(false);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                File samFile = new File("/Users/jrobinso/IGV/Sam/30DWM.7.sam");
                File idxFile = new File("/Users/jrobinso/IGV/Sam/30DWM.7.sai");
                IndexCreatorDialog dialog = new IndexCreatorDialog((Frame)new JFrame(), true, samFile, idxFile);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    class ProgressListener
    implements PropertyChangeListener {
        private JProgressBar progressBar;

        private ProgressListener() {
        }

        ProgressListener(JProgressBar progressBar) {
            this.progressBar = progressBar;
            this.progressBar.setValue(0);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String strPropertyName = evt.getPropertyName();
            if ("progress".equals(strPropertyName)) {
                this.progressBar.setIndeterminate(false);
                int progress = (Integer)evt.getNewValue();
                this.progressBar.setValue(progress);
            }
        }
    }

    public abstract class IndexWorker<I>
    extends SwingWorker<I, Void> {
        @Override
        protected void done() {
            IndexCreatorDialog.this.setVisible(false);
        }

        public void setTimeRemaining(long timeInMillis) {
            final int timeRemaining = (int)(timeInMillis / 60000L);
            UIUtilities.invokeOnEventThread(new Runnable(){

                @Override
                public void run() {
                    String txt = String.valueOf(timeRemaining) + " minutes";
                    if (timeRemaining == 1) {
                        txt = "1 minute";
                    } else if (timeRemaining < 1) {
                        txt = " < 1 minute";
                    }
                    IndexCreatorDialog.this.timeRemainingLabel.setText(txt);
                }
            });
        }
    }

    private class VCFIndexWorker
    extends IndexWorker<Index> {
        private VCFIndexWorker() {
        }

        @Override
        protected Index doInBackground() throws Exception {
            int binSize = 16000;
            FeatureCodec codec = CodecFactory.getCodec(IndexCreatorDialog.this.file.getAbsolutePath(), GenomeManager.getInstance().getCurrentGenome());
            if (codec != null) {
                try {
                    return IndexFactory.createLinearIndex(IndexCreatorDialog.this.file, codec, binSize);
                }
                catch (TribbleException.MalformedFeatureFile e) {
                    StringBuffer buf = new StringBuffer();
                    buf.append("<html>Files must be sorted by start position prior to indexing.<br>");
                    buf.append(e.getMessage());
                    buf.append("<br><br>Note: igvtools can be used to sort the file, select \"File > Run igvtools...\".");
                    MessageUtils.showMessage(buf.toString());
                }
            } else {
                throw new DataLoadException("Unknown File Type", IndexCreatorDialog.this.file.getAbsolutePath());
            }
            return null;
        }
    }

    public class SamIndexWorker
    extends IndexWorker<FeatureIndex> {
        @Override
        protected FeatureIndex doInBackground() throws Exception {
            AlignmentIndexer indexer = AlignmentIndexer.getInstance(IndexCreatorDialog.this.file, IndexCreatorDialog.this.progressBar, this);
            return indexer.createSamIndex(IndexCreatorDialog.this.idxFile, 16000);
        }
    }

    private static enum FileType {
        SAM,
        VCF;

    }
}

