/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.DataRenderer;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.renderer.Renderer;
import org.broad.igv.renderer.XYPlotRenderer;
import org.broad.igv.session.IGVSessionReader;
import org.broad.igv.session.SessionXmlAdapters;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.LoadedDataInterval;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.util.ResourceLocator;

@XmlType(factoryMethod="getNextTrack")
public abstract class DataTrack
extends AbstractTrack {
    private static Logger log = Logger.getLogger(DataTrack.class);
    private DataRenderer renderer;
    private HashMap<String, LoadedDataInterval> loadedIntervalCache = new HashMap(200);
    private boolean featuresLoading = false;

    public DataTrack(ResourceLocator locator, String id, String name) {
        super(locator, id, name);
        this.autoScale = PreferenceManager.getInstance().getAsBoolean("CHART.AUTOSCALE");
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        if (this.featuresLoading) {
            return;
        }
        String chr = context.getChr();
        int start = (int)context.getOrigin();
        int end = (int)context.getEndLocation() + 1;
        int zoom = context.getZoom();
        List<LocusScore> inViewScores = null;
        LoadedDataInterval interval = this.loadedIntervalCache.get(context.getReferenceFrame().getName());
        if (interval != null && interval.contains(chr, start, end, zoom)) {
            inViewScores = interval.getScores();
        } else {
            int delta = (end - start) / 2;
            int adjustedStart = Math.max(0, start - delta);
            int adjustedEnd = end + delta;
            inViewScores = this.load(context, chr, adjustedStart, adjustedEnd, zoom);
        }
        if ((inViewScores == null || inViewScores.size() == 0) && "All".equals(chr)) {
            Graphics2D g = context.getGraphic2DForColor(Color.gray);
            GraphicUtils.drawCenteredText("Data not available for whole genome view; zoom in to see data", rect, g);
        } else if (this.autoScale && !FrameManager.isGeneListMode() && !FrameManager.isExomeMode()) {
            InViewInterval inter = this.computeScale(start, end, inViewScores);
            if (inter.endIdx > inter.startIdx) {
                inViewScores = inViewScores.subList(inter.startIdx, inter.endIdx);
                DataRange dr = this.getDataRange();
                float min = Math.min(0.0f, inter.dataMin);
                float base = Math.max(min, dr.getBaseline());
                float max = inter.dataMax;
                if (max - min <= 2.8E-45f) {
                    max = min + 1.0f;
                }
                DataRange newDR = new DataRange(min, base, max, dr.isDrawBaseline());
                newDR.setType(dr.getType());
                this.setDataRange(newDR);
            }
        }
        this.getRenderer().render(inViewScores, context, rect, (Track)this);
    }

    @Override
    public synchronized void preload(RenderContext context) {
        LoadedDataInterval interval = this.loadedIntervalCache.get(context.getReferenceFrame().getName());
        String chr = context.getChr();
        int start = (int)context.getOrigin();
        int end = (int)context.getEndLocation() + 1;
        int zoom = context.getZoom();
        if (interval == null || !interval.contains(chr, start, end, zoom)) {
            int delta = (end - start) / 2;
            int adjustedStart = Math.max(0, start - delta);
            int adjustedEnd = end + delta;
            List<LocusScore> scores = this.load(context, chr, adjustedStart, adjustedEnd, zoom);
            if (this.autoScale && FrameManager.isExomeMode()) {
                InViewInterval inter = this.computeScale(start, end, scores);
                if (inter.endIdx > inter.startIdx) {
                    DataRange dr = this.getDataRange();
                    float min = Math.min(0.0f, inter.dataMin);
                    float base = Math.max(min, dr.getBaseline());
                    float max = inter.dataMax;
                    if (max - min <= 2.8E-45f) {
                        max = min + 1.0f;
                    }
                    DataRange newDR = new DataRange(min, base, max, dr.isDrawBaseline());
                    newDR.setType(dr.getType());
                    this.setDataRange(newDR);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LocusScore> load(RenderContext context, String chr, int start, int end, int zoom) {
        try {
            this.featuresLoading = true;
            int maxEnd = end;
            Genome genome = GenomeManager.getInstance().getCurrentGenome();
            String queryChr = chr;
            if (genome != null) {
                queryChr = genome.getChromosomeAlias(chr);
                Chromosome c = genome.getChromosome(chr);
                if (c != null) {
                    maxEnd = Math.max(c.getLength(), end);
                }
            }
            int delta = (end - start) / 2;
            int expandedStart = Math.max(0, start - delta);
            int expandedEnd = Math.min(maxEnd, end + delta);
            List<LocusScore> inViewScores = this.getSummaryScores(queryChr, expandedStart, expandedEnd, zoom);
            LoadedDataInterval interval = new LoadedDataInterval(chr, start, end, zoom, inViewScores);
            this.loadedIntervalCache.put(context.getReferenceFrame().getName(), interval);
            List<LocusScore> list = inViewScores;
            return list;
        }
        finally {
            this.featuresLoading = false;
        }
    }

    public void clearCaches() {
        this.loadedIntervalCache.clear();
    }

    @Override
    public void setRendererClass(Class rc) {
        try {
            this.renderer = (DataRenderer)rc.newInstance();
        }
        catch (Exception ex) {
            log.error("Error instantiating renderer ", ex);
        }
    }

    @Override
    protected void setRenderer(Renderer renderer) {
        this.renderer = (DataRenderer)renderer;
    }

    @Override
    @XmlJavaTypeAdapter(value=SessionXmlAdapters.Renderer.class)
    @XmlAttribute(name="renderer")
    public DataRenderer getRenderer() {
        if (this.renderer == null) {
            this.setRendererClass(this.getDefaultRendererClass());
        }
        return this.renderer;
    }

    @Override
    public String getValueStringAt(String chr, double position, int y, ReferenceFrame frame) {
        StringBuffer buf = new StringBuffer();
        LocusScore score = this.getLocusScoreAt(chr, position, frame);
        if (score == null) {
            return null;
        }
        buf.append(this.getName() + "<br>");
        if (this.getDataRange() != null && this.getRenderer() instanceof XYPlotRenderer) {
            buf.append("Data scale: " + this.getDataRange().getMinimum() + " - " + this.getDataRange().getMaximum() + "<br>");
        }
        buf.append(score.getValueString(position, this.getWindowFunction()));
        return buf.toString();
    }

    private LocusScore getLocusScoreAt(String chr, double position, ReferenceFrame frame) {
        int zoom = Math.max(0, frame.getZoom());
        List<LocusScore> scores = this.getSummaryScores(chr, (int)position - 10, (int)position + 10, zoom);
        if (scores == null) {
            return null;
        }
        double bpPerPixel = frame.getScale();
        int buffer = (int)(2.0 * bpPerPixel);
        return (LocusScore)FeatureUtils.getFeatureAt(position, buffer, scores);
    }

    public abstract List<LocusScore> getSummaryScores(String var1, int var2, int var3, int var4);

    @Override
    public void setColor(Color color) {
        super.setColor(color);
    }

    @Override
    public void setAltColor(Color color) {
        super.setAltColor(color);
    }

    private InViewInterval computeScale(double origin, double end, List<LocusScore> scores) {
        InViewInterval interval = new InViewInterval();
        if (scores.size() == 1) {
            interval.dataMax = Math.max(0.0f, scores.get(0).getScore());
            interval.dataMin = Math.min(0.0f, scores.get(0).getScore());
        } else {
            int i;
            interval.startIdx = 0;
            interval.endIdx = scores.size();
            for (i = 1; i < scores.size(); ++i) {
                if (!((double)scores.get(i).getEnd() >= origin)) continue;
                interval.startIdx = i - 1;
                break;
            }
            for (i = interval.startIdx + 1; i < scores.size(); ++i) {
                LocusScore locusScore = scores.get(i);
                float value = locusScore.getScore();
                if (Float.isNaN(value)) {
                    value = 0.0f;
                }
                interval.dataMax = Math.max(interval.dataMax, value);
                interval.dataMin = Math.min(interval.dataMin, value);
                if (!((double)locusScore.getStart() > end)) continue;
                interval.endIdx = i;
                break;
            }
        }
        return interval;
    }

    @Override
    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType type, String frameName, List<Track> tracks) {
        if (end <= start) {
            return 0.0f;
        }
        if (this.isRegionScoreType(type)) {
            LoadedDataInterval loadedInterval;
            List<LocusScore> scores = null;
            if (frameName == null) {
                frameName = chr + start + end;
                frameName = frameName + zoom;
                frameName = frameName + (Object)((Object)type);
            }
            if ((loadedInterval = this.loadedIntervalCache.get(frameName)) != null && loadedInterval.contains(chr, start, end, zoom)) {
                scores = loadedInterval.getScores();
            } else {
                scores = this.getSummaryScores(chr, start, end, zoom);
                this.loadedIntervalCache.put(frameName, new LoadedDataInterval(chr, start, end, zoom, scores));
            }
            if (type == RegionScoreType.FLUX) {
                float sumDiffs = 0.0f;
                float lastScore = Float.NaN;
                for (LocusScore score : scores) {
                    if (score.getEnd() < start || score.getStart() > end) continue;
                    if (Float.isNaN(lastScore)) {
                        lastScore = Math.min(2.0f, Math.max(-2.0f, this.logScaleData(score.getScore())));
                        continue;
                    }
                    float s = Math.min(2.0f, Math.max(-2.0f, this.logScaleData(score.getScore())));
                    sumDiffs += Math.abs(s - lastScore);
                    lastScore = s;
                }
                return sumDiffs;
            }
            if (type == RegionScoreType.MUTATION_COUNT) {
                if (!Globals.isHeadless() && tracks == null) {
                    tracks = IGV.getInstance().getOverlayTracks(this);
                }
                float count = 0.0f;
                String tSamp = this.getSample();
                if (tracks != null && tSamp != null) {
                    for (Track t : tracks) {
                        if (t.getTrackType() != TrackType.MUTATION || !tSamp.equals(t.getSample())) continue;
                        count += t.getRegionScore(chr, start, end, zoom, type, frameName);
                    }
                }
                return count;
            }
            float regionScore = 0.0f;
            int intervalSum = 0;
            for (LocusScore score : scores) {
                if (score.getEnd() < start || score.getStart() > end) continue;
                int interval = Math.min(end, score.getEnd()) - Math.max(start, score.getStart());
                float value = score.getScore();
                regionScore += value * (float)interval;
                intervalSum += interval;
            }
            if (intervalSum <= 0) {
                return -3.4028235E38f;
            }
            return type == RegionScoreType.DELETION ? -regionScore : (regionScore /= (float)intervalSum);
        }
        return -3.4028235E38f;
    }

    public double getAverageScore(String chr, int start, int end, int zoom) {
        double regionScore = 0.0;
        int intervalSum = 0;
        List<LocusScore> scores = this.getSummaryScores(chr, start, end, zoom);
        for (LocusScore score : scores) {
            if (score.getEnd() < start || score.getStart() > end) continue;
            int interval = 1;
            float value = score.getScore();
            regionScore += (double)(value * (float)interval);
            intervalSum += interval;
        }
        if (intervalSum > 0) {
            regionScore /= (double)intervalSum;
        }
        return regionScore;
    }

    private static DataTrack getNextTrack() {
        return (DataTrack)IGVSessionReader.getNextTrack();
    }

    class InViewInterval {
        int startIdx;
        int endIdx;
        float dataMax = 0.0f;
        float dataMin = 0.0f;

        InViewInterval() {
        }
    }
}

