/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.session;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.broad.igv.feature.RegionOfInterest;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.lists.GeneList;
import org.broad.igv.session.IGVSessionReader;
import org.broad.igv.session.Session;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.track.DataSourceTrack;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.Track;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.TrackFilter;
import org.broad.igv.ui.TrackFilterElement;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.panel.TrackPanel;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.Utilities;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SessionWriter {
    static Logger log = Logger.getLogger(SessionWriter.class);
    Session session;
    private static int CURRENT_VERSION = 5;
    private static final String TRACK_TAG = IGVSessionReader.SessionElement.TRACK.getText();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSession(Session session, File outputFile) throws IOException {
        RuntimeException e;
        if (session == null) {
            e = new RuntimeException("No session found to save!");
            log.error("Session Management Error", e);
        }
        this.session = session;
        if (outputFile == null) {
            e = new RuntimeException("Can't save session file: " + outputFile);
            log.error("Session Management Error", e);
        }
        String xmlString = this.createXmlFromSession(session, outputFile);
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(outputFile);
            fileWriter.write(xmlString);
        }
        finally {
            if (fileWriter != null) {
                fileWriter.close();
            }
        }
    }

    public String createXmlFromSession(Session session, File outputFile) throws RuntimeException {
        String xmlString = null;
        try {
            String groupBy;
            String locus;
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            document.setStrictErrorChecking(true);
            Element globalElement = document.createElement(IGVSessionReader.SessionElement.SESSION.getText());
            globalElement.setAttribute(IGVSessionReader.SessionAttribute.VERSION.getText(), String.valueOf(CURRENT_VERSION));
            String genome = GenomeManager.getInstance().getGenomeId();
            if (genome != null) {
                globalElement.setAttribute(IGVSessionReader.SessionAttribute.GENOME.getText(), genome);
            }
            if ((locus = session.getLocusString()) != null && !FrameManager.isGeneListMode()) {
                globalElement.setAttribute(IGVSessionReader.SessionAttribute.LOCUS.getText(), locus);
            }
            if ((groupBy = IGV.getInstance().getGroupByAttribute()) != null) {
                globalElement.setAttribute(IGVSessionReader.SessionAttribute.GROUP_TRACKS_BY.getText(), groupBy);
            }
            if (session.isRemoveEmptyPanels()) {
                globalElement.setAttribute("removeEmptyTracks", "true");
            }
            this.writeResources(outputFile, globalElement, document);
            this.writePanels(globalElement, document);
            this.writePanelLayout(globalElement, document);
            this.writeRegionsOfInterest(globalElement, document);
            this.writeFilters(session, globalElement, document);
            if (FrameManager.isGeneListMode()) {
                this.writeGeneList(globalElement, document);
            }
            if (session.getHiddenAttributes() != null && session.getHiddenAttributes().size() > 0) {
                this.writeHiddenAttributes(session, globalElement, document);
            }
            document.appendChild(globalElement);
            xmlString = Utilities.getString(document);
        }
        catch (Exception e) {
            String message = "An error has occurred while trying to create the session!";
            log.error(message, e);
            JOptionPane.showMessageDialog(IGV.getMainFrame(), message);
            throw new RuntimeException(e);
        }
        return xmlString;
    }

    private void writeFilters(Session session, Element globalElement, Document document) {
        TrackFilter trackFilter = session.getFilter();
        if (trackFilter != null) {
            Element filter = document.createElement(IGVSessionReader.SessionElement.FILTER.getText());
            filter.setAttribute(IGVSessionReader.SessionAttribute.NAME.getText(), trackFilter.getName());
            if (IGV.getInstance().isFilterMatchAll()) {
                filter.setAttribute(IGVSessionReader.SessionAttribute.FILTER_MATCH.getText(), "all");
            } else if (!IGV.getInstance().isFilterMatchAll()) {
                filter.setAttribute(IGVSessionReader.SessionAttribute.FILTER_MATCH.getText(), "any");
            } else {
                filter.setAttribute(IGVSessionReader.SessionAttribute.FILTER_MATCH.getText(), "all");
            }
            if (IGV.getInstance().isFilterShowAllTracks()) {
                filter.setAttribute(IGVSessionReader.SessionAttribute.FILTER_SHOW_ALL_TRACKS.getText(), "true");
            } else {
                filter.setAttribute(IGVSessionReader.SessionAttribute.FILTER_SHOW_ALL_TRACKS.getText(), "false");
            }
            globalElement.appendChild(filter);
            Iterator iterator = session.getFilter().getFilterElements();
            while (iterator.hasNext()) {
                TrackFilterElement trackFilterElement = (TrackFilterElement)iterator.next();
                Element filterElementElement = document.createElement(IGVSessionReader.SessionElement.FILTER_ELEMENT.getText());
                filterElementElement.setAttribute(IGVSessionReader.SessionAttribute.ITEM.getText(), trackFilterElement.getSelectedItem());
                filterElementElement.setAttribute(IGVSessionReader.SessionAttribute.OPERATOR.getText(), trackFilterElement.getComparisonOperator().getValue());
                filterElementElement.setAttribute(IGVSessionReader.SessionAttribute.VALUE.getText(), trackFilterElement.getValue());
                filterElementElement.setAttribute(IGVSessionReader.SessionAttribute.BOOLEAN_OPERATOR.getText(), trackFilterElement.getBooleanOperator().getValue());
                filter.appendChild(filterElementElement);
            }
        }
    }

    private void writeRegionsOfInterest(Element globalElement, Document document) {
        Collection<RegionOfInterest> regions = this.session.getAllRegionsOfInterest();
        if (regions != null && !regions.isEmpty()) {
            Element regionsElement = document.createElement(IGVSessionReader.SessionElement.REGIONS.getText());
            for (RegionOfInterest region : regions) {
                Element regionElement = document.createElement(IGVSessionReader.SessionElement.REGION.getText());
                regionElement.setAttribute(IGVSessionReader.SessionAttribute.CHROMOSOME.getText(), region.getChr());
                regionElement.setAttribute(IGVSessionReader.SessionAttribute.START_INDEX.getText(), String.valueOf(region.getStart()));
                regionElement.setAttribute(IGVSessionReader.SessionAttribute.END_INDEX.getText(), String.valueOf(region.getEnd()));
                if (region.getDescription() != null) {
                    regionElement.setAttribute(IGVSessionReader.SessionAttribute.DESCRIPTION.getText(), region.getDescription());
                }
                regionsElement.appendChild(regionElement);
            }
            globalElement.appendChild(regionsElement);
        }
    }

    private void writeHiddenAttributes(Session session, Element globalElement, Document document) {
        Element hiddenAttributes = document.createElement(IGVSessionReader.SessionElement.HIDDEN_ATTRIBUTES.getText());
        for (String attribute : session.getHiddenAttributes()) {
            Element regionElement = document.createElement(IGVSessionReader.SessionElement.ATTRIBUTE.getText());
            regionElement.setAttribute(IGVSessionReader.SessionAttribute.NAME.getText(), attribute);
            hiddenAttributes.appendChild(regionElement);
        }
        globalElement.appendChild(hiddenAttributes);
    }

    private void writeGeneList(Element globalElement, Document document) {
        GeneList geneList = this.session.getCurrentGeneList();
        if (geneList != null) {
            Element geneListElement = document.createElement(IGVSessionReader.SessionElement.GENE_LIST.getText());
            geneListElement.setAttribute(IGVSessionReader.SessionAttribute.NAME.getText(), geneList.getName());
            StringBuffer genes = new StringBuffer();
            for (String gene : geneList.getLoci()) {
                genes.append(gene);
                genes.append("\n");
            }
            geneListElement.setTextContent(genes.toString());
            globalElement.appendChild(geneListElement);
            for (ReferenceFrame frame : FrameManager.getFrames()) {
                Element frameElement = document.createElement(IGVSessionReader.SessionElement.FRAME.getText());
                frameElement.setAttribute(IGVSessionReader.SessionAttribute.NAME.getText(), frame.getName());
                frameElement.setAttribute(IGVSessionReader.SessionAttribute.CHR.getText(), frame.getChrName());
                frameElement.setAttribute(IGVSessionReader.SessionAttribute.START.getText(), String.valueOf(frame.getOrigin()));
                frameElement.setAttribute(IGVSessionReader.SessionAttribute.END.getText(), String.valueOf(frame.getEnd()));
                geneListElement.appendChild(frameElement);
            }
        }
    }

    private void writeResources(File outputFile, Element globalElement, Document document) throws IOException {
        Collection<ResourceLocator> resourceLocators = this.getResourceLocatorSet();
        if (resourceLocators != null && !resourceLocators.isEmpty()) {
            Element filesElement = document.createElement(IGVSessionReader.SessionElement.RESOURCES.getText());
            for (ResourceLocator resourceLocator : resourceLocators) {
                if (!resourceLocator.exists() && resourceLocator.getPath() == null) continue;
                Element dataFileElement = document.createElement(IGVSessionReader.SessionElement.RESOURCE.getText());
                dataFileElement.setAttribute(IGVSessionReader.SessionAttribute.PATH.getText(), resourceLocator.getPath());
                if (resourceLocator.getName() != null) {
                    dataFileElement.setAttribute(IGVSessionReader.SessionAttribute.NAME.getText(), resourceLocator.getName());
                }
                if (resourceLocator.getServerURL() != null) {
                    dataFileElement.setAttribute(IGVSessionReader.SessionAttribute.SERVER_URL.getText(), resourceLocator.getServerURL());
                }
                if (resourceLocator.getInfolink() != null) {
                    dataFileElement.setAttribute(IGVSessionReader.SessionAttribute.HYPERLINK.getText(), resourceLocator.getInfolink());
                }
                if (resourceLocator.getUrl() != null) {
                    dataFileElement.setAttribute(IGVSessionReader.SessionAttribute.FEATURE_URL.getText(), resourceLocator.getUrl());
                }
                if (resourceLocator.getDescription() != null) {
                    dataFileElement.setAttribute(IGVSessionReader.SessionAttribute.DESCRIPTION.getText(), resourceLocator.getDescription());
                }
                if (resourceLocator.getType() != null) {
                    dataFileElement.setAttribute(IGVSessionReader.SessionAttribute.TYPE.getText(), resourceLocator.getType());
                }
                if (resourceLocator.getCoverage() != null) {
                    dataFileElement.setAttribute(IGVSessionReader.SessionAttribute.COVERAGE.getText(), resourceLocator.getCoverage());
                }
                if (resourceLocator.getTrackLine() != null) {
                    dataFileElement.setAttribute(IGVSessionReader.SessionAttribute.TRACK_LINE.getText(), resourceLocator.getTrackLine());
                }
                filesElement.appendChild(dataFileElement);
            }
            globalElement.appendChild(filesElement);
        }
    }

    private void writePanels(Element globalElement, Document document) throws DOMException {
        for (TrackPanel trackPanel : IGV.getInstance().getTrackPanels()) {
            List<Track> tracks = trackPanel.getTracks();
            if (tracks == null || tracks.isEmpty()) continue;
            Element panelElement = document.createElement(IGVSessionReader.SessionElement.PANEL.getText());
            panelElement.setAttribute("name", trackPanel.getName());
            panelElement.setAttribute("height", String.valueOf(trackPanel.getHeight()));
            panelElement.setAttribute("width", String.valueOf(trackPanel.getWidth()));
            Element tmpTrackParent = document.createElement("dummy");
            try {
                Marshaller m = IGVSessionReader.getJAXBContext().createMarshaller();
                m.setProperty("jaxb.fragment", (Object)true);
                for (Track track : tracks) {
                    SessionWriter.marshalTrack(m, track, tmpTrackParent, track.getClass());
                    Element trackElement = (Element)tmpTrackParent.getChildNodes().item(0);
                    for (Map.Entry<String, String> attrValue : track.getPersistentState().entrySet()) {
                        trackElement.setAttribute(attrValue.getKey(), attrValue.getValue());
                    }
                    this.marshalTrackChildren(m, track, trackElement);
                    panelElement.appendChild(trackElement);
                }
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
            globalElement.appendChild(panelElement);
        }
    }

    private static void marshalTrack(Marshaller m, Track track, Node trackParent, Class marshalClass) throws JAXBException {
        if (marshalClass == null || marshalClass.equals(Object.class)) {
            throw new JAXBException(track.getClass() + " and none of its superclasses are known");
        }
        if (AbstractTrack.knownUnknownTrackClasses.contains(marshalClass)) {
            SessionWriter.marshalTrack(m, track, trackParent, marshalClass.getSuperclass());
            return;
        }
        try {
            JAXBElement el = new JAXBElement(new QName("", TRACK_TAG), marshalClass, (Object)track);
            m.marshal((Object)el, trackParent);
        }
        catch (JAXBException e) {
            AbstractTrack.knownUnknownTrackClasses.add(marshalClass);
            SessionWriter.marshalTrack(m, track, trackParent, marshalClass.getSuperclass());
        }
    }

    private void marshalTrackChildren(Marshaller m, Track track, Element trackElement) throws JAXBException {
        if (track instanceof FeatureTrack) {
            FeatureTrack featureTrack = (FeatureTrack)track;
            featureTrack.marshalSource(m, trackElement);
        } else if (track instanceof DataSourceTrack) {
            DataSourceTrack dataSourceTrack = (DataSourceTrack)track;
            dataSourceTrack.marshalSource(m, trackElement);
        }
    }

    private void writePanelLayout(Element globalElement, Document document) {
        double[] dividerFractions = IGV.getInstance().getMainPanel().getDividerFractions();
        if (dividerFractions.length > 0) {
            Element panelLayout = document.createElement(IGVSessionReader.SessionElement.PANEL_LAYOUT.getText());
            globalElement.appendChild(panelLayout);
            StringBuffer locString = new StringBuffer();
            locString.append(String.valueOf(dividerFractions[0]));
            for (int i = 1; i < dividerFractions.length; ++i) {
                locString.append("," + dividerFractions[i]);
            }
            panelLayout.setAttribute("dividerFractions", locString.toString());
        }
    }

    public Collection<ResourceLocator> getResourceLocatorSet() {
        Set<ResourceLocator> loadedAttributeResources;
        ArrayList<ResourceLocator> locators = new ArrayList<ResourceLocator>();
        Set<ResourceLocator> currentTrackFileLocators = IGV.getInstance().getDataResourceLocators();
        if (currentTrackFileLocators != null) {
            for (ResourceLocator locator : currentTrackFileLocators) {
                locators.add(locator);
            }
        }
        if ((loadedAttributeResources = AttributeManager.getInstance().getLoadedResources()) != null) {
            for (ResourceLocator attributeLocator : loadedAttributeResources) {
                locators.add(attributeLocator);
            }
        }
        return locators;
    }
}

