/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecordIterator;
import net.sf.samtools.SAMSequenceRecord;
import net.sf.samtools.util.CloseableIterator;
import org.apache.log4j.Logger;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.SamAlignment;
import org.broad.igv.sam.reader.AlignmentReader;
import org.broad.igv.sam.reader.AlignmentReaderFactory;
import org.broad.igv.sam.reader.WrappedIterator;
import org.broad.igv.ui.util.MessageUtils;

public class BAMFileReader
implements AlignmentReader {
    private static Logger log = Logger.getLogger(BAMFileReader.class);
    SAMFileReader reader;
    SAMFileHeader header;

    public BAMFileReader(File bamFile) {
        try {
            File indexFile = BAMFileReader.findIndexFile(bamFile);
            this.reader = new SAMFileReader(bamFile, indexFile);
            this.reader.setValidationStringency(SAMFileReader.ValidationStringency.SILENT);
            this.reader.enableFileSource(SamAlignment.DEFAULT_LAZY_LOAD);
            this.loadHeader();
        }
        catch (Exception e) {
            MessageUtils.showMessage("Error loading SAM header: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private SAMFileHeader getHeader() {
        if (this.header == null) {
            this.loadHeader();
        }
        return this.header;
    }

    @Override
    public List<String> getSequenceNames() {
        SAMFileHeader header = this.getHeader();
        if (header == null) {
            return null;
        }
        ArrayList<String> seqNames = new ArrayList<String>();
        List<SAMSequenceRecord> records = header.getSequenceDictionary().getSequences();
        if (records.size() > 0) {
            for (SAMSequenceRecord rec : header.getSequenceDictionary().getSequences()) {
                String chr = rec.getSequenceName();
                seqNames.add(chr);
            }
        }
        return seqNames;
    }

    @Override
    public Set<String> getPlatforms() {
        return AlignmentReaderFactory.getPlatforms(this.getHeader());
    }

    private void loadHeader() {
        this.header = this.reader.getFileHeader();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public boolean hasIndex() {
        return this.reader.hasIndex();
    }

    @Override
    public CloseableIterator<Alignment> query(String sequence, int start, int end, boolean contained) {
        SAMRecordIterator query = null;
        try {
            query = this.reader.query(sequence, start + 1, end, contained);
            return new WrappedIterator(query);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            log.error("Error querying BAM file ", e);
            MessageUtils.showMessage("Error reading bam file.  This usually indicates a problem with the index (bai) file.<br>" + e.toString() + " (" + e.getMessage() + ")");
            return EmptyIterator.instance;
        }
    }

    @Override
    public CloseableIterator<Alignment> iterator() {
        return new WrappedIterator(this.reader.iterator());
    }

    private static File findIndexFile(File dataFile) {
        String bamPath = dataFile.getAbsolutePath();
        String bai = bamPath + ".bai";
        File indexFile1 = new File(bai);
        if (indexFile1.length() > 0L) {
            return indexFile1;
        }
        String bamExtension = ".bam";
        File indexFile2 = null;
        if (bamPath.toLowerCase().endsWith(".bam") && (indexFile2 = new File(bai = bamPath.substring(0, bamPath.length() - ".bam".length()) + ".bai")).length() > 0L) {
            return indexFile2;
        }
        log.info("Index file: " + indexFile1.getAbsolutePath() + " not found");
        if (indexFile2 != null) {
            log.info("Index file: " + indexFile2.getAbsolutePath() + " not Found");
        }
        return null;
    }

    public static class EmptyIterator
    implements CloseableIterator<Alignment> {
        public static final EmptyIterator instance = new EmptyIterator();

        @Override
        public void close() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Alignment next() {
            return null;
        }

        @Override
        public void remove() {
        }
    }
}

